/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeType;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.model.MemberSetters;
import software.amazon.awssdk.codegen.poet.model.ServiceModelCopiers;
import software.amazon.awssdk.codegen.poet.model.TypeProvider;
import software.amazon.awssdk.core.SdkBytes;

abstract class AbstractMemberSetters
implements MemberSetters {
    protected final PoetExtensions poetExtensions;
    private final ShapeModel shapeModel;
    private final MemberModel memberModel;
    private final IntermediateModel intermediateModel;
    private final TypeProvider typeProvider;
    private final ServiceModelCopiers serviceModelCopiers;

    AbstractMemberSetters(IntermediateModel intermediateModel, ShapeModel shapeModel, MemberModel memberModel, TypeProvider typeProvider) {
        this.shapeModel = shapeModel;
        this.memberModel = memberModel;
        this.intermediateModel = intermediateModel;
        this.typeProvider = typeProvider;
        this.serviceModelCopiers = new ServiceModelCopiers(intermediateModel);
        this.poetExtensions = new PoetExtensions(intermediateModel);
    }

    protected MethodSpec.Builder fluentAbstractSetterDeclaration(ParameterSpec parameter, TypeName returnType) {
        return this.fluentSetterDeclaration(parameter, returnType).addModifiers(new Modifier[]{Modifier.ABSTRACT});
    }

    protected MethodSpec.Builder fluentAbstractSetterDeclaration(String methodName, ParameterSpec parameter, TypeName returnType) {
        return this.setterDeclaration(methodName, parameter, returnType).addModifiers(new Modifier[]{Modifier.ABSTRACT});
    }

    protected MethodSpec.Builder fluentDefaultSetterDeclaration(ParameterSpec parameter, TypeName returnType) {
        return this.fluentSetterDeclaration(parameter, returnType).addModifiers(new Modifier[]{Modifier.DEFAULT});
    }

    protected MethodSpec.Builder fluentSetterBuilder(TypeName returnType) {
        return this.fluentSetterBuilder(this.memberAsParameter(), returnType);
    }

    protected MethodSpec.Builder fluentSetterBuilder(ParameterSpec setterParam, TypeName returnType) {
        return this.fluentSetterBuilder(this.memberModel().getFluentSetterMethodName(), setterParam, returnType);
    }

    protected MethodSpec.Builder fluentSetterBuilder(String methodName, ParameterSpec setterParam, TypeName returnType) {
        return MethodSpec.methodBuilder((String)methodName).addParameter(setterParam).addAnnotation(Override.class).returns(returnType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
    }

    protected MethodSpec.Builder beanStyleSetterBuilder() {
        return this.beanStyleSetterBuilder(this.memberAsBeanStyleParameter());
    }

    protected MethodSpec.Builder beanStyleSetterBuilder(ParameterSpec setterParam) {
        return MethodSpec.methodBuilder((String)this.memberModel().getBeanStyleSetterMethodName()).addParameter(setterParam).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
    }

    protected CodeBlock copySetterBody() {
        return this.copySetterBody("this.$1N = $2T.$3N($1N)", "this.$1N = $1N", this.serviceModelCopiers.copyMethodName());
    }

    protected CodeBlock fluentSetterWithEnumCollectionsParameterMethodBody() {
        return this.copySetterBody("this.$1N = $2T.$3N($1N)", "this.$1N = $1N", this.serviceModelCopiers.enumToStringCopyMethodName());
    }

    protected CodeBlock copySetterBodyWithModeledEnumParameter() {
        return this.copySetterBody("this.$1N = $2T.$3N($1N)", "this.$1N = $1N", this.serviceModelCopiers.enumToStringCopyMethodName());
    }

    protected CodeBlock copySetterBuilderBody() {
        if (this.memberModel.hasBuilder()) {
            return this.copySetterBody("this.$1N = $1N != null ? $2T.$3N($1N.build()) : null", "this.$1N = $1N != null ? $1N.build() : null", this.serviceModelCopiers.copyMethodName());
        }
        if (this.memberModel.isCollectionWithBuilderMember()) {
            return this.copySetterBody("this.$1N = $2T.$3N($1N)", null, this.serviceModelCopiers.builderCopyMethodName());
        }
        return this.copySetterBody();
    }

    protected CodeBlock beanCopySetterBody() {
        if (this.memberModel.isSdkBytesType()) {
            return this.sdkBytesGetter();
        }
        if (this.memberModel.isList() && this.memberModel.getListModel().getListMemberModel().isSdkBytesType()) {
            return this.sdkBytesListGetter();
        }
        if (this.memberModel.isMap() && this.memberModel.getMapModel().getValueModel().isSdkBytesType()) {
            return this.sdkBytesMapValueGetter();
        }
        return this.copySetterBuilderBody();
    }

    private CodeBlock sdkBytesGetter() {
        return CodeBlock.of((String)"$1N($1N == null ? null : $2T.fromByteBuffer($1N));", (Object[])new Object[]{this.memberModel.getVariable().getVariableName(), SdkBytes.class});
    }

    private CodeBlock sdkBytesListGetter() {
        return CodeBlock.of((String)"$1N($1N == null ? null : $1N.stream().map($2T::fromByteBuffer).collect($3T.toList()));", (Object[])new Object[]{this.memberModel.getVariable().getVariableName(), SdkBytes.class, Collectors.class});
    }

    private CodeBlock sdkBytesMapValueGetter() {
        return CodeBlock.of((String)"$1N($1N == null ? null : $1N.entrySet().stream().collect($3T.toMap(e -> e.getKey(), e -> $2T.fromByteBuffer(e.getValue()))));", (Object[])new Object[]{this.memberModel.getVariable().getVariableName(), SdkBytes.class, Collectors.class});
    }

    protected ParameterSpec memberAsParameter() {
        return ParameterSpec.builder((TypeName)this.typeProvider.parameterType(this.memberModel), (String)this.fieldName(), (Modifier[])new Modifier[0]).build();
    }

    protected ParameterSpec memberAsBeanStyleParameter() {
        if (this.memberModel.hasBuilder()) {
            ClassName builderName = this.poetExtensions.getModelClass(this.memberModel.getC2jShape()).nestedClass("BuilderImpl");
            return ParameterSpec.builder((TypeName)builderName, (String)this.fieldName(), (Modifier[])new Modifier[0]).build();
        }
        if (this.memberModel.isList()) {
            MemberModel listMember = this.memberModel.getListModel().getListMemberModel();
            if (this.hasBuilder(listMember)) {
                ClassName memberName = this.poetExtensions.getModelClass(listMember.getC2jShape()).nestedClass("BuilderImpl");
                ParameterizedTypeName listType = ParameterizedTypeName.get((ClassName)ClassName.get(Collection.class), (TypeName[])new TypeName[]{memberName});
                return ParameterSpec.builder((TypeName)listType, (String)this.fieldName(), (Modifier[])new Modifier[0]).build();
            }
            if (listMember.isSdkBytesType()) {
                ParameterizedTypeName listType = ParameterizedTypeName.get(Collection.class, (Type[])new Type[]{ByteBuffer.class});
                return ParameterSpec.builder((TypeName)listType, (String)this.fieldName(), (Modifier[])new Modifier[0]).build();
            }
        }
        if (this.memberModel.isMap()) {
            MemberModel keyModel = this.memberModel.getMapModel().getKeyModel();
            TypeName keyType = this.typeProvider.getTypeNameForSimpleType(keyModel.getVariable().getVariableType());
            MemberModel valueModel = this.memberModel.getMapModel().getValueModel();
            TypeName valueType = null;
            if (this.hasBuilder(valueModel)) {
                valueType = this.poetExtensions.getModelClass(valueModel.getC2jShape()).nestedClass("BuilderImpl");
            } else if (valueModel.isSdkBytesType()) {
                valueType = TypeName.get(ByteBuffer.class);
            }
            if (valueType != null) {
                ParameterizedTypeName mapType = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{keyType, valueType});
                return ParameterSpec.builder((TypeName)mapType, (String)this.fieldName(), (Modifier[])new Modifier[0]).build();
            }
        }
        if (this.memberModel.isSdkBytesType()) {
            return ParameterSpec.builder(ByteBuffer.class, (String)this.fieldName(), (Modifier[])new Modifier[0]).build();
        }
        return this.memberAsParameter();
    }

    protected ShapeModel shapeModel() {
        return this.shapeModel;
    }

    protected MemberModel memberModel() {
        return this.memberModel;
    }

    protected String fieldName() {
        return this.memberModel.getVariable().getVariableName();
    }

    protected boolean annotateJsonProperty() {
        return this.intermediateModel.getMetadata().isJsonProtocol() && this.shapeModel.getShapeType() == ShapeType.Exception;
    }

    private MethodSpec.Builder fluentSetterDeclaration(ParameterSpec parameter, TypeName returnType) {
        return this.setterDeclaration(this.memberModel().getFluentSetterMethodName(), parameter, returnType);
    }

    private MethodSpec.Builder setterDeclaration(String methodName, ParameterSpec parameter, TypeName returnType) {
        return MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(parameter).returns(returnType);
    }

    private CodeBlock copySetterBody(String copyAssignment, String regularAssignment, String copyMethodName) {
        Optional<ClassName> copierClass = this.serviceModelCopiers.copierClassFor(this.memberModel);
        return copierClass.map(className -> CodeBlock.builder().addStatement(copyAssignment, new Object[]{this.fieldName(), className, copyMethodName}).build()).orElseGet(() -> CodeBlock.builder().addStatement(regularAssignment, new Object[]{this.fieldName()}).build());
    }

    private boolean hasBuilder(MemberModel model) {
        return model != null && model.hasBuilder();
    }
}

