/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.eventstream;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.eventstream.DefaultEventStreamResponseHandlerBuilder;
import software.amazon.awssdk.awscore.eventstream.EventStreamResponseHandlerFromBuilder;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskParams;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.eventstream.EventStreamResponseHandlerBuilderInterfaceSpec;
import software.amazon.awssdk.codegen.poet.eventstream.EventStreamUtils;

public class EventStreamResponseHandlerBuilderImplSpec
extends EventStreamResponseHandlerBuilderInterfaceSpec {
    private final PoetExtensions poetExt;
    private final ClassName responseHandlerType;
    private final ClassName responseHandlerBuilderType;
    private final ClassName eventStreamBaseClass;

    public EventStreamResponseHandlerBuilderImplSpec(GeneratorTaskParams params, EventStreamUtils eventStreamUtils) {
        super(eventStreamUtils);
        this.poetExt = params.getPoetExtensions();
        this.responseHandlerType = eventStreamUtils.responseHandlerType();
        this.responseHandlerBuilderType = eventStreamUtils.responseHandlerBuilderType();
        this.eventStreamBaseClass = eventStreamUtils.eventStreamBaseClass();
    }

    @Override
    protected TypeSpec.Builder createTypeSpecBuilder() {
        ClassName responsePojoType = this.eventStreamUtils.responsePojoType();
        ParameterizedTypeName superBuilderClass = ParameterizedTypeName.get((ClassName)ClassName.get(DefaultEventStreamResponseHandlerBuilder.class), (TypeName[])new TypeName[]{responsePojoType, this.eventStreamBaseClass, this.responseHandlerBuilderType});
        return PoetUtils.createClassBuilder(this.className()).addModifiers(new Modifier[]{Modifier.FINAL}).addAnnotation(SdkInternalApi.class).superclass((TypeName)superBuilderClass).addSuperinterface((TypeName)super.className()).addType(this.implInnerClass(responsePojoType));
    }

    @Override
    protected MethodSpec.Builder applySubscriberMethodSpecUpdates(MethodSpec.Builder builder) {
        return builder.addAnnotation(Override.class).addCode(CodeBlock.builder().addStatement("subscriber(e -> e.accept(visitor))", new Object[0]).addStatement("return this", new Object[0]).build());
    }

    @Override
    protected MethodSpec.Builder applyBuildMethodSpecUpdates(MethodSpec.Builder builder) {
        return builder.addAnnotation(Override.class).addCode(CodeBlock.builder().addStatement("return new Impl(this)", new Object[0]).build());
    }

    @Override
    public ClassName className() {
        String className = String.format("Default%sResponseHandlerBuilder", this.eventStreamUtils.getApiName());
        return this.poetExt.getModelClass(className);
    }

    private TypeSpec implInnerClass(ClassName responseClass) {
        ParameterizedTypeName superImplClass = ParameterizedTypeName.get((ClassName)ClassName.get(EventStreamResponseHandlerFromBuilder.class), (TypeName[])new TypeName[]{responseClass, this.eventStreamBaseClass});
        return PoetUtils.createClassBuilder(this.className().nestedClass("Impl")).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).superclass((TypeName)superImplClass).addSuperinterface((TypeName)this.responseHandlerType).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter(ParameterSpec.builder((TypeName)this.className(), (String)"builder", (Modifier[])new Modifier[0]).build()).addStatement("super(builder)", new Object[0]).build()).build();
    }
}

