/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.client.specs;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.WildcardTypeName;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.awscore.eventstream.EventStreamAsyncResponseTransformer;
import software.amazon.awssdk.awscore.eventstream.EventStreamTaggedUnionJsonUnmarshaller;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.Metadata;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.Protocol;
import software.amazon.awssdk.codegen.model.intermediate.ShapeType;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.client.specs.ProtocolSpec;
import software.amazon.awssdk.codegen.poet.eventstream.EventStreamUtils;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.internal.protocol.json.VoidJsonUnmarshaller;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.runtime.transform.StreamingRequestMarshaller;

public class JsonProtocolSpec
implements ProtocolSpec {
    private final PoetExtensions poetExtensions;

    public JsonProtocolSpec(PoetExtensions poetExtensions) {
        this.poetExtensions = poetExtensions;
    }

    @Override
    public FieldSpec protocolFactory(IntermediateModel model) {
        return FieldSpec.builder(AwsJsonProtocolFactory.class, (String)"protocolFactory", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
    }

    @Override
    public MethodSpec initProtocolFactory(IntermediateModel model) {
        ClassName baseException = this.baseExceptionClassName(model);
        Metadata metadata = model.getMetadata();
        ClassName protocolFactory = this.poetExtensions.getClientClass(metadata.getProtocolFactory());
        MethodSpec.Builder methodSpec = MethodSpec.methodBuilder((String)"init").addParameter(TypeName.BOOLEAN, "supportsCbor", new Modifier[0]).returns((TypeName)protocolFactory).addModifiers(new Modifier[]{Modifier.PRIVATE}).addCode("return new $T(new $T()\n.withSupportsCbor(supportsCbor)\n.withSupportsIon($L).withBaseServiceExceptionClass($L.class)", new Object[]{AwsJsonProtocolFactory.class, JsonClientMetadata.class, metadata.isIonProtocol(), baseException});
        if (metadata.getContentType() != null) {
            methodSpec.addCode(".withContentTypeOverride($S)", new Object[]{metadata.getContentType()});
        }
        this.errorUnmarshallers(model).forEach(arg_0 -> ((MethodSpec.Builder)methodSpec).addCode(arg_0));
        methodSpec.addCode(",\n", new Object[0]);
        methodSpec.addCode("$T.builder().protocolVersion($S)\n.protocol($T.$L).build()", new Object[]{AwsJsonProtocolMetadata.class, metadata.getJsonVersion(), AwsJsonProtocol.class, this.protocolEnumName(metadata.getProtocol())});
        methodSpec.addCode(");", new Object[0]);
        return methodSpec.build();
    }

    @Override
    public CodeBlock responseHandler(IntermediateModel model, OperationModel opModel) {
        ClassName unmarshaller = this.getUnmarshallerType(opModel);
        TypeName pojoResponseType = this.getPojoResponseType(opModel);
        String protocolFactory = opModel.hasEventStreamOutput() ? "jsonProtocolFactory" : "protocolFactory";
        CodeBlock.Builder builder = CodeBlock.builder().add("\n\n$T<$T> responseHandler = $L.createResponseHandler(new $T()                                   .withPayloadJson($L)                                   .withHasStreamingSuccessResponse($L), new $T());", new Object[]{HttpResponseHandler.class, pojoResponseType, protocolFactory, JsonOperationMetadata.class, !opModel.getHasBlobMemberAsPayload(), opModel.hasStreamingOutput(), unmarshaller});
        if (opModel.hasEventStreamOutput()) {
            builder.add("\n\n$T<$T> voidResponseHandler = $L.createResponseHandler(new $T()                                   .withPayloadJson(false)                                   .withHasStreamingSuccessResponse(true), new $T());", new Object[]{HttpResponseHandler.class, SdkResponse.class, protocolFactory, JsonOperationMetadata.class, VoidJsonUnmarshaller.class});
            EventStreamUtils eventStreamUtils = EventStreamUtils.create(this.poetExtensions, opModel);
            ClassName eventStreamBaseClass = eventStreamUtils.eventStreamBaseClass();
            builder.add("\n\n$T<$T> eventResponseHandler = $L.createResponseHandler(new $T()                                   .withPayloadJson($L)                                   .withHasStreamingSuccessResponse($L), $T.builder()", new Object[]{HttpResponseHandler.class, WildcardTypeName.subtypeOf((TypeName)eventStreamBaseClass), protocolFactory, JsonOperationMetadata.class, true, false, ClassName.get(EventStreamTaggedUnionJsonUnmarshaller.class)});
            eventStreamUtils.getEventStreamMembers().forEach(m -> {
                String unmarshallerClassName = m.getShape().getVariable().getVariableType() + "Unmarshaller";
                builder.add(".addUnmarshaller(\"$L\", $T.getInstance())\n", new Object[]{m.getC2jName(), this.poetExtensions.getTransformClass(unmarshallerClassName)});
            });
            builder.add(".defaultUnmarshaller((in) -> $T.UNKNOWN)\n.build());\n", new Object[]{eventStreamUtils.eventStreamBaseClass()});
        }
        return builder.build();
    }

    @Override
    public CodeBlock errorResponseHandler(OperationModel opModel) {
        String protocolFactory = opModel.hasEventStreamOutput() ? "jsonProtocolFactory" : "protocolFactory";
        return CodeBlock.builder().add("\n\n$T<$T> errorResponseHandler = createErrorResponseHandler($L);", new Object[]{HttpResponseHandler.class, AwsServiceException.class, protocolFactory}).build();
    }

    @Override
    public CodeBlock executionHandler(OperationModel opModel) {
        TypeName responseType = this.getPojoResponseType(opModel);
        ClassName requestType = this.poetExtensions.getModelClass(opModel.getInput().getVariableType());
        ClassName marshaller = this.poetExtensions.getRequestTransformClass(opModel.getInputShape().getShapeName() + "Marshaller");
        CodeBlock.Builder codeBlock = CodeBlock.builder().add("\n\nreturn clientHandler.execute(new $T<$T, $T>()\n.withResponseHandler($N)\n.withErrorResponseHandler($N)\n.withInput($L)\n", new Object[]{ClientExecutionParams.class, requestType, responseType, "responseHandler", "errorResponseHandler", opModel.getInput().getVariableName()});
        if (opModel.hasStreamingInput()) {
            codeBlock.add(".withMarshaller(new $T(new $T(protocolFactory), requestBody))", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(StreamingRequestMarshaller.class), (TypeName[])new TypeName[]{requestType}), marshaller});
        } else {
            codeBlock.add(".withMarshaller(new $T(protocolFactory))", new Object[]{marshaller});
        }
        return codeBlock.add("$L);", new Object[]{opModel.hasStreamingOutput() ? ", responseTransformer" : ""}).build();
    }

    @Override
    public CodeBlock asyncExecutionHandler(OperationModel opModel) {
        TypeName pojoResponseType = this.getPojoResponseType(opModel);
        ClassName requestType = this.poetExtensions.getModelClass(opModel.getInput().getVariableType());
        ClassName marshaller = this.poetExtensions.getRequestTransformClass(opModel.getInputShape().getShapeName() + "Marshaller");
        String asyncRequestBody = opModel.hasStreamingInput() ? ".withAsyncRequestBody(requestBody)" : "";
        CodeBlock.Builder builder = CodeBlock.builder();
        if (opModel.hasEventStreamOutput()) {
            ClassName eventStreamBaseClass = EventStreamUtils.create(this.poetExtensions, opModel).eventStreamBaseClass();
            ParameterizedTypeName transformerType = ParameterizedTypeName.get((ClassName)ClassName.get(EventStreamAsyncResponseTransformer.class), (TypeName[])new TypeName[]{pojoResponseType, eventStreamBaseClass});
            builder.addStatement("$1T<$2T> future = new $1T<>()", new Object[]{ClassName.get(CompletableFuture.class), ClassName.get(Void.class)});
            builder.add("$T asyncResponseTransformer = $T.<$T, $T>builder()\n     .eventStreamResponseHandler(asyncResponseHandler)\n   .eventResponseHandler(eventResponseHandler)\n   .initialResponseHandler(responseHandler)\n   .exceptionResponseHandler(errorResponseHandler)\n   .future(future)\n   .executor(executor)\n   .serviceName(serviceName())\n   .build();", new Object[]{transformerType, ClassName.get(EventStreamAsyncResponseTransformer.class), pojoResponseType, eventStreamBaseClass});
        }
        boolean isStreaming = opModel.hasStreamingOutput() || opModel.hasEventStreamOutput();
        String protocolFactory = opModel.hasEventStreamOutput() ? "jsonProtocolFactory" : "protocolFactory";
        String customerResponseHandler = opModel.hasEventStreamOutput() ? "asyncResponseHandler" : "asyncResponseTransformer";
        builder.add("\n\n$L clientHandler.execute(new $T<$T, $T>()\n.withMarshaller(new $T($L))\n.withResponseHandler($L)\n.withErrorResponseHandler(errorResponseHandler)\n" + asyncRequestBody + ".withInput($L)$L)$L;", new Object[]{opModel.hasEventStreamOutput() ? "" : "return", ClientExecutionParams.class, requestType, opModel.hasEventStreamOutput() ? SdkResponse.class : pojoResponseType, marshaller, protocolFactory, opModel.hasEventStreamOutput() ? "voidResponseHandler" : "responseHandler", opModel.getInput().getVariableName(), isStreaming ? ", asyncResponseTransformer" : "", this.whenCompleteBody(opModel, customerResponseHandler)});
        if (opModel.hasEventStreamOutput()) {
            builder.addStatement("return future", new Object[0]);
        }
        return builder.build();
    }

    private String whenCompleteBody(OperationModel operationModel, String responseHandlerName) {
        if (operationModel.hasEventStreamOutput()) {
            return this.eventStreamOutputWhenComplete(responseHandlerName);
        }
        if (operationModel.hasStreamingOutput()) {
            return this.streamingOutputWhenComplete(responseHandlerName);
        }
        return "";
    }

    private String streamingOutputWhenComplete(String responseHandlerName) {
        return String.format(".whenComplete((r, e) -> {%n     if (e != null) {%n         %s.exceptionOccurred(e);%n     }%n})", responseHandlerName);
    }

    private String eventStreamOutputWhenComplete(String responseHandlerName) {
        return String.format(".whenComplete((r, e) -> {%n     if (e != null) {%n         try {             %s.exceptionOccurred(e);%n         } finally {             future.completeExceptionally(e);         }     }%n})", responseHandlerName);
    }

    private ClassName getUnmarshallerType(OperationModel opModel) {
        return this.poetExtensions.getTransformClass(opModel.getReturnType().getReturnType() + "Unmarshaller");
    }

    private TypeName getPojoResponseType(OperationModel opModel) {
        return this.poetExtensions.getModelClass(opModel.getReturnType().getReturnType());
    }

    @Override
    public Optional<MethodSpec> createErrorResponseHandler() {
        ClassName httpResponseHandler = ClassName.get(HttpResponseHandler.class);
        ClassName sdkBaseException = ClassName.get(AwsServiceException.class);
        ParameterizedTypeName responseHandlerOfException = ParameterizedTypeName.get((ClassName)httpResponseHandler, (TypeName[])new TypeName[]{sdkBaseException});
        return Optional.of(MethodSpec.methodBuilder((String)"createErrorResponseHandler").addParameter(AwsJsonProtocolFactory.class, "protocolFactory", new Modifier[0]).returns((TypeName)responseHandlerOfException).addModifiers(new Modifier[]{Modifier.PRIVATE}).addStatement("return protocolFactory.createErrorResponseHandler(new $T())", new Object[]{JsonErrorResponseMetadata.class}).build());
    }

    @Override
    public List<CodeBlock> errorUnmarshallers(IntermediateModel model) {
        List exceptions = model.getShapes().values().stream().filter(s -> s.getShapeType().equals((Object)ShapeType.Exception)).collect(Collectors.toList());
        return exceptions.stream().map(s -> {
            ClassName exceptionClass = this.poetExtensions.getModelClass(s.getShapeName());
            return CodeBlock.builder().add(".addErrorMetadata(new $T().withErrorCode($S).withModeledClass($T.class))", new Object[]{JsonErrorShapeMetadata.class, s.getErrorCode(), exceptionClass}).build();
        }).collect(Collectors.toList());
    }

    private String protocolEnumName(Protocol protocol) {
        switch (protocol) {
            case CBOR: 
            case ION: 
            case AWS_JSON: {
                return Protocol.AWS_JSON.name();
            }
        }
        return protocol.name();
    }

    private ClassName baseExceptionClassName(IntermediateModel model) {
        String exceptionPath = model.getSdkModeledExceptionBaseFqcn().substring(0, model.getSdkModeledExceptionBaseFqcn().lastIndexOf("."));
        return ClassName.get((String)exceptionPath, (String)model.getSdkModeledExceptionBaseClassName(), (String[])new String[0]);
    }
}

