/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.paginators;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.service.PaginatorDefinition;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.paginators.PaginatorsClassSpec;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;

public class AsyncResponseClassSpec
extends PaginatorsClassSpec {
    private static final String SUBSCRIBER = "subscriber";
    private static final String SUBSCRIBE_METHOD = "subscribe";
    private static final String LAST_PAGE_FIELD = "isLastPage";
    private static final String LAST_PAGE_METHOD = "withLastPage";

    public AsyncResponseClassSpec(IntermediateModel model, String c2jOperationName, PaginatorDefinition paginatorDefinition) {
        super(model, c2jOperationName, paginatorDefinition);
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder specBuilder = TypeSpec.classBuilder((ClassName)this.className()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(PoetUtils.generatedAnnotation()).addSuperinterface(this.getAsyncResponseInterface()).addFields((Iterable)Stream.of(this.asyncClientInterfaceField(), this.requestClassField(), this.asyncPageFetcherField(), this.lastPageField()).collect(Collectors.toList())).addMethod(this.publicConstructor()).addMethod(this.privateConstructor()).addMethod(this.subscribeMethod()).addMethods(this.getMethodSpecsForResultKeyList()).addMethod(this.resumeMethod()).addJavadoc(this.paginationDocs.getDocsForAsyncResponseClass(this.getAsyncClientInterfaceName()), new Object[0]).addType(this.nextPageFetcherClass());
        return specBuilder.build();
    }

    @Override
    public ClassName className() {
        return this.poetExtensions.getResponseClassForPaginatedAsyncOperation(this.c2jOperationName);
    }

    private TypeName getAsyncResponseInterface() {
        return ParameterizedTypeName.get((ClassName)ClassName.get(SdkPublisher.class), (TypeName[])new TypeName[]{this.responseType()});
    }

    private ClassName getAsyncClientInterfaceName() {
        return this.poetExtensions.getClientClass(this.model.getMetadata().getAsyncInterface());
    }

    private FieldSpec asyncClientInterfaceField() {
        return FieldSpec.builder((TypeName)this.getAsyncClientInterfaceName(), (String)"client", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
    }

    private FieldSpec asyncPageFetcherField() {
        return FieldSpec.builder(AsyncPageFetcher.class, (String)"nextPageFetcher", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
    }

    private FieldSpec lastPageField() {
        return FieldSpec.builder(Boolean.TYPE, (String)LAST_PAGE_FIELD, (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
    }

    private MethodSpec publicConstructor() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)this.getAsyncClientInterfaceName(), "client", new Modifier[0]).addParameter((TypeName)this.requestType(), "firstRequest", new Modifier[0]).addStatement("this($L, $L, false)", new Object[]{"client", "firstRequest"}).build();
    }

    private MethodSpec privateConstructor() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)this.getAsyncClientInterfaceName(), "client", new Modifier[0]).addParameter((TypeName)this.requestType(), "firstRequest", new Modifier[0]).addParameter(Boolean.TYPE, LAST_PAGE_FIELD, new Modifier[0]).addStatement("this.$L = $L", new Object[]{"client", "client"}).addStatement("this.$L = $L", new Object[]{"firstRequest", "firstRequest"}).addStatement("this.$L = $L", new Object[]{LAST_PAGE_FIELD, LAST_PAGE_FIELD}).addStatement("this.$L = new $L()", new Object[]{"nextPageFetcher", this.nextPageFetcherClassName()}).build();
    }

    private MethodSpec subscribeMethod() {
        return MethodSpec.methodBuilder((String)SUBSCRIBE_METHOD).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Subscriber.class), (TypeName[])new TypeName[]{WildcardTypeName.supertypeOf((TypeName)this.responseType())}), SUBSCRIBER, new Modifier[0]).addStatement("$1L.onSubscribe($2T.builder().$1L($1L).$3L($3L).build())", new Object[]{SUBSCRIBER, ResponsesSubscription.class, "nextPageFetcher"}).build();
    }

    private Iterable<MethodSpec> getMethodSpecsForResultKeyList() {
        if (this.paginatorDefinition.getResultKey() != null) {
            return this.paginatorDefinition.getResultKey().stream().map(this::getMethodsSpecForSingleResultKey).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private MethodSpec getMethodsSpecForSingleResultKey(String resultKey) {
        TypeName resultKeyType = this.getTypeForResultKey(resultKey);
        MemberModel resultKeyModel = this.memberModelForResponseMember(resultKey);
        return MethodSpec.methodBuilder((String)resultKeyModel.getFluentGetterMethodName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(SdkPublisher.class), (TypeName[])new TypeName[]{resultKeyType})).addCode("$T getIterator = ", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{this.responseType(), ParameterizedTypeName.get((ClassName)ClassName.get(Iterator.class), (TypeName[])new TypeName[]{resultKeyType})})}).addCode(this.getIteratorLambdaBlock(resultKey, resultKeyModel)).addCode("\n", new Object[0]).addStatement("return $1T.builder().$2L(new $3L()).iteratorFunction(getIterator).$4L($4L).build()", new Object[]{PaginatedItemsPublisher.class, "nextPageFetcher", this.nextPageFetcherClassName(), LAST_PAGE_FIELD}).addJavadoc(CodeBlock.builder().add("Returns a publisher that can be used to get a stream of data. You need to subscribe to the publisher to request the stream of data. The publisher has a helper forEach method that takes in a {@link $T} and then applies that consumer to each response returned by the service.", new Object[]{TypeName.get(Consumer.class)}).build()).build();
    }

    private TypeSpec nextPageFetcherClass() {
        return TypeSpec.classBuilder((String)this.nextPageFetcherClassName()).addModifiers(new Modifier[]{Modifier.PRIVATE}).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(AsyncPageFetcher.class), (TypeName[])new TypeName[]{this.responseType()})).addMethod(MethodSpec.methodBuilder((String)"hasNextPage").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter((TypeName)this.responseType(), "previousPage", new Modifier[]{Modifier.FINAL}).returns(Boolean.TYPE).addStatement(this.hasNextPageMethodBody()).build()).addMethod(MethodSpec.methodBuilder((String)"nextPage").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter((TypeName)this.responseType(), "previousPage", new Modifier[]{Modifier.FINAL}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(CompletableFuture.class), (TypeName[])new TypeName[]{this.responseType()})).addCode(this.nextPageMethodBody()).build()).build();
    }

    private MethodSpec resumeMethod() {
        return this.resumeMethodBuilder().addCode(CodeBlock.builder().addStatement("return $L", new Object[]{this.anonymousClassWithEmptySubscription()}).build()).build();
    }

    private TypeSpec anonymousClassWithEmptySubscription() {
        return TypeSpec.anonymousClassBuilder((String)"$L, $L, true", (Object[])new Object[]{"client", "firstRequest"}).addSuperinterface((TypeName)this.className()).addMethod(MethodSpec.methodBuilder((String)SUBSCRIBE_METHOD).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Subscriber.class), (TypeName[])new TypeName[]{WildcardTypeName.supertypeOf((TypeName)this.responseType())}), SUBSCRIBER, new Modifier[0]).addStatement("$L.onSubscribe(new $T($L))", new Object[]{SUBSCRIBER, TypeName.get(EmptySubscription.class), SUBSCRIBER}).build()).build();
    }
}

