/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.javapoet.WildcardTypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MapModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeType;
import software.amazon.awssdk.codegen.model.intermediate.VariableModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.model.AwsServiceBaseRequestSpec;
import software.amazon.awssdk.codegen.poet.model.AwsServiceBaseResponseSpec;
import software.amazon.awssdk.codegen.poet.model.ModelBuilderSpecs;
import software.amazon.awssdk.codegen.poet.model.ModelMethodOverrides;
import software.amazon.awssdk.codegen.poet.model.ShapeModelSpec;
import software.amazon.awssdk.codegen.poet.model.TypeProvider;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AwsServiceModel
implements ClassSpec {
    private final IntermediateModel intermediateModel;
    private final ShapeModel shapeModel;
    private final PoetExtensions poetExtensions;
    private final TypeProvider typeProvider;
    private final ShapeModelSpec shapeModelSpec;
    private final ModelMethodOverrides modelMethodOverrides;
    private final ModelBuilderSpecs modelBuilderSpecs;

    public AwsServiceModel(IntermediateModel intermediateModel, ShapeModel shapeModel) {
        this.intermediateModel = intermediateModel;
        this.shapeModel = shapeModel;
        this.poetExtensions = new PoetExtensions(intermediateModel);
        this.typeProvider = new TypeProvider(intermediateModel);
        this.shapeModelSpec = new ShapeModelSpec(this.shapeModel, this.typeProvider, this.poetExtensions);
        this.modelMethodOverrides = new ModelMethodOverrides(this.poetExtensions);
        this.modelBuilderSpecs = new ModelBuilderSpecs(intermediateModel, this.shapeModel, this.shapeModelSpec, this.typeProvider);
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder specBuilder = TypeSpec.classBuilder((String)this.shapeModel.getShapeName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(PoetUtils.GENERATED).addSuperinterfaces(this.modelSuperInterfaces()).superclass(this.modelSuperClass()).addMethods(this.modelClassMethods()).addFields(this.shapeModelSpec.fields()).addTypes(this.nestedModelClassTypes());
        if (this.shapeModel.getDocumentation() != null) {
            specBuilder.addJavadoc("$L", new Object[]{this.shapeModel.getDocumentation()});
        }
        return specBuilder.build();
    }

    @Override
    public ClassName className() {
        return this.shapeModelSpec.className();
    }

    private List<TypeName> modelSuperInterfaces() {
        ArrayList<TypeName> interfaces = new ArrayList<TypeName>();
        if (this.implementStructuredPojoInterface()) {
            interfaces.add((TypeName)ClassName.get(StructuredPojo.class));
        }
        switch (this.shapeModel.getShapeType()) {
            case Exception: 
            case Model: 
            case Request: 
            case Response: {
                interfaces.add(this.toCopyableBuilderInterface());
                break;
            }
        }
        return interfaces;
    }

    private TypeName modelSuperClass() {
        switch (this.shapeModel.getShapeType()) {
            case Request: {
                return this.requestBaseClass();
            }
            case Response: {
                return this.responseBaseClass();
            }
            case Exception: {
                return this.exceptionBaseClass();
            }
        }
        return ClassName.OBJECT;
    }

    private TypeName requestBaseClass() {
        return new AwsServiceBaseRequestSpec(this.intermediateModel).className();
    }

    private TypeName responseBaseClass() {
        return new AwsServiceBaseResponseSpec(this.intermediateModel).className();
    }

    private ClassName exceptionBaseClass() {
        String customExceptionBase = this.intermediateModel.getCustomizationConfig().getSdkModeledExceptionBaseClassName();
        if (customExceptionBase != null) {
            return this.poetExtensions.getModelClass(customExceptionBase);
        }
        return this.poetExtensions.getModelClass(this.intermediateModel.getSdkModeledExceptionBaseClassName());
    }

    private TypeName toCopyableBuilderInterface() {
        return ParameterizedTypeName.get((ClassName)ClassName.get(ToCopyableBuilder.class), (TypeName[])new TypeName[]{this.className().nestedClass("Builder"), this.className()});
    }

    private List<MethodSpec> modelClassMethods() {
        ArrayList<MethodSpec> methodSpecs = new ArrayList<MethodSpec>();
        switch (this.shapeModel.getShapeType()) {
            case Exception: {
                methodSpecs.add(this.exceptionConstructor());
                methodSpecs.add(this.toBuilderMethod());
                methodSpecs.add(this.builderMethod());
                methodSpecs.add(this.serializableBuilderClass());
                methodSpecs.addAll(this.memberGetters());
                break;
            }
            default: {
                methodSpecs.addAll(this.memberGetters());
                methodSpecs.add(this.constructor());
                methodSpecs.add(this.toBuilderMethod());
                methodSpecs.add(this.builderMethod());
                methodSpecs.add(this.serializableBuilderClass());
                methodSpecs.add(this.modelMethodOverrides.hashCodeMethod(this.shapeModel));
                methodSpecs.add(this.modelMethodOverrides.equalsMethod(this.shapeModel));
                methodSpecs.add(this.modelMethodOverrides.toStringMethod(this.shapeModel));
                methodSpecs.add(this.getValueForField());
            }
        }
        if (this.implementStructuredPojoInterface()) {
            methodSpecs.add(this.structuredPojoMarshallMethod(this.shapeModel));
        }
        return methodSpecs;
    }

    private MethodSpec getValueForField() {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"getValueForField").addModifiers(new Modifier[]{Modifier.PUBLIC}).addTypeVariable(TypeVariableName.get((String)"T")).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Optional.class), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")})).addParameter(String.class, "fieldName", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")}), "clazz", new Modifier[0]);
        if (this.shapeModel.getNonStreamingMembers().isEmpty()) {
            methodBuilder.addStatement("return $T.empty()", new Object[]{Optional.class});
            return methodBuilder.build();
        }
        methodBuilder.beginControlFlow("switch ($L)", new Object[]{"fieldName"});
        this.shapeModel.getNonStreamingMembers().forEach(m -> methodBuilder.addCode("case $S:", new Object[]{m.getC2jName()}).addStatement("return $T.of(clazz.cast($L()))", new Object[]{Optional.class, m.getFluentGetterMethodName()}));
        methodBuilder.addCode("default:", new Object[0]);
        methodBuilder.addStatement("return $T.empty()", new Object[]{Optional.class});
        methodBuilder.endControlFlow();
        return methodBuilder.build();
    }

    private List<MethodSpec> memberGetters() {
        return this.shapeModel.getNonStreamingMembers().stream().filter(m -> !m.getHttp().getIsStreaming()).flatMap(this::memberGetters).collect(Collectors.toList());
    }

    private Stream<MethodSpec> memberGetters(MemberModel member) {
        ArrayList<MethodSpec> result = new ArrayList<MethodSpec>();
        if (this.shouldGenerateEnumGetter(member)) {
            result.add(this.enumMemberGetter(member));
        }
        result.add(this.memberGetter(member));
        return result.stream();
    }

    private boolean shouldGenerateEnumGetter(MemberModel member) {
        return Utils.isOrContainsEnum(member);
    }

    private MethodSpec enumMemberGetter(MemberModel member) {
        return MethodSpec.methodBuilder((String)member.getFluentEnumGetterMethodName()).addJavadoc("$L", new Object[]{member.getGetterDocumentation()}).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(this.typeProvider.enumReturnType(member)).addCode(this.enumGetterStatement(member)).build();
    }

    private MethodSpec memberGetter(MemberModel member) {
        return MethodSpec.methodBuilder((String)member.getFluentGetterMethodName()).addJavadoc("$L", new Object[]{member.getGetterDocumentation()}).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(this.typeProvider.returnType(member)).addCode(this.getterStatement(member)).build();
    }

    private CodeBlock enumGetterStatement(MemberModel member) {
        String fieldName = member.getVariable().getVariableName();
        if (member.isList()) {
            ClassName valueEnumClass = this.poetExtensions.getModelClass(member.getListModel().getListMemberModel().getEnumType());
            return CodeBlock.of((String)"return $T.convert($N, $T::fromValue);", (Object[])new Object[]{TypeConverter.class, fieldName, valueEnumClass});
        }
        if (member.isMap()) {
            MapModel mapModel = member.getMapModel();
            String keyEnumType = mapModel.getKeyModel().getEnumType();
            String valueEnumType = mapModel.getValueModel().getEnumType();
            CodeBlock keyConverter = keyEnumType != null ? this.enumConverterFunction(this.poetExtensions.getModelClass(keyEnumType)) : this.identityFunction();
            CodeBlock valueConverter = valueEnumType != null ? this.enumConverterFunction(this.poetExtensions.getModelClass(valueEnumType)) : this.identityFunction();
            CodeBlock entryPredicate = this.mapEntryFilter(keyEnumType);
            return CodeBlock.builder().add("return $T.convert($N, ", new Object[]{TypeConverter.class, fieldName}).add(keyConverter).add(", ", new Object[0]).add(valueConverter).add(", ", new Object[0]).add(entryPredicate).add(");", new Object[0]).build();
        }
        ClassName enumClass = this.poetExtensions.getModelClass(member.getEnumType());
        return CodeBlock.of((String)"return $T.fromValue($N);", (Object[])new Object[]{enumClass, fieldName});
    }

    private CodeBlock mapEntryFilter(String keyEnumType) {
        return keyEnumType != null ? CodeBlock.of((String)"(k, v) -> !$T.equals(k, $T.UNKNOWN_TO_SDK_VERSION)", (Object[])new Object[]{Objects.class, this.poetExtensions.getModelClass(keyEnumType)}) : CodeBlock.of((String)"(k, v) -> true", (Object[])new Object[0]);
    }

    private CodeBlock enumConverterFunction(ClassName enumClass) {
        return CodeBlock.of((String)"$T::fromValue", (Object[])new Object[]{enumClass});
    }

    private CodeBlock identityFunction() {
        return CodeBlock.of((String)"$T.identity()", (Object[])new Object[]{Function.class});
    }

    private CodeBlock getterStatement(MemberModel model) {
        VariableModel modelVariable = model.getVariable();
        if ("java.nio.ByteBuffer".equals(modelVariable.getVariableType())) {
            return CodeBlock.of((String)"return $1N == null ? null : $1N.asReadOnlyBuffer();", (Object[])new Object[]{modelVariable.getVariableName()});
        }
        return CodeBlock.of((String)"return $N;", (Object[])new Object[]{modelVariable.getVariableName()});
    }

    private List<TypeSpec> nestedModelClassTypes() {
        ArrayList<TypeSpec> nestedClasses = new ArrayList<TypeSpec>();
        switch (this.shapeModel.getShapeType()) {
            case Exception: 
            case Model: 
            case Request: 
            case Response: {
                nestedClasses.add(this.modelBuilderSpecs.builderInterface());
                nestedClasses.add(this.modelBuilderSpecs.beanStyleBuilder());
                break;
            }
        }
        return nestedClasses;
    }

    private boolean implementStructuredPojoInterface() {
        return this.intermediateModel.getMetadata().isJsonProtocol() && this.shapeModel.getShapeType() == ShapeType.Model;
    }

    private MethodSpec structuredPojoMarshallMethod(ShapeModel shapeModel) {
        return MethodSpec.methodBuilder((String)"marshall").addAnnotation(SdkInternalApi.class).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ProtocolMarshaller.class, "protocolMarshaller", new Modifier[0]).addStatement("$T.getInstance().marshall(this, $N)", new Object[]{this.poetExtensions.getTransformClass(shapeModel.getShapeName() + "Marshaller"), "protocolMarshaller"}).build();
    }

    private MethodSpec constructor() {
        MethodSpec.Builder ctorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)this.modelBuilderSpecs.builderImplName(), "builder", new Modifier[0]);
        if (this.isRequest() || this.isResponse()) {
            ctorBuilder.addStatement("super(builder)", new Object[0]);
        }
        this.shapeModelSpec.fields().forEach(f -> ctorBuilder.addStatement("this.$N = builder.$N", new Object[]{f, f}));
        return ctorBuilder.build();
    }

    private MethodSpec exceptionConstructor() {
        MethodSpec.Builder ctorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)this.modelBuilderSpecs.builderImplName(), "builder", new Modifier[0]);
        ctorBuilder.addStatement("super(builder.message)", new Object[0]);
        this.shapeModelSpec.fields().forEach(f -> ctorBuilder.addStatement("this.$N = builder.$N", new Object[]{f, f}));
        return ctorBuilder.build();
    }

    private MethodSpec builderMethod() {
        return MethodSpec.methodBuilder((String)"builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)this.modelBuilderSpecs.builderInterfaceName()).addStatement("return new $T()", new Object[]{this.modelBuilderSpecs.builderImplName()}).build();
    }

    private MethodSpec toBuilderMethod() {
        return MethodSpec.methodBuilder((String)"toBuilder").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)this.modelBuilderSpecs.builderInterfaceName()).addStatement("return new $T(this)", new Object[]{this.modelBuilderSpecs.builderImplName()}).build();
    }

    private MethodSpec serializableBuilderClass() {
        return MethodSpec.methodBuilder((String)"serializableBuilderClass").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)this.modelBuilderSpecs.builderInterfaceName())})).addStatement("return $T.class", new Object[]{this.modelBuilderSpecs.builderImplName()}).build();
    }

    private boolean isResponse() {
        return this.shapeModel.getShapeType() == ShapeType.Response;
    }

    private boolean isRequest() {
        return this.shapeModel.getShapeType() == ShapeType.Request;
    }
}

