/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.naming;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.config.customization.CustomizationConfig;
import software.amazon.awssdk.codegen.model.service.ServiceModel;
import software.amazon.awssdk.codegen.model.service.Shape;
import software.amazon.awssdk.codegen.naming.NamingStrategy;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.StringUtils;

public class DefaultNamingStrategy
implements NamingStrategy {
    private static Logger log = Logger.loggerFor(DefaultNamingStrategy.class);
    private static final Set<String> RESERVED_KEYWORDS;
    private final ServiceModel serviceModel;

    public DefaultNamingStrategy(ServiceModel serviceModel, CustomizationConfig customizationConfig) {
        this.serviceModel = serviceModel;
    }

    private static boolean isJavaKeyword(String word) {
        return RESERVED_KEYWORDS.contains(word) || RESERVED_KEYWORDS.contains(StringUtils.lowerCase((String)word));
    }

    @Override
    public String getExceptionName(String errorShapeName) {
        if (errorShapeName.endsWith("Fault")) {
            return Utils.capitialize(errorShapeName.substring(0, errorShapeName.length() - "Fault".length()) + "Exception");
        }
        if (errorShapeName.endsWith("Exception")) {
            return Utils.capitialize(errorShapeName);
        }
        return Utils.capitialize(errorShapeName + "Exception");
    }

    @Override
    public String getRequestClassName(String operationName) {
        return Utils.capitialize(operationName + "Request");
    }

    @Override
    public String getResponseClassName(String operationName) {
        return Utils.capitialize(operationName + "Response");
    }

    @Override
    public String getVariableName(String name) {
        if (DefaultNamingStrategy.isJavaKeyword(name)) {
            return Utils.unCapitialize(name + "Value");
        }
        return Utils.unCapitialize(name);
    }

    @Override
    public String getEnumValueName(String enumValue) {
        String result = enumValue;
        result = result.replaceAll("textORcsv", "TEXT_OR_CSV");
        result = result.replaceAll("[:/()-. ]+", "_");
        result = result.replaceAll("([^a-z]{2,})v([0-9]+)", "$1_v$2_").replaceAll("([^A-Z]{2,})V([0-9]+)", "$1_V$2_");
        result = result.replaceAll("([a-z])([A-Z][a-zA-Z])", "$1_$2");
        result = result.replaceAll("([A-Z]+)([A-Z][a-z])", "$1_$2");
        result = result.replaceAll("([0-9])([a-zA-Z])", "$1_$2");
        result = result.replaceAll("_+", "_").replaceAll("^_*([^_].*[^_])_*$", "$1");
        if (!(result = StringUtils.upperCase((String)result)).matches("^[A-Z][A-Z0-9_]*$")) {
            String attempt = result;
            log.warn(() -> "Invalid enum member generated for input '" + enumValue + "'. Best attempt: '" + attempt + "' If this enum is not customized out, the build will fail.");
        }
        return result;
    }

    @Override
    public String getJavaClassName(String shapeName) {
        return Arrays.stream(shapeName.split("[._-]|\\W")).map(Utils::capitialize).collect(Collectors.joining());
    }

    @Override
    public String getAuthorizerClassName(String shapeName) {
        String converted = this.getJavaClassName(shapeName);
        if (converted.length() > 0 && !Character.isLetter(converted.charAt(0))) {
            return "I" + converted;
        }
        return converted;
    }

    @Override
    public String getFluentGetterMethodName(String memberName, Shape shape) {
        String getterMethodName = Utils.unCapitialize(memberName);
        if (Utils.isOrContainsEnumShape(shape, this.serviceModel.getShapes())) {
            getterMethodName = getterMethodName + "AsString";
            if (Utils.isListShape(shape) || Utils.isMapShape(shape)) {
                getterMethodName = getterMethodName + "s";
            }
        }
        return getterMethodName;
    }

    @Override
    public String getFluentEnumGetterMethodName(String memberName, Shape shape) {
        if (!Utils.isOrContainsEnumShape(shape, this.serviceModel.getShapes())) {
            return null;
        }
        return Utils.unCapitialize(memberName);
    }

    @Override
    public String getBeanStyleGetterMethodName(String memberName) {
        return String.format("get%s", Utils.capitialize(memberName));
    }

    @Override
    public String getSetterMethodName(String memberName) {
        return Utils.unCapitialize(memberName);
    }

    @Override
    public String getBeanStyleSetterMethodName(String memberName) {
        return String.format("set%s", Utils.capitialize(memberName));
    }

    @Override
    public String getFluentSetterMethodName(String memberName) {
        return Utils.unCapitialize(memberName);
    }

    static {
        HashSet keywords = new HashSet();
        Collections.addAll(keywords, "abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "null", "false", "const", "goto");
        RESERVED_KEYWORDS = Collections.unmodifiableSet(keywords);
    }
}

