/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.emitters.tasks;

import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.codegen.emitters.FreemarkerGeneratorTask;
import software.amazon.awssdk.codegen.emitters.GeneratorTask;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskParams;
import software.amazon.awssdk.codegen.emitters.tasks.BaseGeneratorTasks;
import software.amazon.awssdk.codegen.model.intermediate.AuthorizerModel;
import software.amazon.awssdk.codegen.model.intermediate.Metadata;
import software.amazon.awssdk.core.util.ImmutableMapParameter;
import software.amazon.awssdk.utils.FunctionalUtils;

public class AuthorizerGeneratorTasks
extends BaseGeneratorTasks {
    private final String customRequestSignerDir;

    public AuthorizerGeneratorTasks(GeneratorTaskParams dependencies) {
        super(dependencies);
        this.customRequestSignerDir = dependencies.getPathProvider().getAuthorizerDirectory();
    }

    @Override
    protected boolean hasTasks() {
        return !this.model.getCustomAuthorizers().isEmpty();
    }

    @Override
    protected List<GeneratorTask> createTasks() throws Exception {
        this.info("Emitting Authorizer interfaces");
        return this.model.getCustomAuthorizers().values().stream().map(FunctionalUtils.safeFunction(this::createTask)).collect(Collectors.toList());
    }

    private GeneratorTask createTask(AuthorizerModel customAuthorizer) throws Exception {
        Metadata metadata = this.model.getMetadata();
        ImmutableMapParameter dataModel = ImmutableMapParameter.of((Object)"fileHeader", (Object)this.model.getFileHeader(), (Object)"className", (Object)customAuthorizer.getInterfaceName(), (Object)"authorizer", (Object)customAuthorizer, (Object)"metadata", (Object)metadata);
        return new FreemarkerGeneratorTask(this.customRequestSignerDir, customAuthorizer.getInterfaceName(), this.freemarker.getCustomAuthorizerTemplate(), dataModel);
    }
}

