/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeType;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.model.AccessorsFactory;
import software.amazon.awssdk.codegen.poet.model.ShapeModelSpec;
import software.amazon.awssdk.codegen.poet.model.TypeProvider;
import software.amazon.awssdk.utils.builder.CopyableBuilder;

class ModelBuilderSpecs {
    private final IntermediateModel intermediateModel;
    private final ShapeModel shapeModel;
    private final ShapeModelSpec shapeModelSpec;
    private final TypeProvider typeProvider;
    private final PoetExtensions poetExtensions;
    private final AccessorsFactory accessorsFactory;

    public ModelBuilderSpecs(IntermediateModel intermediateModel, ShapeModel shapeModel, ShapeModelSpec shapeModelSpec, TypeProvider typeProvider) {
        this.intermediateModel = intermediateModel;
        this.shapeModel = shapeModel;
        this.shapeModelSpec = shapeModelSpec;
        this.typeProvider = typeProvider;
        this.poetExtensions = new PoetExtensions(this.intermediateModel);
        this.accessorsFactory = new AccessorsFactory(this.shapeModel, this.intermediateModel, this.typeProvider);
    }

    public ClassName builderInterfaceName() {
        return this.classToBuild().nestedClass("Builder");
    }

    public ClassName builderImplName() {
        return this.classToBuild().nestedClass("BuilderImpl");
    }

    public TypeSpec builderInterface() {
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder((ClassName)this.builderInterfaceName()).addSuperinterface(this.copyableBuilderSuperInterface()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        this.shapeModel.getNonStreamingMembers().forEach(m -> builder.addMethods(this.accessorsFactory.fluentSetterDeclarations((MemberModel)m, (TypeName)this.builderInterfaceName())));
        if (this.exception()) {
            builder.addMethod(MethodSpec.methodBuilder((String)"message").returns((TypeName)this.builderInterfaceName()).addParameter(String.class, "message", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).build());
        }
        return builder.build();
    }

    public TypeSpec beanStyleBuilder() {
        TypeSpec.Builder builderClassBuilder = TypeSpec.classBuilder((ClassName)this.builderImplName()).addSuperinterface((TypeName)this.builderInterfaceName()).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL});
        builderClassBuilder.addFields(this.fields());
        builderClassBuilder.addMethod(this.noargConstructor());
        builderClassBuilder.addMethod(this.modelCopyConstructor());
        builderClassBuilder.addMethods(this.accessors());
        builderClassBuilder.addMethod(this.buildMethod());
        return builderClassBuilder.build();
    }

    private List<FieldSpec> fields() {
        List<Object> fields = this.shapeModelSpec.fields(Modifier.PRIVATE);
        Map<String, MemberModel> members = this.shapeModel.getNonStreamingMembers().stream().collect(Collectors.toMap(m -> this.shapeModelSpec.asField((MemberModel)m, (Modifier[])new Modifier[0]).name, m -> m));
        fields = fields.stream().map(f -> {
            MemberModel m = (MemberModel)members.get(f.name);
            if (this.intermediateModel.getCustomizationConfig().isUseAutoConstructList() && m.isList()) {
                return f.toBuilder().initializer(CodeBlock.builder().add("new $T<>()", new Object[]{this.typeProvider.listImplClassName()}).build()).build();
            }
            if (this.intermediateModel.getCustomizationConfig().isUseAutoConstructMap() && m.isMap()) {
                return f.toBuilder().initializer(CodeBlock.builder().add("new $T<>()", new Object[]{this.typeProvider.mapImplClassName()}).build()).build();
            }
            return f;
        }).collect(Collectors.toList());
        if (this.exception()) {
            fields = new ArrayList<FieldSpec>(fields);
            fields.add(FieldSpec.builder(String.class, (String)"message", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
        }
        return fields;
    }

    private MethodSpec noargConstructor() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
    }

    private MethodSpec modelCopyConstructor() {
        MethodSpec.Builder copyBuilderCtor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)this.classToBuild(), "model", new Modifier[0]);
        this.shapeModel.getNonStreamingMembers().forEach(m -> {
            String name = m.getVariable().getVariableName();
            copyBuilderCtor.addStatement("$N(model.$N)", new Object[]{m.getSetterMethodName(), name});
        });
        if (this.exception()) {
            copyBuilderCtor.addStatement("this.message = model.getMessage()", new Object[0]);
        }
        return copyBuilderCtor.build();
    }

    private List<MethodSpec> accessors() {
        ArrayList<MethodSpec> accessors = new ArrayList<MethodSpec>();
        this.shapeModel.getNonStreamingMembers().stream().forEach(m -> {
            accessors.add(this.accessorsFactory.beanStyleGetters((MemberModel)m));
            accessors.addAll(this.accessorsFactory.fluentSetters((MemberModel)m, (TypeName)this.builderInterfaceName()));
            accessors.addAll(this.accessorsFactory.beanStyleSetters((MemberModel)m));
        });
        if (this.exception()) {
            accessors.addAll(this.exceptionMessageGetters());
            accessors.addAll(this.exceptionMessageSetters());
        }
        return accessors;
    }

    private MethodSpec buildMethod() {
        return MethodSpec.methodBuilder((String)"build").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.classToBuild()).addStatement("return new $T(this)", new Object[]{this.classToBuild()}).build();
    }

    private ClassName classToBuild() {
        return this.poetExtensions.getModelClass(this.shapeModel.getShapeName());
    }

    private boolean exception() {
        return this.shapeModel.getShapeType() == ShapeType.Exception;
    }

    private TypeName copyableBuilderSuperInterface() {
        return ParameterizedTypeName.get((ClassName)ClassName.get(CopyableBuilder.class), (TypeName[])new TypeName[]{this.classToBuild().nestedClass("Builder"), this.classToBuild()});
    }

    private List<MethodSpec> exceptionMessageGetters() {
        ArrayList<MethodSpec> getters = new ArrayList<MethodSpec>();
        getters.add(MethodSpec.methodBuilder((String)"getMessage").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return message", new Object[0]).build());
        getters.add(MethodSpec.methodBuilder((String)"message").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return message", new Object[0]).build());
        return getters;
    }

    private List<MethodSpec> exceptionMessageSetters() {
        ArrayList<MethodSpec> setters = new ArrayList<MethodSpec>();
        setters.add(MethodSpec.methodBuilder((String)"setMessage").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(String.class, "message", new Modifier[0]).addStatement("this.message = message", new Object[0]).build());
        setters.add(MethodSpec.methodBuilder((String)"message").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.builderInterfaceName()).addAnnotation(Override.class).addParameter(String.class, "message", new Modifier[0]).addStatement("this.message = message", new Object[0]).addStatement("return this", new Object[0]).build());
        return setters;
    }
}

