/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.client.specs;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.w3c.dom.Node;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.client.AsyncClientInterface;
import software.amazon.awssdk.codegen.poet.client.specs.ProtocolSpec;
import software.amazon.awssdk.http.DefaultErrorResponseHandler;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.http.StaxResponseHandler;
import software.amazon.awssdk.http.async.SdkHttpResponseHandler;
import software.amazon.awssdk.runtime.transform.StandardErrorUnmarshaller;
import software.amazon.awssdk.runtime.transform.StreamingRequestMarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.utils.StringUtils;

public class QueryXmlProtocolSpec
implements ProtocolSpec {
    private final PoetExtensions poetExtensions;
    private final TypeName unmarshallerType = ParameterizedTypeName.get(Unmarshaller.class, (Type[])new Type[]{AmazonServiceException.class, Node.class});
    private final TypeName listOfUnmarshallersType = ParameterizedTypeName.get((ClassName)ClassName.get((String)"java.util", (String)"List", (String[])new String[0]), (TypeName[])new TypeName[]{this.unmarshallerType});

    public QueryXmlProtocolSpec(PoetExtensions poetExtensions) {
        this.poetExtensions = poetExtensions;
    }

    @Override
    public FieldSpec protocolFactory(IntermediateModel model) {
        return FieldSpec.builder((TypeName)this.listOfUnmarshallersType, (String)"exceptionUnmarshallers", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
    }

    @Override
    public MethodSpec initProtocolFactory(IntermediateModel model) {
        MethodSpec.Builder methodSpec = MethodSpec.methodBuilder((String)"init").returns(this.listOfUnmarshallersType).addModifiers(new Modifier[]{Modifier.PRIVATE});
        methodSpec.addStatement("$T<$T> unmarshallers = new $T<>()", new Object[]{List.class, this.unmarshallerType, ArrayList.class});
        this.errorUnmarshallers(model).forEach(arg_0 -> ((MethodSpec.Builder)methodSpec).addCode(arg_0));
        methodSpec.addCode(CodeBlock.builder().add("unmarshallers.add(new $T($T.class));", new Object[]{this.getErrorUnmarshallerClass(model), this.poetExtensions.getModelClass(model.getSdkModeledExceptionBaseClassName())}).build());
        methodSpec.addStatement("return $N", new Object[]{"unmarshallers"});
        return methodSpec.build();
    }

    private Class<?> getErrorUnmarshallerClass(IntermediateModel model) {
        try {
            return StringUtils.isNotBlank((CharSequence)model.getExceptionUnmarshallerImpl()) ? Class.forName(model.getExceptionUnmarshallerImpl()) : StandardErrorUnmarshaller.class;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CodeBlock responseHandler(OperationModel opModel) {
        ClassName unmarshaller = this.poetExtensions.getTransformClass(opModel.getReturnType().getReturnType() + "Unmarshaller");
        ClassName returnType = this.poetExtensions.getModelClass(opModel.getReturnType().getReturnType());
        if (opModel.hasStreamingOutput()) {
            ParameterizedTypeName responseHandlerType = ParameterizedTypeName.get((ClassName)ClassName.get(HttpResponseHandler.class), (TypeName[])new TypeName[]{AsyncClientInterface.STREAMING_TYPE_VARIABLE});
            return CodeBlock.builder().addStatement("\n\n$T responseHandler = $T.createStreamingResponseHandler(new $T(), streamingHandler)", new Object[]{responseHandlerType, StaxResponseHandler.class, unmarshaller}).build();
        }
        return CodeBlock.builder().addStatement("\n\n$T<$T> responseHandler = new $T<$T>(new $T())", new Object[]{StaxResponseHandler.class, returnType, StaxResponseHandler.class, returnType, unmarshaller}).build();
    }

    @Override
    public CodeBlock asyncResponseHandler(OperationModel opModel) {
        if (opModel.hasStreamingOutput()) {
            ClassName unmarshaller = this.poetExtensions.getTransformClass(opModel.getReturnType().getReturnType() + "Unmarshaller");
            return CodeBlock.builder().addStatement("$T<$T> responseHandler = $T.createStreamingAsyncResponseHandler(new $T(), asyncResponseHandler)", new Object[]{SdkHttpResponseHandler.class, AsyncClientInterface.STREAMING_TYPE_VARIABLE, StaxResponseHandler.class, unmarshaller}).build();
        }
        return this.responseHandler(opModel);
    }

    @Override
    public CodeBlock errorResponseHandler(OperationModel opModel) {
        return CodeBlock.builder().add("\n\n$T errorResponseHandler = new $T($N);", new Object[]{DefaultErrorResponseHandler.class, DefaultErrorResponseHandler.class, "exceptionUnmarshallers"}).build();
    }

    @Override
    public CodeBlock executionHandler(OperationModel opModel) {
        TypeVariableName returnType = opModel.hasStreamingOutput() ? AsyncClientInterface.STREAMING_TYPE_VARIABLE : this.poetExtensions.getModelClass(opModel.getReturnType().getReturnType());
        ClassName requestType = this.poetExtensions.getModelClass(opModel.getInput().getVariableType());
        ClassName marshaller = this.poetExtensions.getTransformClass(opModel.getInputShape().getShapeName() + "Marshaller");
        CodeBlock.Builder codeBlock = CodeBlock.builder().add("\n\nreturn clientHandler.execute(new $T<$T, $T>().withResponseHandler($N).withErrorResponseHandler($N).withInput($L)", new Object[]{ClientExecutionParams.class, requestType, returnType, "responseHandler", "errorResponseHandler", opModel.getInput().getVariableName()});
        if (opModel.hasStreamingInput()) {
            return codeBlock.add(".withMarshaller(new $T(new $T(), requestBody)));", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(StreamingRequestMarshaller.class), (TypeName[])new TypeName[]{requestType}), marshaller}).build();
        }
        return codeBlock.add(".withMarshaller(new $T()));", new Object[]{marshaller}).build();
    }

    @Override
    public CodeBlock asyncExecutionHandler(OperationModel opModel) {
        ClassName pojoResponseType = this.poetExtensions.getModelClass(opModel.getReturnType().getReturnType());
        ClassName requestType = this.poetExtensions.getModelClass(opModel.getInput().getVariableType());
        ClassName marshaller = this.poetExtensions.getRequestTransformClass(opModel.getInputShape().getShapeName() + "Marshaller");
        String asyncRequestProvider = opModel.hasStreamingInput() ? ".withAsyncRequestProvider(requestProvider)" : "";
        ClassName returnType = opModel.hasStreamingOutput() ? TypeVariableName.get((String)"ReturnT") : pojoResponseType;
        String responseHandler = opModel.hasStreamingOutput() ? ".withAsyncResponseHandler(responseHandler)" : ".withResponseHandler(responseHandler)";
        return CodeBlock.builder().add("\n\nreturn clientHandler.execute(new $T<$T, $T>()\n.withMarshaller(new $T())" + responseHandler + ".withErrorResponseHandler($N)\n" + asyncRequestProvider + ".withInput($L));", new Object[]{ClientExecutionParams.class, requestType, returnType, marshaller, "errorResponseHandler", opModel.getInput().getVariableName()}).build();
    }

    @Override
    public Optional<MethodSpec> createErrorResponseHandler() {
        return Optional.empty();
    }

    @Override
    public List<CodeBlock> errorUnmarshallers(IntermediateModel model) {
        List exceptions = model.getShapes().values().stream().filter(s -> s.getType().equals("Exception")).collect(Collectors.toList());
        return exceptions.stream().map(s -> {
            ClassName exceptionClass = this.poetExtensions.getTransformClass(s.getShapeName() + "Unmarshaller");
            return CodeBlock.builder().add("unmarshallers.add(new $T());", new Object[]{exceptionClass}).build();
        }).collect(Collectors.toList());
    }
}

