/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.model.intermediate;

import com.fasterxml.jackson.annotation.JsonProperty;
import software.amazon.awssdk.codegen.internal.TypeUtils;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;

public class MapModel {
    private final String implType;
    private final String interfaceType;
    private final String keyType;
    private final String keyLocationName;
    private final MemberModel keyModel;
    private final String valueType;
    private final String valueLocationName;
    private final MemberModel valueModel;

    public MapModel(@JsonProperty(value="implType") String implType, @JsonProperty(value="interfaceType") String interfaceType, @JsonProperty(value="keyType") String mapKeyType, @JsonProperty(value="keyLocationName") String keyLocationName, @JsonProperty(value="keyModel") MemberModel keyModel, @JsonProperty(value="valueType") String mapValueType, @JsonProperty(value="valueLocationName") String valueLocationName, @JsonProperty(value="valueModel") MemberModel valueModel) {
        this.implType = implType;
        this.interfaceType = interfaceType;
        this.keyType = mapKeyType;
        this.keyLocationName = keyLocationName;
        this.keyModel = keyModel;
        this.valueType = mapValueType;
        this.valueLocationName = valueLocationName;
        this.valueModel = valueModel;
    }

    public String getImplType() {
        return this.implType;
    }

    public String getInterfaceType() {
        return this.interfaceType;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public String getKeyLocationName() {
        return this.keyLocationName;
    }

    public MemberModel getKeyModel() {
        return this.keyModel;
    }

    public String getValueType() {
        return this.valueType;
    }

    public String getValueLocationName() {
        return this.valueLocationName;
    }

    public MemberModel getValueModel() {
        return this.valueModel;
    }

    public boolean isKeySimple() {
        return TypeUtils.isSimple(this.keyType);
    }

    public boolean isValueSimple() {
        return TypeUtils.isSimple(this.valueType);
    }

    public boolean isValueList() {
        return this.valueType.startsWith(TypeUtils.getDataTypeMapping("listInterface"));
    }

    public String getTemplateType() {
        return this.interfaceType + "<" + this.keyType + "," + this.valueType + ">";
    }

    public String getTemplateImplType() {
        return this.implType + "<" + this.keyType + "," + this.valueType + ">";
    }

    public String getEntryType() {
        return String.format("Map.Entry<%s, %s>", this.keyType, this.valueType);
    }
}

