/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.model.intermediate;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import software.amazon.awssdk.codegen.internal.Constants;
import software.amazon.awssdk.codegen.internal.DocumentationUtils;
import software.amazon.awssdk.codegen.model.intermediate.ArgumentModel;
import software.amazon.awssdk.codegen.model.intermediate.DocumentationModel;

public class ConstructorModel
extends DocumentationModel {
    private final String modelClassName;
    private final List<ArgumentModel> arguments = new LinkedList<ArgumentModel>();

    public ConstructorModel(String modelClassName) {
        this.modelClassName = modelClassName;
    }

    public List<ArgumentModel> getArguments() {
        return this.arguments;
    }

    public void addArgument(ArgumentModel argument) {
        this.arguments.add(argument);
    }

    public String getArgumentsDeclaration() {
        StringBuilder builder = new StringBuilder();
        Iterator<ArgumentModel> iter = this.arguments.iterator();
        while (iter.hasNext()) {
            ArgumentModel arg = iter.next();
            builder.append(arg.getType()).append(" ").append(arg.getName());
            if (!iter.hasNext()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    @Override
    public String getDocumentation() {
        StringBuilder docBuilder = new StringBuilder("/**");
        docBuilder.append(this.documentation != null ? this.documentation : String.format("Constructs a new %s object. Callers should use the setter or fluent setter (with...) methods to initialize any additional object members.", this.modelClassName));
        for (ArgumentModel arg : this.arguments) {
            docBuilder.append(Constants.LF);
            docBuilder.append("@param " + arg.getName() + " " + DocumentationUtils.stripHtmlTags(arg.getDocumentation()));
        }
        docBuilder.append("*/");
        return docBuilder.toString();
    }

    @Override
    public void setDocumentation(String documentation) {
        throw new UnsupportedOperationException("Documentation for ConstructorModel is not allowed to be manually set.");
    }
}

