/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.emitters;

import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.codegen.emitters.GeneratorPathProvider;
import software.amazon.awssdk.codegen.emitters.tasks.SharedModelsTaskParamsValidator;
import software.amazon.awssdk.codegen.internal.Freemarker;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.poet.PoetExtensions;

public class GeneratorTaskParams {
    private static final Consumer<GeneratorTaskParams> TASK_PARAMS_VALIDATORS = new SharedModelsTaskParamsValidator();
    private final Freemarker freemarker;
    private final IntermediateModel model;
    private final GeneratorPathProvider pathProvider;
    private final PoetExtensions poetExtensions;
    private final Log log = LogFactory.getLog(GeneratorTaskParams.class);

    private GeneratorTaskParams(Freemarker freemarker, IntermediateModel model, GeneratorPathProvider pathProvider) {
        this.freemarker = freemarker;
        this.model = model;
        this.pathProvider = pathProvider;
        this.poetExtensions = new PoetExtensions(model);
    }

    public static GeneratorTaskParams create(IntermediateModel model, String sourceDirectory, String testDirectory) {
        GeneratorPathProvider pathProvider = new GeneratorPathProvider(model, sourceDirectory, testDirectory);
        GeneratorTaskParams params = new GeneratorTaskParams(Freemarker.create(model), model, pathProvider);
        TASK_PARAMS_VALIDATORS.accept(params);
        return params;
    }

    public Freemarker getFreemarker() {
        return this.freemarker;
    }

    public IntermediateModel getModel() {
        return this.model;
    }

    public GeneratorPathProvider getPathProvider() {
        return this.pathProvider;
    }

    public PoetExtensions getPoetExtensions() {
        return this.poetExtensions;
    }

    public Log getLog() {
        return this.log;
    }
}

