/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.codegen.AstJsonToAstJava;
import software.amazon.awssdk.codegen.CodeGenerator;
import software.amazon.awssdk.codegen.model.intermediate.AcceptorModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.WaiterDefinitionModel;
import software.amazon.awssdk.codegen.model.service.Acceptor;
import software.amazon.awssdk.codegen.model.service.WaiterDefinition;
import software.amazon.awssdk.codegen.model.service.Waiters;
import software.amazon.awssdk.jmespath.JmesPathExpression;
import software.amazon.awssdk.utils.IoUtils;

class AddWaiters {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final Waiters waiters;
    private final Map<String, OperationModel> operations;

    AddWaiters(Waiters waiters, Map<String, OperationModel> operations) {
        this.waiters = waiters;
        this.operations = operations;
    }

    Map<String, WaiterDefinitionModel> constructWaiters() throws IOException {
        HashMap<String, WaiterDefinitionModel> javaWaiterModels = new HashMap<String, WaiterDefinitionModel>();
        HashMap<String, JmesPathExpression> argumentToAstMap = new HashMap<String, JmesPathExpression>();
        for (Map.Entry<String, WaiterDefinition> entry : this.waiters.getWaiters().entrySet()) {
            String waiterName = entry.getKey();
            WaiterDefinition waiterDefinition = entry.getValue();
            ArrayList<AcceptorModel> acceptors = new ArrayList<AcceptorModel>();
            WaiterDefinitionModel waiterDefinitionModel = new WaiterDefinitionModel();
            waiterDefinitionModel.setDelay(waiterDefinition.getDelay());
            waiterDefinitionModel.setMaxAttempts(waiterDefinition.getMaxAttempts());
            waiterDefinitionModel.setWaiterName(waiterName);
            waiterDefinitionModel.setOperationModel(this.operations.get(waiterDefinition.getOperation()));
            for (Acceptor acceptor : waiterDefinition.getAcceptors()) {
                AcceptorModel acceptorModel = new AcceptorModel();
                acceptorModel.setMatcher(acceptor.getMatcher());
                acceptorModel.setState(acceptor.getState());
                acceptorModel.setExpected(acceptor.getExpected());
                acceptorModel.setArgument(acceptor.getArgument());
                acceptorModel.setAst(this.getAstFromArgument(acceptor.getArgument(), argumentToAstMap));
                acceptors.add(acceptorModel);
            }
            waiterDefinitionModel.setAcceptors(acceptors);
            javaWaiterModels.put(waiterName, waiterDefinitionModel);
        }
        return javaWaiterModels;
    }

    private JmesPathExpression getAstFromArgument(String argument, Map<String, JmesPathExpression> argumentToAstMap) throws IOException {
        if (argument != null && !argumentToAstMap.containsKey(argument)) {
            Process p = this.executeToAstProcess(argument);
            if (p.exitValue() != 0) {
                throw new RuntimeException(IoUtils.toString((InputStream)p.getErrorStream()));
            }
            JsonNode jsonNode = MAPPER.readTree(IoUtils.toString((InputStream)p.getInputStream()));
            JmesPathExpression ast = AstJsonToAstJava.fromAstJsonToAstJava(jsonNode);
            argumentToAstMap.put(argument, ast);
            IoUtils.closeQuietly((AutoCloseable)p.getInputStream(), null);
            return ast;
        }
        if (argument != null) {
            return argumentToAstMap.get(argument);
        }
        return null;
    }

    private Process executeToAstProcess(String argument) throws IOException {
        try {
            Process p = new ProcessBuilder("python", this.extractAstTransformer(), argument).start();
            p.waitFor();
            return p;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private String extractAstTransformer() throws IOException {
        Path tempFile = Files.createTempFile("jp-to-ast", ".py", new FileAttribute[0]);
        tempFile.toFile().deleteOnExit();
        Files.copy(CodeGenerator.class.getClassLoader().getResourceAsStream("jp-to-ast.py"), tempFile, StandardCopyOption.REPLACE_EXISTING);
        return tempFile.toString();
    }
}

