/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.lite.maven.plugin;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import software.amazon.awssdk.codegen.lite.CodeGenerator;
import software.amazon.awssdk.codegen.lite.PoetClass;
import software.amazon.awssdk.codegen.lite.defaultsmode.DefaultConfiguration;
import software.amazon.awssdk.codegen.lite.defaultsmode.DefaultsLoader;
import software.amazon.awssdk.codegen.lite.defaultsmode.DefaultsModeConfigurationGenerator;
import software.amazon.awssdk.codegen.lite.defaultsmode.DefaultsModeGenerator;

@Mojo(name="generate-defaults-mode")
public class DefaultsModeGenerationMojo
extends AbstractMojo {
    private static final String DEFAULTS_MODE_BASE = "software.amazon.awssdk.awscore.defaultsmode";
    private static final String DEFAULTS_MODE_CONFIGURATION_BASE = "software.amazon.awssdk.awscore.internal.defaultsmode";
    @Parameter(property="outputDirectory", defaultValue="${project.build.directory}")
    private String outputDirectory;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(property="defaultConfigurationFile", defaultValue="${basedir}/src/main/resources/software/amazon/awssdk/awscore/internal/defaults/sdk-default-configuration.json")
    private File defaultConfigurationFile;

    public void execute() {
        Path baseSourcesDirectory = Paths.get(this.outputDirectory, new String[0]).resolve("generated-sources").resolve("sdk");
        Path testsDirectory = Paths.get(this.outputDirectory, new String[0]).resolve("generated-test-sources").resolve("sdk-tests");
        DefaultConfiguration configuration = DefaultsLoader.load((File)this.defaultConfigurationFile);
        this.generateDefaultsModeClass(baseSourcesDirectory, configuration);
        this.generateDefaultsModeConfiguartionClass(baseSourcesDirectory, configuration);
        this.project.addCompileSourceRoot(baseSourcesDirectory.toFile().getAbsolutePath());
        this.project.addTestCompileSourceRoot(testsDirectory.toFile().getAbsolutePath());
    }

    public void generateDefaultsModeClass(Path baseSourcesDirectory, DefaultConfiguration configuration) {
        Path sourcesDirectory = baseSourcesDirectory.resolve(DEFAULTS_MODE_BASE.replace(".", "/"));
        new CodeGenerator(sourcesDirectory.toString(), (PoetClass)new DefaultsModeGenerator(DEFAULTS_MODE_BASE, configuration)).generate();
    }

    public void generateDefaultsModeConfiguartionClass(Path baseSourcesDirectory, DefaultConfiguration configuration) {
        Path sourcesDirectory = baseSourcesDirectory.resolve(DEFAULTS_MODE_CONFIGURATION_BASE.replace(".", "/"));
        new CodeGenerator(sourcesDirectory.toString(), (PoetClass)new DefaultsModeConfigurationGenerator(DEFAULTS_MODE_CONFIGURATION_BASE, DEFAULTS_MODE_BASE, configuration)).generate();
    }
}

