/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.protocolrestjson;

import java.nio.file.Path;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.protocolrestjson.model.AllTypesRequest;
import software.amazon.awssdk.services.protocolrestjson.model.AllTypesResponse;
import software.amazon.awssdk.services.protocolrestjson.model.DeleteOperationRequest;
import software.amazon.awssdk.services.protocolrestjson.model.DeleteOperationResponse;
import software.amazon.awssdk.services.protocolrestjson.model.EmptyModeledException;
import software.amazon.awssdk.services.protocolrestjson.model.HeadOperationRequest;
import software.amazon.awssdk.services.protocolrestjson.model.HeadOperationResponse;
import software.amazon.awssdk.services.protocolrestjson.model.IdempotentOperationRequest;
import software.amazon.awssdk.services.protocolrestjson.model.IdempotentOperationResponse;
import software.amazon.awssdk.services.protocolrestjson.model.JsonValuesOperationRequest;
import software.amazon.awssdk.services.protocolrestjson.model.JsonValuesOperationResponse;
import software.amazon.awssdk.services.protocolrestjson.model.MapOfStringToListOfStringInQueryParamsRequest;
import software.amazon.awssdk.services.protocolrestjson.model.MapOfStringToListOfStringInQueryParamsResponse;
import software.amazon.awssdk.services.protocolrestjson.model.MembersInHeadersRequest;
import software.amazon.awssdk.services.protocolrestjson.model.MembersInHeadersResponse;
import software.amazon.awssdk.services.protocolrestjson.model.MembersInQueryParamsRequest;
import software.amazon.awssdk.services.protocolrestjson.model.MembersInQueryParamsResponse;
import software.amazon.awssdk.services.protocolrestjson.model.MultiLocationOperationRequest;
import software.amazon.awssdk.services.protocolrestjson.model.MultiLocationOperationResponse;
import software.amazon.awssdk.services.protocolrestjson.model.NestedContainersRequest;
import software.amazon.awssdk.services.protocolrestjson.model.NestedContainersResponse;
import software.amazon.awssdk.services.protocolrestjson.model.OperationWithExplicitPayloadBlobRequest;
import software.amazon.awssdk.services.protocolrestjson.model.OperationWithExplicitPayloadBlobResponse;
import software.amazon.awssdk.services.protocolrestjson.model.OperationWithExplicitPayloadStructureRequest;
import software.amazon.awssdk.services.protocolrestjson.model.OperationWithExplicitPayloadStructureResponse;
import software.amazon.awssdk.services.protocolrestjson.model.OperationWithGreedyLabelRequest;
import software.amazon.awssdk.services.protocolrestjson.model.OperationWithGreedyLabelResponse;
import software.amazon.awssdk.services.protocolrestjson.model.OperationWithModeledContentTypeRequest;
import software.amazon.awssdk.services.protocolrestjson.model.OperationWithModeledContentTypeResponse;
import software.amazon.awssdk.services.protocolrestjson.model.OperationWithNoInputOrOutputRequest;
import software.amazon.awssdk.services.protocolrestjson.model.OperationWithNoInputOrOutputResponse;
import software.amazon.awssdk.services.protocolrestjson.model.ProtocolRestJsonException;
import software.amazon.awssdk.services.protocolrestjson.model.QueryParamWithoutValueRequest;
import software.amazon.awssdk.services.protocolrestjson.model.QueryParamWithoutValueResponse;
import software.amazon.awssdk.services.protocolrestjson.model.StreamingInputOperationRequest;
import software.amazon.awssdk.services.protocolrestjson.model.StreamingInputOperationResponse;
import software.amazon.awssdk.services.protocolrestjson.model.StreamingOutputOperationRequest;
import software.amazon.awssdk.services.protocolrestjson.model.StreamingOutputOperationResponse;

/**
 * Service client for accessing AmazonProtocolRestJson. This can be created using the static {@link #builder()} method.
 *
 * null
 */
@Generated("software.amazon.awssdk:codegen")
public interface ProtocolRestJsonClient extends SdkClient {
    String SERVICE_NAME = "restjson";

    /**
     * Create a {@link ProtocolRestJsonClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ProtocolRestJsonClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ProtocolRestJsonClient}.
     */
    static ProtocolRestJsonClientBuilder builder() {
        return new DefaultProtocolRestJsonClientBuilder();
    }

    /**
     * Invokes the AllTypes operation.
     *
     * @return Result of the AllTypes operation returned by the service.
     * @throws EmptyModeledException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.AllTypes
     * @see #allTypes(AllTypesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/AllTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default AllTypesResponse allTypes() throws EmptyModeledException, AwsServiceException, SdkClientException,
            ProtocolRestJsonException {
        return allTypes(AllTypesRequest.builder().build());
    }

    /**
     * Invokes the AllTypes operation.
     *
     * @param allTypesRequest
     * @return Result of the AllTypes operation returned by the service.
     * @throws EmptyModeledException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.AllTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/AllTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default AllTypesResponse allTypes(AllTypesRequest allTypesRequest) throws EmptyModeledException, AwsServiceException,
            SdkClientException, ProtocolRestJsonException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the AllTypes operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AllTypesRequest.Builder} avoiding the need to
     * create one manually via {@link AllTypesRequest#builder()}
     * </p>
     *
     * @param allTypesRequest
     *        A {@link Consumer} that will call methods on {@link AllTypesStructure.Builder} to create a request.
     * @return Result of the AllTypes operation returned by the service.
     * @throws EmptyModeledException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.AllTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/AllTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default AllTypesResponse allTypes(Consumer<AllTypesRequest.Builder> allTypesRequest) throws EmptyModeledException,
            AwsServiceException, SdkClientException, ProtocolRestJsonException {
        return allTypes(AllTypesRequest.builder().applyMutation(allTypesRequest).build());
    }

    /**
     * Invokes the DeleteOperation operation.
     *
     * @return Result of the DeleteOperation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.DeleteOperation
     * @see #deleteOperation(DeleteOperationRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/DeleteOperation" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteOperationResponse deleteOperation() throws AwsServiceException, SdkClientException, ProtocolRestJsonException {
        return deleteOperation(DeleteOperationRequest.builder().build());
    }

    /**
     * Invokes the DeleteOperation operation.
     *
     * @param deleteOperationRequest
     * @return Result of the DeleteOperation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.DeleteOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/DeleteOperation" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteOperationResponse deleteOperation(DeleteOperationRequest deleteOperationRequest) throws AwsServiceException,
            SdkClientException, ProtocolRestJsonException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the DeleteOperation operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOperationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteOperationRequest#builder()}
     * </p>
     *
     * @param deleteOperationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteOperationRequest.Builder} to create a request.
     * @return Result of the DeleteOperation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.DeleteOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/DeleteOperation" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteOperationResponse deleteOperation(Consumer<DeleteOperationRequest.Builder> deleteOperationRequest)
            throws AwsServiceException, SdkClientException, ProtocolRestJsonException {
        return deleteOperation(DeleteOperationRequest.builder().applyMutation(deleteOperationRequest).build());
    }

    /**
     * Invokes the HeadOperation operation.
     *
     * @return Result of the HeadOperation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.HeadOperation
     * @see #headOperation(HeadOperationRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/HeadOperation" target="_top">AWS API
     *      Documentation</a>
     */
    default HeadOperationResponse headOperation() throws AwsServiceException, SdkClientException, ProtocolRestJsonException {
        return headOperation(HeadOperationRequest.builder().build());
    }

    /**
     * Invokes the HeadOperation operation.
     *
     * @param headOperationRequest
     * @return Result of the HeadOperation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.HeadOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/HeadOperation" target="_top">AWS API
     *      Documentation</a>
     */
    default HeadOperationResponse headOperation(HeadOperationRequest headOperationRequest) throws AwsServiceException,
            SdkClientException, ProtocolRestJsonException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the HeadOperation operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link HeadOperationRequest.Builder} avoiding the need to
     * create one manually via {@link HeadOperationRequest#builder()}
     * </p>
     *
     * @param headOperationRequest
     *        A {@link Consumer} that will call methods on {@link HeadOperationRequest.Builder} to create a request.
     * @return Result of the HeadOperation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.HeadOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/HeadOperation" target="_top">AWS API
     *      Documentation</a>
     */
    default HeadOperationResponse headOperation(Consumer<HeadOperationRequest.Builder> headOperationRequest)
            throws AwsServiceException, SdkClientException, ProtocolRestJsonException {
        return headOperation(HeadOperationRequest.builder().applyMutation(headOperationRequest).build());
    }

    /**
     * Invokes the IdempotentOperation operation.
     *
     * @param idempotentOperationRequest
     * @return Result of the IdempotentOperation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.IdempotentOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/IdempotentOperation" target="_top">AWS
     *      API Documentation</a>
     */
    default IdempotentOperationResponse idempotentOperation(IdempotentOperationRequest idempotentOperationRequest)
            throws AwsServiceException, SdkClientException, ProtocolRestJsonException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the IdempotentOperation operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link IdempotentOperationRequest.Builder} avoiding the
     * need to create one manually via {@link IdempotentOperationRequest#builder()}
     * </p>
     *
     * @param idempotentOperationRequest
     *        A {@link Consumer} that will call methods on {@link IdempotentOperationStructure.Builder} to create a
     *        request.
     * @return Result of the IdempotentOperation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.IdempotentOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/IdempotentOperation" target="_top">AWS
     *      API Documentation</a>
     */
    default IdempotentOperationResponse idempotentOperation(
            Consumer<IdempotentOperationRequest.Builder> idempotentOperationRequest) throws AwsServiceException,
            SdkClientException, ProtocolRestJsonException {
        return idempotentOperation(IdempotentOperationRequest.builder().applyMutation(idempotentOperationRequest).build());
    }

    /**
     * Invokes the JsonValuesOperation operation.
     *
     * @return Result of the JsonValuesOperation operation returned by the service.
     * @throws EmptyModeledException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.JsonValuesOperation
     * @see #jsonValuesOperation(JsonValuesOperationRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/JsonValuesOperation" target="_top">AWS
     *      API Documentation</a>
     */
    default JsonValuesOperationResponse jsonValuesOperation() throws EmptyModeledException, AwsServiceException,
            SdkClientException, ProtocolRestJsonException {
        return jsonValuesOperation(JsonValuesOperationRequest.builder().build());
    }

    /**
     * Invokes the JsonValuesOperation operation.
     *
     * @param jsonValuesOperationRequest
     * @return Result of the JsonValuesOperation operation returned by the service.
     * @throws EmptyModeledException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.JsonValuesOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/JsonValuesOperation" target="_top">AWS
     *      API Documentation</a>
     */
    default JsonValuesOperationResponse jsonValuesOperation(JsonValuesOperationRequest jsonValuesOperationRequest)
            throws EmptyModeledException, AwsServiceException, SdkClientException, ProtocolRestJsonException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the JsonValuesOperation operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link JsonValuesOperationRequest.Builder} avoiding the
     * need to create one manually via {@link JsonValuesOperationRequest#builder()}
     * </p>
     *
     * @param jsonValuesOperationRequest
     *        A {@link Consumer} that will call methods on {@link JsonValuesStructure.Builder} to create a request.
     * @return Result of the JsonValuesOperation operation returned by the service.
     * @throws EmptyModeledException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.JsonValuesOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/JsonValuesOperation" target="_top">AWS
     *      API Documentation</a>
     */
    default JsonValuesOperationResponse jsonValuesOperation(
            Consumer<JsonValuesOperationRequest.Builder> jsonValuesOperationRequest) throws EmptyModeledException,
            AwsServiceException, SdkClientException, ProtocolRestJsonException {
        return jsonValuesOperation(JsonValuesOperationRequest.builder().applyMutation(jsonValuesOperationRequest).build());
    }

    /**
     * Invokes the MapOfStringToListOfStringInQueryParams operation.
     *
     * @return Result of the MapOfStringToListOfStringInQueryParams operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.MapOfStringToListOfStringInQueryParams
     * @see #mapOfStringToListOfStringInQueryParams(MapOfStringToListOfStringInQueryParamsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/MapOfStringToListOfStringInQueryParams"
     *      target="_top">AWS API Documentation</a>
     */
    default MapOfStringToListOfStringInQueryParamsResponse mapOfStringToListOfStringInQueryParams() throws AwsServiceException,
            SdkClientException, ProtocolRestJsonException {
        return mapOfStringToListOfStringInQueryParams(MapOfStringToListOfStringInQueryParamsRequest.builder().build());
    }

    /**
     * Invokes the MapOfStringToListOfStringInQueryParams operation.
     *
     * @param mapOfStringToListOfStringInQueryParamsRequest
     * @return Result of the MapOfStringToListOfStringInQueryParams operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.MapOfStringToListOfStringInQueryParams
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/MapOfStringToListOfStringInQueryParams"
     *      target="_top">AWS API Documentation</a>
     */
    default MapOfStringToListOfStringInQueryParamsResponse mapOfStringToListOfStringInQueryParams(
            MapOfStringToListOfStringInQueryParamsRequest mapOfStringToListOfStringInQueryParamsRequest)
            throws AwsServiceException, SdkClientException, ProtocolRestJsonException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the MapOfStringToListOfStringInQueryParams operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link MapOfStringToListOfStringInQueryParamsRequest.Builder} avoiding the need to create one manually via
     * {@link MapOfStringToListOfStringInQueryParamsRequest#builder()}
     * </p>
     *
     * @param mapOfStringToListOfStringInQueryParamsRequest
     *        A {@link Consumer} that will call methods on {@link MapOfStringToListOfStringInQueryParamsInput.Builder}
     *        to create a request.
     * @return Result of the MapOfStringToListOfStringInQueryParams operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.MapOfStringToListOfStringInQueryParams
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/MapOfStringToListOfStringInQueryParams"
     *      target="_top">AWS API Documentation</a>
     */
    default MapOfStringToListOfStringInQueryParamsResponse mapOfStringToListOfStringInQueryParams(
            Consumer<MapOfStringToListOfStringInQueryParamsRequest.Builder> mapOfStringToListOfStringInQueryParamsRequest)
            throws AwsServiceException, SdkClientException, ProtocolRestJsonException {
        return mapOfStringToListOfStringInQueryParams(MapOfStringToListOfStringInQueryParamsRequest.builder()
                .applyMutation(mapOfStringToListOfStringInQueryParamsRequest).build());
    }

    /**
     * Invokes the MembersInHeaders operation.
     *
     * @return Result of the MembersInHeaders operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.MembersInHeaders
     * @see #membersInHeaders(MembersInHeadersRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/MembersInHeaders" target="_top">AWS API
     *      Documentation</a>
     */
    default MembersInHeadersResponse membersInHeaders() throws AwsServiceException, SdkClientException, ProtocolRestJsonException {
        return membersInHeaders(MembersInHeadersRequest.builder().build());
    }

    /**
     * Invokes the MembersInHeaders operation.
     *
     * @param membersInHeadersRequest
     * @return Result of the MembersInHeaders operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.MembersInHeaders
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/MembersInHeaders" target="_top">AWS API
     *      Documentation</a>
     */
    default MembersInHeadersResponse membersInHeaders(MembersInHeadersRequest membersInHeadersRequest)
            throws AwsServiceException, SdkClientException, ProtocolRestJsonException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the MembersInHeaders operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link MembersInHeadersRequest.Builder} avoiding the need
     * to create one manually via {@link MembersInHeadersRequest#builder()}
     * </p>
     *
     * @param membersInHeadersRequest
     *        A {@link Consumer} that will call methods on {@link MembersInHeadersInput.Builder} to create a request.
     * @return Result of the MembersInHeaders operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.MembersInHeaders
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/MembersInHeaders" target="_top">AWS API
     *      Documentation</a>
     */
    default MembersInHeadersResponse membersInHeaders(Consumer<MembersInHeadersRequest.Builder> membersInHeadersRequest)
            throws AwsServiceException, SdkClientException, ProtocolRestJsonException {
        return membersInHeaders(MembersInHeadersRequest.builder().applyMutation(membersInHeadersRequest).build());
    }

    /**
     * Invokes the MembersInQueryParams operation.
     *
     * @return Result of the MembersInQueryParams operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.MembersInQueryParams
     * @see #membersInQueryParams(MembersInQueryParamsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/MembersInQueryParams" target="_top">AWS
     *      API Documentation</a>
     */
    default MembersInQueryParamsResponse membersInQueryParams() throws AwsServiceException, SdkClientException,
            ProtocolRestJsonException {
        return membersInQueryParams(MembersInQueryParamsRequest.builder().build());
    }

    /**
     * Invokes the MembersInQueryParams operation.
     *
     * @param membersInQueryParamsRequest
     * @return Result of the MembersInQueryParams operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.MembersInQueryParams
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/MembersInQueryParams" target="_top">AWS
     *      API Documentation</a>
     */
    default MembersInQueryParamsResponse membersInQueryParams(MembersInQueryParamsRequest membersInQueryParamsRequest)
            throws AwsServiceException, SdkClientException, ProtocolRestJsonException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the MembersInQueryParams operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link MembersInQueryParamsRequest.Builder} avoiding the
     * need to create one manually via {@link MembersInQueryParamsRequest#builder()}
     * </p>
     *
     * @param membersInQueryParamsRequest
     *        A {@link Consumer} that will call methods on {@link MembersInQueryParamsInput.Builder} to create a
     *        request.
     * @return Result of the MembersInQueryParams operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.MembersInQueryParams
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/MembersInQueryParams" target="_top">AWS
     *      API Documentation</a>
     */
    default MembersInQueryParamsResponse membersInQueryParams(
            Consumer<MembersInQueryParamsRequest.Builder> membersInQueryParamsRequest) throws AwsServiceException,
            SdkClientException, ProtocolRestJsonException {
        return membersInQueryParams(MembersInQueryParamsRequest.builder().applyMutation(membersInQueryParamsRequest).build());
    }

    /**
     * Invokes the MultiLocationOperation operation.
     *
     * @param multiLocationOperationRequest
     * @return Result of the MultiLocationOperation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.MultiLocationOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/MultiLocationOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default MultiLocationOperationResponse multiLocationOperation(MultiLocationOperationRequest multiLocationOperationRequest)
            throws AwsServiceException, SdkClientException, ProtocolRestJsonException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the MultiLocationOperation operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link MultiLocationOperationRequest.Builder} avoiding the
     * need to create one manually via {@link MultiLocationOperationRequest#builder()}
     * </p>
     *
     * @param multiLocationOperationRequest
     *        A {@link Consumer} that will call methods on {@link MultiLocationOperationInput.Builder} to create a
     *        request.
     * @return Result of the MultiLocationOperation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.MultiLocationOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/MultiLocationOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default MultiLocationOperationResponse multiLocationOperation(
            Consumer<MultiLocationOperationRequest.Builder> multiLocationOperationRequest) throws AwsServiceException,
            SdkClientException, ProtocolRestJsonException {
        return multiLocationOperation(MultiLocationOperationRequest.builder().applyMutation(multiLocationOperationRequest)
                .build());
    }

    /**
     * Invokes the NestedContainers operation.
     *
     * @return Result of the NestedContainers operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.NestedContainers
     * @see #nestedContainers(NestedContainersRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/NestedContainers" target="_top">AWS API
     *      Documentation</a>
     */
    default NestedContainersResponse nestedContainers() throws AwsServiceException, SdkClientException, ProtocolRestJsonException {
        return nestedContainers(NestedContainersRequest.builder().build());
    }

    /**
     * Invokes the NestedContainers operation.
     *
     * @param nestedContainersRequest
     * @return Result of the NestedContainers operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.NestedContainers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/NestedContainers" target="_top">AWS API
     *      Documentation</a>
     */
    default NestedContainersResponse nestedContainers(NestedContainersRequest nestedContainersRequest)
            throws AwsServiceException, SdkClientException, ProtocolRestJsonException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the NestedContainers operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link NestedContainersRequest.Builder} avoiding the need
     * to create one manually via {@link NestedContainersRequest#builder()}
     * </p>
     *
     * @param nestedContainersRequest
     *        A {@link Consumer} that will call methods on {@link NestedContainersStructure.Builder} to create a
     *        request.
     * @return Result of the NestedContainers operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.NestedContainers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/NestedContainers" target="_top">AWS API
     *      Documentation</a>
     */
    default NestedContainersResponse nestedContainers(Consumer<NestedContainersRequest.Builder> nestedContainersRequest)
            throws AwsServiceException, SdkClientException, ProtocolRestJsonException {
        return nestedContainers(NestedContainersRequest.builder().applyMutation(nestedContainersRequest).build());
    }

    /**
     * Invokes the OperationWithExplicitPayloadBlob operation.
     *
     * @return Result of the OperationWithExplicitPayloadBlob operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.OperationWithExplicitPayloadBlob
     * @see #operationWithExplicitPayloadBlob(OperationWithExplicitPayloadBlobRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithExplicitPayloadBlob"
     *      target="_top">AWS API Documentation</a>
     */
    default OperationWithExplicitPayloadBlobResponse operationWithExplicitPayloadBlob() throws AwsServiceException,
            SdkClientException, ProtocolRestJsonException {
        return operationWithExplicitPayloadBlob(OperationWithExplicitPayloadBlobRequest.builder().build());
    }

    /**
     * Invokes the OperationWithExplicitPayloadBlob operation.
     *
     * @param operationWithExplicitPayloadBlobRequest
     * @return Result of the OperationWithExplicitPayloadBlob operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.OperationWithExplicitPayloadBlob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithExplicitPayloadBlob"
     *      target="_top">AWS API Documentation</a>
     */
    default OperationWithExplicitPayloadBlobResponse operationWithExplicitPayloadBlob(
            OperationWithExplicitPayloadBlobRequest operationWithExplicitPayloadBlobRequest) throws AwsServiceException,
            SdkClientException, ProtocolRestJsonException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the OperationWithExplicitPayloadBlob operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link OperationWithExplicitPayloadBlobRequest.Builder}
     * avoiding the need to create one manually via {@link OperationWithExplicitPayloadBlobRequest#builder()}
     * </p>
     *
     * @param operationWithExplicitPayloadBlobRequest
     *        A {@link Consumer} that will call methods on {@link OperationWithExplicitPayloadBlobInput.Builder} to
     *        create a request.
     * @return Result of the OperationWithExplicitPayloadBlob operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.OperationWithExplicitPayloadBlob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithExplicitPayloadBlob"
     *      target="_top">AWS API Documentation</a>
     */
    default OperationWithExplicitPayloadBlobResponse operationWithExplicitPayloadBlob(
            Consumer<OperationWithExplicitPayloadBlobRequest.Builder> operationWithExplicitPayloadBlobRequest)
            throws AwsServiceException, SdkClientException, ProtocolRestJsonException {
        return operationWithExplicitPayloadBlob(OperationWithExplicitPayloadBlobRequest.builder()
                .applyMutation(operationWithExplicitPayloadBlobRequest).build());
    }

    /**
     * Invokes the OperationWithExplicitPayloadStructure operation.
     *
     * @return Result of the OperationWithExplicitPayloadStructure operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.OperationWithExplicitPayloadStructure
     * @see #operationWithExplicitPayloadStructure(OperationWithExplicitPayloadStructureRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithExplicitPayloadStructure"
     *      target="_top">AWS API Documentation</a>
     */
    default OperationWithExplicitPayloadStructureResponse operationWithExplicitPayloadStructure() throws AwsServiceException,
            SdkClientException, ProtocolRestJsonException {
        return operationWithExplicitPayloadStructure(OperationWithExplicitPayloadStructureRequest.builder().build());
    }

    /**
     * Invokes the OperationWithExplicitPayloadStructure operation.
     *
     * @param operationWithExplicitPayloadStructureRequest
     * @return Result of the OperationWithExplicitPayloadStructure operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.OperationWithExplicitPayloadStructure
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithExplicitPayloadStructure"
     *      target="_top">AWS API Documentation</a>
     */
    default OperationWithExplicitPayloadStructureResponse operationWithExplicitPayloadStructure(
            OperationWithExplicitPayloadStructureRequest operationWithExplicitPayloadStructureRequest)
            throws AwsServiceException, SdkClientException, ProtocolRestJsonException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the OperationWithExplicitPayloadStructure operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link OperationWithExplicitPayloadStructureRequest.Builder} avoiding the need to create one manually via
     * {@link OperationWithExplicitPayloadStructureRequest#builder()}
     * </p>
     *
     * @param operationWithExplicitPayloadStructureRequest
     *        A {@link Consumer} that will call methods on {@link OperationWithExplicitPayloadStructureInput.Builder} to
     *        create a request.
     * @return Result of the OperationWithExplicitPayloadStructure operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.OperationWithExplicitPayloadStructure
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithExplicitPayloadStructure"
     *      target="_top">AWS API Documentation</a>
     */
    default OperationWithExplicitPayloadStructureResponse operationWithExplicitPayloadStructure(
            Consumer<OperationWithExplicitPayloadStructureRequest.Builder> operationWithExplicitPayloadStructureRequest)
            throws AwsServiceException, SdkClientException, ProtocolRestJsonException {
        return operationWithExplicitPayloadStructure(OperationWithExplicitPayloadStructureRequest.builder()
                .applyMutation(operationWithExplicitPayloadStructureRequest).build());
    }

    /**
     * Invokes the OperationWithGreedyLabel operation.
     *
     * @param operationWithGreedyLabelRequest
     * @return Result of the OperationWithGreedyLabel operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.OperationWithGreedyLabel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithGreedyLabel"
     *      target="_top">AWS API Documentation</a>
     */
    default OperationWithGreedyLabelResponse operationWithGreedyLabel(
            OperationWithGreedyLabelRequest operationWithGreedyLabelRequest) throws AwsServiceException, SdkClientException,
            ProtocolRestJsonException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the OperationWithGreedyLabel operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link OperationWithGreedyLabelRequest.Builder} avoiding
     * the need to create one manually via {@link OperationWithGreedyLabelRequest#builder()}
     * </p>
     *
     * @param operationWithGreedyLabelRequest
     *        A {@link Consumer} that will call methods on {@link OperationWithGreedyLabelInput.Builder} to create a
     *        request.
     * @return Result of the OperationWithGreedyLabel operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.OperationWithGreedyLabel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithGreedyLabel"
     *      target="_top">AWS API Documentation</a>
     */
    default OperationWithGreedyLabelResponse operationWithGreedyLabel(
            Consumer<OperationWithGreedyLabelRequest.Builder> operationWithGreedyLabelRequest) throws AwsServiceException,
            SdkClientException, ProtocolRestJsonException {
        return operationWithGreedyLabel(OperationWithGreedyLabelRequest.builder().applyMutation(operationWithGreedyLabelRequest)
                .build());
    }

    /**
     * Invokes the OperationWithModeledContentType operation.
     *
     * @return Result of the OperationWithModeledContentType operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.OperationWithModeledContentType
     * @see #operationWithModeledContentType(OperationWithModeledContentTypeRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithModeledContentType"
     *      target="_top">AWS API Documentation</a>
     */
    default OperationWithModeledContentTypeResponse operationWithModeledContentType() throws AwsServiceException,
            SdkClientException, ProtocolRestJsonException {
        return operationWithModeledContentType(OperationWithModeledContentTypeRequest.builder().build());
    }

    /**
     * Invokes the OperationWithModeledContentType operation.
     *
     * @param operationWithModeledContentTypeRequest
     * @return Result of the OperationWithModeledContentType operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.OperationWithModeledContentType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithModeledContentType"
     *      target="_top">AWS API Documentation</a>
     */
    default OperationWithModeledContentTypeResponse operationWithModeledContentType(
            OperationWithModeledContentTypeRequest operationWithModeledContentTypeRequest) throws AwsServiceException,
            SdkClientException, ProtocolRestJsonException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the OperationWithModeledContentType operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link OperationWithModeledContentTypeRequest.Builder}
     * avoiding the need to create one manually via {@link OperationWithModeledContentTypeRequest#builder()}
     * </p>
     *
     * @param operationWithModeledContentTypeRequest
     *        A {@link Consumer} that will call methods on {@link OperationWithModeledContentTypeInput.Builder} to
     *        create a request.
     * @return Result of the OperationWithModeledContentType operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.OperationWithModeledContentType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithModeledContentType"
     *      target="_top">AWS API Documentation</a>
     */
    default OperationWithModeledContentTypeResponse operationWithModeledContentType(
            Consumer<OperationWithModeledContentTypeRequest.Builder> operationWithModeledContentTypeRequest)
            throws AwsServiceException, SdkClientException, ProtocolRestJsonException {
        return operationWithModeledContentType(OperationWithModeledContentTypeRequest.builder()
                .applyMutation(operationWithModeledContentTypeRequest).build());
    }

    /**
     * Invokes the OperationWithNoInputOrOutput operation.
     *
     * @return Result of the OperationWithNoInputOrOutput operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.OperationWithNoInputOrOutput
     * @see #operationWithNoInputOrOutput(OperationWithNoInputOrOutputRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithNoInputOrOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default OperationWithNoInputOrOutputResponse operationWithNoInputOrOutput() throws AwsServiceException, SdkClientException,
            ProtocolRestJsonException {
        return operationWithNoInputOrOutput(OperationWithNoInputOrOutputRequest.builder().build());
    }

    /**
     * Invokes the OperationWithNoInputOrOutput operation.
     *
     * @param operationWithNoInputOrOutputRequest
     * @return Result of the OperationWithNoInputOrOutput operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.OperationWithNoInputOrOutput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithNoInputOrOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default OperationWithNoInputOrOutputResponse operationWithNoInputOrOutput(
            OperationWithNoInputOrOutputRequest operationWithNoInputOrOutputRequest) throws AwsServiceException,
            SdkClientException, ProtocolRestJsonException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the OperationWithNoInputOrOutput operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link OperationWithNoInputOrOutputRequest.Builder}
     * avoiding the need to create one manually via {@link OperationWithNoInputOrOutputRequest#builder()}
     * </p>
     *
     * @param operationWithNoInputOrOutputRequest
     *        A {@link Consumer} that will call methods on {@link OperationWithNoInputOrOutputRequest.Builder} to create
     *        a request.
     * @return Result of the OperationWithNoInputOrOutput operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.OperationWithNoInputOrOutput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/OperationWithNoInputOrOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default OperationWithNoInputOrOutputResponse operationWithNoInputOrOutput(
            Consumer<OperationWithNoInputOrOutputRequest.Builder> operationWithNoInputOrOutputRequest)
            throws AwsServiceException, SdkClientException, ProtocolRestJsonException {
        return operationWithNoInputOrOutput(OperationWithNoInputOrOutputRequest.builder()
                .applyMutation(operationWithNoInputOrOutputRequest).build());
    }

    /**
     * Invokes the QueryParamWithoutValue operation.
     *
     * @return Result of the QueryParamWithoutValue operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.QueryParamWithoutValue
     * @see #queryParamWithoutValue(QueryParamWithoutValueRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/QueryParamWithoutValue"
     *      target="_top">AWS API Documentation</a>
     */
    default QueryParamWithoutValueResponse queryParamWithoutValue() throws AwsServiceException, SdkClientException,
            ProtocolRestJsonException {
        return queryParamWithoutValue(QueryParamWithoutValueRequest.builder().build());
    }

    /**
     * Invokes the QueryParamWithoutValue operation.
     *
     * @param queryParamWithoutValueRequest
     * @return Result of the QueryParamWithoutValue operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.QueryParamWithoutValue
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/QueryParamWithoutValue"
     *      target="_top">AWS API Documentation</a>
     */
    default QueryParamWithoutValueResponse queryParamWithoutValue(QueryParamWithoutValueRequest queryParamWithoutValueRequest)
            throws AwsServiceException, SdkClientException, ProtocolRestJsonException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the QueryParamWithoutValue operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link QueryParamWithoutValueRequest.Builder} avoiding the
     * need to create one manually via {@link QueryParamWithoutValueRequest#builder()}
     * </p>
     *
     * @param queryParamWithoutValueRequest
     *        A {@link Consumer} that will call methods on {@link QueryParamWithoutValueInput.Builder} to create a
     *        request.
     * @return Result of the QueryParamWithoutValue operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.QueryParamWithoutValue
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/QueryParamWithoutValue"
     *      target="_top">AWS API Documentation</a>
     */
    default QueryParamWithoutValueResponse queryParamWithoutValue(
            Consumer<QueryParamWithoutValueRequest.Builder> queryParamWithoutValueRequest) throws AwsServiceException,
            SdkClientException, ProtocolRestJsonException {
        return queryParamWithoutValue(QueryParamWithoutValueRequest.builder().applyMutation(queryParamWithoutValueRequest)
                .build());
    }

    /**
     * Invokes the StreamingInputOperation operation.
     *
     * @param streamingInputOperationRequest
     * @param requestBody
     *        The content to send to the service. A {@link RequestBody} can be created using one of several factory
     *        methods for various sources of data. For example, to create a request body from a file you can do the
     *        following.
     * 
     *        <pre>
     * {@code RequestBody.fromFile(new File("myfile.txt"))}
     * </pre>
     * 
     *        See documentation in {@link RequestBody} for additional details and which sources of data are supported.
     *        The service documentation for the request content is as follows ''
     * @return Result of the StreamingInputOperation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.StreamingInputOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/StreamingInputOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default StreamingInputOperationResponse streamingInputOperation(
            StreamingInputOperationRequest streamingInputOperationRequest, RequestBody requestBody) throws AwsServiceException,
            SdkClientException, ProtocolRestJsonException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the StreamingInputOperation operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StreamingInputOperationRequest.Builder} avoiding
     * the need to create one manually via {@link StreamingInputOperationRequest#builder()}
     * </p>
     *
     * @param streamingInputOperationRequest
     *        A {@link Consumer} that will call methods on {@link StructureWithStreamingMember.Builder} to create a
     *        request.
     * @param requestBody
     *        The content to send to the service. A {@link RequestBody} can be created using one of several factory
     *        methods for various sources of data. For example, to create a request body from a file you can do the
     *        following.
     * 
     *        <pre>
     * {@code RequestBody.fromFile(new File("myfile.txt"))}
     * </pre>
     * 
     *        See documentation in {@link RequestBody} for additional details and which sources of data are supported.
     *        The service documentation for the request content is as follows ''
     * @return Result of the StreamingInputOperation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.StreamingInputOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/StreamingInputOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default StreamingInputOperationResponse streamingInputOperation(
            Consumer<StreamingInputOperationRequest.Builder> streamingInputOperationRequest, RequestBody requestBody)
            throws AwsServiceException, SdkClientException, ProtocolRestJsonException {
        return streamingInputOperation(StreamingInputOperationRequest.builder().applyMutation(streamingInputOperationRequest)
                .build(), requestBody);
    }

    /**
     * Invokes the StreamingInputOperation operation.
     *
     * @param streamingInputOperationRequest
     * @param sourcePath
     *        {@link Path} to file containing data to send to the service. File will be read entirely and may be read
     *        multiple times in the event of a retry. If the file does not exist or the current user does not have
     *        access to read it then an exception will be thrown. The service documentation for the request content is
     *        as follows ''
     * @return Result of the StreamingInputOperation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.StreamingInputOperation
     * @see #streamingInputOperation(StreamingInputOperationRequest, RequestBody)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/StreamingInputOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default StreamingInputOperationResponse streamingInputOperation(
            StreamingInputOperationRequest streamingInputOperationRequest, Path filePath) throws AwsServiceException,
            SdkClientException, ProtocolRestJsonException {
        return streamingInputOperation(streamingInputOperationRequest, RequestBody.fromFile(filePath));
    }

    /**
     * Invokes the StreamingInputOperation operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StreamingInputOperationRequest.Builder} avoiding
     * the need to create one manually via {@link StreamingInputOperationRequest#builder()}
     * </p>
     *
     * @param streamingInputOperationRequest
     *        A {@link Consumer} that will call methods on {@link StructureWithStreamingMember.Builder} to create a
     *        request.
     * @param sourcePath
     *        {@link Path} to file containing data to send to the service. File will be read entirely and may be read
     *        multiple times in the event of a retry. If the file does not exist or the current user does not have
     *        access to read it then an exception will be thrown. The service documentation for the request content is
     *        as follows ''
     * @return Result of the StreamingInputOperation operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.StreamingInputOperation
     * @see #streamingInputOperation(StreamingInputOperationRequest, RequestBody)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/StreamingInputOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default StreamingInputOperationResponse streamingInputOperation(
            Consumer<StreamingInputOperationRequest.Builder> streamingInputOperationRequest, Path filePath)
            throws AwsServiceException, SdkClientException, ProtocolRestJsonException {
        return streamingInputOperation(StreamingInputOperationRequest.builder().applyMutation(streamingInputOperationRequest)
                .build(), filePath);
    }

    /**
     * Invokes the StreamingOutputOperation operation.
     *
     * @param streamingOutputOperationRequest
     * @param responseTransformer
     *        Functional interface for processing the streamed response content. The unmarshalled
     *        StreamingInputOperationRequest and an InputStream to the response content are provided as parameters to
     *        the callback. The callback may return a transformed type which will be the return value of this method.
     *        See {@link software.amazon.awssdk.core.sync.ResponseTransformer} for details on implementing this
     *        interface and for links to pre-canned implementations for common scenarios like downloading to a file. The
     *        service documentation for the response content is as follows ''.
     * @return The transformed result of the ResponseTransformer.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.StreamingOutputOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/StreamingOutputOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default <ReturnT> ReturnT streamingOutputOperation(StreamingOutputOperationRequest streamingOutputOperationRequest,
            ResponseTransformer<StreamingOutputOperationResponse, ReturnT> responseTransformer) throws AwsServiceException,
            SdkClientException, ProtocolRestJsonException {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the StreamingOutputOperation operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StreamingOutputOperationRequest.Builder} avoiding
     * the need to create one manually via {@link StreamingOutputOperationRequest#builder()}
     * </p>
     *
     * @param streamingOutputOperationRequest
     *        A {@link Consumer} that will call methods on {@link StreamingOutputOperationRequest.Builder} to create a
     *        request.
     * @param responseTransformer
     *        Functional interface for processing the streamed response content. The unmarshalled
     *        StreamingInputOperationRequest and an InputStream to the response content are provided as parameters to
     *        the callback. The callback may return a transformed type which will be the return value of this method.
     *        See {@link software.amazon.awssdk.core.sync.ResponseTransformer} for details on implementing this
     *        interface and for links to pre-canned implementations for common scenarios like downloading to a file. The
     *        service documentation for the response content is as follows ''.
     * @return The transformed result of the ResponseTransformer.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.StreamingOutputOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/StreamingOutputOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default <ReturnT> ReturnT streamingOutputOperation(
            Consumer<StreamingOutputOperationRequest.Builder> streamingOutputOperationRequest,
            ResponseTransformer<StreamingOutputOperationResponse, ReturnT> responseTransformer) throws AwsServiceException,
            SdkClientException, ProtocolRestJsonException {
        return streamingOutputOperation(StreamingOutputOperationRequest.builder().applyMutation(streamingOutputOperationRequest)
                .build(), responseTransformer);
    }

    /**
     * Invokes the StreamingOutputOperation operation.
     *
     * @param streamingOutputOperationRequest
     * @param destinationPath
     *        {@link Path} to file that response contents will be written to. The file must not exist or this method
     *        will throw an exception. If the file is not writable by the current user then an exception will be thrown.
     *        The service documentation for the response content is as follows ''.
     * @return The transformed result of the ResponseTransformer.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.StreamingOutputOperation
     * @see #streamingOutputOperation(StreamingOutputOperationRequest, ResponseTransformer)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/StreamingOutputOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default StreamingOutputOperationResponse streamingOutputOperation(
            StreamingOutputOperationRequest streamingOutputOperationRequest, Path filePath) throws AwsServiceException,
            SdkClientException, ProtocolRestJsonException {
        return streamingOutputOperation(streamingOutputOperationRequest, ResponseTransformer.toFile(filePath));
    }

    /**
     * Invokes the StreamingOutputOperation operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StreamingOutputOperationRequest.Builder} avoiding
     * the need to create one manually via {@link StreamingOutputOperationRequest#builder()}
     * </p>
     *
     * @param streamingOutputOperationRequest
     *        A {@link Consumer} that will call methods on {@link StreamingOutputOperationRequest.Builder} to create a
     *        request.
     * @param destinationPath
     *        {@link Path} to file that response contents will be written to. The file must not exist or this method
     *        will throw an exception. If the file is not writable by the current user then an exception will be thrown.
     *        The service documentation for the response content is as follows ''.
     * @return The transformed result of the ResponseTransformer.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.StreamingOutputOperation
     * @see #streamingOutputOperation(StreamingOutputOperationRequest, ResponseTransformer)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/StreamingOutputOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default StreamingOutputOperationResponse streamingOutputOperation(
            Consumer<StreamingOutputOperationRequest.Builder> streamingOutputOperationRequest, Path filePath)
            throws AwsServiceException, SdkClientException, ProtocolRestJsonException {
        return streamingOutputOperation(StreamingOutputOperationRequest.builder().applyMutation(streamingOutputOperationRequest)
                .build(), filePath);
    }

    /**
     * Invokes the StreamingOutputOperation operation.
     *
     * @param streamingOutputOperationRequest
     * @return A {@link ResponseInputStream} containing data streamed from service. Note that this is an unmanaged
     *         reference to the underlying HTTP connection so great care must be taken to ensure all data if fully read
     *         from the input stream and that it is properly closed. Failure to do so may result in sub-optimal behavior
     *         and exhausting connections in the connection pool. The unmarshalled response object can be obtained via
     *         {@link ResponseInputStream#response()}. The service documentation for the response content is as follows
     *         ''.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.StreamingOutputOperation
     * @see #getObject(streamingOutputOperation, ResponseTransformer)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/StreamingOutputOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default ResponseInputStream<StreamingOutputOperationResponse> streamingOutputOperation(
            StreamingOutputOperationRequest streamingOutputOperationRequest) throws AwsServiceException, SdkClientException,
            ProtocolRestJsonException {
        return streamingOutputOperation(streamingOutputOperationRequest, ResponseTransformer.toInputStream());
    }

    /**
     * Invokes the StreamingOutputOperation operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StreamingOutputOperationRequest.Builder} avoiding
     * the need to create one manually via {@link StreamingOutputOperationRequest#builder()}
     * </p>
     *
     * @param streamingOutputOperationRequest
     *        A {@link Consumer} that will call methods on {@link StreamingOutputOperationRequest.Builder} to create a
     *        request.
     * @return A {@link ResponseInputStream} containing data streamed from service. Note that this is an unmanaged
     *         reference to the underlying HTTP connection so great care must be taken to ensure all data if fully read
     *         from the input stream and that it is properly closed. Failure to do so may result in sub-optimal behavior
     *         and exhausting connections in the connection pool. The unmarshalled response object can be obtained via
     *         {@link ResponseInputStream#response()}. The service documentation for the response content is as follows
     *         ''.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.StreamingOutputOperation
     * @see #getObject(streamingOutputOperation, ResponseTransformer)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/StreamingOutputOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default ResponseInputStream<StreamingOutputOperationResponse> streamingOutputOperation(
            Consumer<StreamingOutputOperationRequest.Builder> streamingOutputOperationRequest) throws AwsServiceException,
            SdkClientException, ProtocolRestJsonException {
        return streamingOutputOperation(StreamingOutputOperationRequest.builder().applyMutation(streamingOutputOperationRequest)
                .build());
    }

    /**
     * Invokes the StreamingOutputOperation operation.
     *
     * @param streamingOutputOperationRequest
     * @return A {@link ResponseBytes} that loads the data streamed from the service into memory and exposes it in
     *         convenient in-memory representations like a byte buffer or string. The unmarshalled response object can
     *         be obtained via {@link ResponseBytes#response()}. The service documentation for the response content is
     *         as follows ''.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.StreamingOutputOperation
     * @see #getObject(streamingOutputOperation, ResponseTransformer)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/StreamingOutputOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default ResponseBytes<StreamingOutputOperationResponse> streamingOutputOperationAsBytes(
            StreamingOutputOperationRequest streamingOutputOperationRequest) throws AwsServiceException, SdkClientException,
            ProtocolRestJsonException {
        return streamingOutputOperation(streamingOutputOperationRequest, ResponseTransformer.toBytes());
    }

    /**
     * Invokes the StreamingOutputOperation operation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StreamingOutputOperationRequest.Builder} avoiding
     * the need to create one manually via {@link StreamingOutputOperationRequest#builder()}
     * </p>
     *
     * @param streamingOutputOperationRequest
     *        A {@link Consumer} that will call methods on {@link StreamingOutputOperationRequest.Builder} to create a
     *        request.
     * @return A {@link ResponseBytes} that loads the data streamed from the service into memory and exposes it in
     *         convenient in-memory representations like a byte buffer or string. The unmarshalled response object can
     *         be obtained via {@link ResponseBytes#response()}. The service documentation for the response content is
     *         as follows ''.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ProtocolRestJsonException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ProtocolRestJsonClient.StreamingOutputOperation
     * @see #getObject(streamingOutputOperation, ResponseTransformer)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/restjson-2016-03-11/StreamingOutputOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default ResponseBytes<StreamingOutputOperationResponse> streamingOutputOperationAsBytes(
            Consumer<StreamingOutputOperationRequest.Builder> streamingOutputOperationRequest) throws AwsServiceException,
            SdkClientException, ProtocolRestJsonException {
        return streamingOutputOperationAsBytes(StreamingOutputOperationRequest.builder()
                .applyMutation(streamingOutputOperationRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("restjson");
    }
}
