/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codedeploy.model.ComputePlatform;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationInfo> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(ApplicationInfo.getter(ApplicationInfo::applicationId)).setter(ApplicationInfo.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()}).build();
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationName").getter(ApplicationInfo.getter(ApplicationInfo::applicationName)).setter(ApplicationInfo.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationName").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(ApplicationInfo.getter(ApplicationInfo::createTime)).setter(ApplicationInfo.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()}).build();
    private static final SdkField<Boolean> LINKED_TO_GIT_HUB_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("linkedToGitHub").getter(ApplicationInfo.getter(ApplicationInfo::linkedToGitHub)).setter(ApplicationInfo.setter(Builder::linkedToGitHub)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("linkedToGitHub").build()}).build();
    private static final SdkField<String> GIT_HUB_ACCOUNT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("gitHubAccountName").getter(ApplicationInfo.getter(ApplicationInfo::gitHubAccountName)).setter(ApplicationInfo.setter(Builder::gitHubAccountName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gitHubAccountName").build()}).build();
    private static final SdkField<String> COMPUTE_PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computePlatform").getter(ApplicationInfo.getter(ApplicationInfo::computePlatformAsString)).setter(ApplicationInfo.setter(Builder::computePlatform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computePlatform").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, APPLICATION_NAME_FIELD, CREATE_TIME_FIELD, LINKED_TO_GIT_HUB_FIELD, GIT_HUB_ACCOUNT_NAME_FIELD, COMPUTE_PLATFORM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ApplicationInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String applicationId;
    private final String applicationName;
    private final Instant createTime;
    private final Boolean linkedToGitHub;
    private final String gitHubAccountName;
    private final String computePlatform;

    private ApplicationInfo(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.applicationName = builder.applicationName;
        this.createTime = builder.createTime;
        this.linkedToGitHub = builder.linkedToGitHub;
        this.gitHubAccountName = builder.gitHubAccountName;
        this.computePlatform = builder.computePlatform;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String applicationName() {
        return this.applicationName;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Boolean linkedToGitHub() {
        return this.linkedToGitHub;
    }

    public final String gitHubAccountName() {
        return this.gitHubAccountName;
    }

    public final ComputePlatform computePlatform() {
        return ComputePlatform.fromValue(this.computePlatform);
    }

    public final String computePlatformAsString() {
        return this.computePlatform;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.linkedToGitHub());
        hashCode = 31 * hashCode + Objects.hashCode(this.gitHubAccountName());
        hashCode = 31 * hashCode + Objects.hashCode(this.computePlatformAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationInfo)) {
            return false;
        }
        ApplicationInfo other = (ApplicationInfo)obj;
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.linkedToGitHub(), other.linkedToGitHub()) && Objects.equals(this.gitHubAccountName(), other.gitHubAccountName()) && Objects.equals(this.computePlatformAsString(), other.computePlatformAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ApplicationInfo").add("ApplicationId", (Object)this.applicationId()).add("ApplicationName", (Object)this.applicationName()).add("CreateTime", (Object)this.createTime()).add("LinkedToGitHub", (Object)this.linkedToGitHub()).add("GitHubAccountName", (Object)this.gitHubAccountName()).add("ComputePlatform", (Object)this.computePlatformAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "applicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "linkedToGitHub": {
                return Optional.ofNullable(clazz.cast(this.linkedToGitHub()));
            }
            case "gitHubAccountName": {
                return Optional.ofNullable(clazz.cast(this.gitHubAccountName()));
            }
            case "computePlatform": {
                return Optional.ofNullable(clazz.cast(this.computePlatformAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("applicationName", APPLICATION_NAME_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("linkedToGitHub", LINKED_TO_GIT_HUB_FIELD);
        map.put("gitHubAccountName", GIT_HUB_ACCOUNT_NAME_FIELD);
        map.put("computePlatform", COMPUTE_PLATFORM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApplicationInfo, T> g) {
        return obj -> g.apply((ApplicationInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String applicationName;
        private Instant createTime;
        private Boolean linkedToGitHub;
        private String gitHubAccountName;
        private String computePlatform;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationInfo model) {
            this.applicationId(model.applicationId);
            this.applicationName(model.applicationName);
            this.createTime(model.createTime);
            this.linkedToGitHub(model.linkedToGitHub);
            this.gitHubAccountName(model.gitHubAccountName);
            this.computePlatform(model.computePlatform);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Boolean getLinkedToGitHub() {
            return this.linkedToGitHub;
        }

        public final void setLinkedToGitHub(Boolean linkedToGitHub) {
            this.linkedToGitHub = linkedToGitHub;
        }

        @Override
        public final Builder linkedToGitHub(Boolean linkedToGitHub) {
            this.linkedToGitHub = linkedToGitHub;
            return this;
        }

        public final String getGitHubAccountName() {
            return this.gitHubAccountName;
        }

        public final void setGitHubAccountName(String gitHubAccountName) {
            this.gitHubAccountName = gitHubAccountName;
        }

        @Override
        public final Builder gitHubAccountName(String gitHubAccountName) {
            this.gitHubAccountName = gitHubAccountName;
            return this;
        }

        public final String getComputePlatform() {
            return this.computePlatform;
        }

        public final void setComputePlatform(String computePlatform) {
            this.computePlatform = computePlatform;
        }

        @Override
        public final Builder computePlatform(String computePlatform) {
            this.computePlatform = computePlatform;
            return this;
        }

        @Override
        public final Builder computePlatform(ComputePlatform computePlatform) {
            this.computePlatform(computePlatform == null ? null : computePlatform.toString());
            return this;
        }

        public ApplicationInfo build() {
            return new ApplicationInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationInfo> {
        public Builder applicationId(String var1);

        public Builder applicationName(String var1);

        public Builder createTime(Instant var1);

        public Builder linkedToGitHub(Boolean var1);

        public Builder gitHubAccountName(String var1);

        public Builder computePlatform(String var1);

        public Builder computePlatform(ComputePlatform var1);
    }
}

