/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployResponse;
import software.amazon.awssdk.services.codedeploy.model.RevisionInfo;
import software.amazon.awssdk.services.codedeploy.model.RevisionInfoListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetApplicationRevisionsResponse
extends CodeDeployResponse
implements ToCopyableBuilder<Builder, BatchGetApplicationRevisionsResponse> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationName").getter(BatchGetApplicationRevisionsResponse.getter(BatchGetApplicationRevisionsResponse::applicationName)).setter(BatchGetApplicationRevisionsResponse.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationName").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorMessage").getter(BatchGetApplicationRevisionsResponse.getter(BatchGetApplicationRevisionsResponse::errorMessage)).setter(BatchGetApplicationRevisionsResponse.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final SdkField<List<RevisionInfo>> REVISIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("revisions").getter(BatchGetApplicationRevisionsResponse.getter(BatchGetApplicationRevisionsResponse::revisions)).setter(BatchGetApplicationRevisionsResponse.setter(Builder::revisions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RevisionInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD, ERROR_MESSAGE_FIELD, REVISIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("applicationName", APPLICATION_NAME_FIELD);
            this.put("errorMessage", ERROR_MESSAGE_FIELD);
            this.put("revisions", REVISIONS_FIELD);
        }
    });
    private final String applicationName;
    private final String errorMessage;
    private final List<RevisionInfo> revisions;

    private BatchGetApplicationRevisionsResponse(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.errorMessage = builder.errorMessage;
        this.revisions = builder.revisions;
    }

    public final String applicationName() {
        return this.applicationName;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final boolean hasRevisions() {
        return this.revisions != null && !(this.revisions instanceof SdkAutoConstructList);
    }

    public final List<RevisionInfo> revisions() {
        return this.revisions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRevisions() ? this.revisions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetApplicationRevisionsResponse)) {
            return false;
        }
        BatchGetApplicationRevisionsResponse other = (BatchGetApplicationRevisionsResponse)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.errorMessage(), other.errorMessage()) && this.hasRevisions() == other.hasRevisions() && Objects.equals(this.revisions(), other.revisions());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetApplicationRevisionsResponse").add("ApplicationName", (Object)this.applicationName()).add("ErrorMessage", (Object)this.errorMessage()).add("Revisions", this.hasRevisions() ? this.revisions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "revisions": {
                return Optional.ofNullable(clazz.cast(this.revisions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetApplicationRevisionsResponse, T> g) {
        return obj -> g.apply((BatchGetApplicationRevisionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeDeployResponse.BuilderImpl
    implements Builder {
        private String applicationName;
        private String errorMessage;
        private List<RevisionInfo> revisions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetApplicationRevisionsResponse model) {
            super(model);
            this.applicationName(model.applicationName);
            this.errorMessage(model.errorMessage);
            this.revisions(model.revisions);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final List<RevisionInfo.Builder> getRevisions() {
            List<RevisionInfo.Builder> result = RevisionInfoListCopier.copyToBuilder(this.revisions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRevisions(Collection<RevisionInfo.BuilderImpl> revisions) {
            this.revisions = RevisionInfoListCopier.copyFromBuilder(revisions);
        }

        @Override
        public final Builder revisions(Collection<RevisionInfo> revisions) {
            this.revisions = RevisionInfoListCopier.copy(revisions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisions(RevisionInfo ... revisions) {
            this.revisions(Arrays.asList(revisions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisions(Consumer<RevisionInfo.Builder> ... revisions) {
            this.revisions(Stream.of(revisions).map(c -> (RevisionInfo)((RevisionInfo.Builder)RevisionInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetApplicationRevisionsResponse build() {
            return new BatchGetApplicationRevisionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeDeployResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetApplicationRevisionsResponse> {
        public Builder applicationName(String var1);

        public Builder errorMessage(String var1);

        public Builder revisions(Collection<RevisionInfo> var1);

        public Builder revisions(RevisionInfo ... var1);

        public Builder revisions(Consumer<RevisionInfo.Builder> ... var1);
    }
}

