/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codedeploy.CodeDeployAsyncClient;
import software.amazon.awssdk.services.codedeploy.CodeDeployAsyncClientBuilder;
import software.amazon.awssdk.services.codedeploy.CodeDeployServiceClientConfiguration;
import software.amazon.awssdk.services.codedeploy.DefaultCodeDeployAsyncClient;
import software.amazon.awssdk.services.codedeploy.DefaultCodeDeployBaseClientBuilder;
import software.amazon.awssdk.services.codedeploy.endpoints.CodeDeployEndpointProvider;

@SdkInternalApi
final class DefaultCodeDeployAsyncClientBuilder
extends DefaultCodeDeployBaseClientBuilder<CodeDeployAsyncClientBuilder, CodeDeployAsyncClient>
implements CodeDeployAsyncClientBuilder {
    DefaultCodeDeployAsyncClientBuilder() {
    }

    @Override
    public DefaultCodeDeployAsyncClientBuilder endpointProvider(CodeDeployEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CodeDeployAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultCodeDeployAsyncClientBuilder.validateClientOptions(clientConfiguration);
        CodeDeployServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultCodeDeployAsyncClient client = new DefaultCodeDeployAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private CodeDeployServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return CodeDeployServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

