/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codedeploy.model.CloudFormationTarget;
import software.amazon.awssdk.services.codedeploy.model.DeploymentTargetType;
import software.amazon.awssdk.services.codedeploy.model.ECSTarget;
import software.amazon.awssdk.services.codedeploy.model.InstanceTarget;
import software.amazon.awssdk.services.codedeploy.model.LambdaTarget;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeploymentTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeploymentTarget> {
    private static final SdkField<String> DEPLOYMENT_TARGET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentTargetType").getter(DeploymentTarget.getter(DeploymentTarget::deploymentTargetTypeAsString)).setter(DeploymentTarget.setter(Builder::deploymentTargetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentTargetType").build()}).build();
    private static final SdkField<InstanceTarget> INSTANCE_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("instanceTarget").getter(DeploymentTarget.getter(DeploymentTarget::instanceTarget)).setter(DeploymentTarget.setter(Builder::instanceTarget)).constructor(InstanceTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceTarget").build()}).build();
    private static final SdkField<LambdaTarget> LAMBDA_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lambdaTarget").getter(DeploymentTarget.getter(DeploymentTarget::lambdaTarget)).setter(DeploymentTarget.setter(Builder::lambdaTarget)).constructor(LambdaTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaTarget").build()}).build();
    private static final SdkField<ECSTarget> ECS_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ecsTarget").getter(DeploymentTarget.getter(DeploymentTarget::ecsTarget)).setter(DeploymentTarget.setter(Builder::ecsTarget)).constructor(ECSTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecsTarget").build()}).build();
    private static final SdkField<CloudFormationTarget> CLOUD_FORMATION_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cloudFormationTarget").getter(DeploymentTarget.getter(DeploymentTarget::cloudFormationTarget)).setter(DeploymentTarget.setter(Builder::cloudFormationTarget)).constructor(CloudFormationTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudFormationTarget").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_TARGET_TYPE_FIELD, INSTANCE_TARGET_FIELD, LAMBDA_TARGET_FIELD, ECS_TARGET_FIELD, CLOUD_FORMATION_TARGET_FIELD));
    private static final long serialVersionUID = 1L;
    private final String deploymentTargetType;
    private final InstanceTarget instanceTarget;
    private final LambdaTarget lambdaTarget;
    private final ECSTarget ecsTarget;
    private final CloudFormationTarget cloudFormationTarget;

    private DeploymentTarget(BuilderImpl builder) {
        this.deploymentTargetType = builder.deploymentTargetType;
        this.instanceTarget = builder.instanceTarget;
        this.lambdaTarget = builder.lambdaTarget;
        this.ecsTarget = builder.ecsTarget;
        this.cloudFormationTarget = builder.cloudFormationTarget;
    }

    public final DeploymentTargetType deploymentTargetType() {
        return DeploymentTargetType.fromValue(this.deploymentTargetType);
    }

    public final String deploymentTargetTypeAsString() {
        return this.deploymentTargetType;
    }

    public final InstanceTarget instanceTarget() {
        return this.instanceTarget;
    }

    public final LambdaTarget lambdaTarget() {
        return this.lambdaTarget;
    }

    public final ECSTarget ecsTarget() {
        return this.ecsTarget;
    }

    public final CloudFormationTarget cloudFormationTarget() {
        return this.cloudFormationTarget;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentTargetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTarget());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaTarget());
        hashCode = 31 * hashCode + Objects.hashCode(this.ecsTarget());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudFormationTarget());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentTarget)) {
            return false;
        }
        DeploymentTarget other = (DeploymentTarget)obj;
        return Objects.equals(this.deploymentTargetTypeAsString(), other.deploymentTargetTypeAsString()) && Objects.equals(this.instanceTarget(), other.instanceTarget()) && Objects.equals(this.lambdaTarget(), other.lambdaTarget()) && Objects.equals(this.ecsTarget(), other.ecsTarget()) && Objects.equals(this.cloudFormationTarget(), other.cloudFormationTarget());
    }

    public final String toString() {
        return ToString.builder((String)"DeploymentTarget").add("DeploymentTargetType", (Object)this.deploymentTargetTypeAsString()).add("InstanceTarget", (Object)this.instanceTarget()).add("LambdaTarget", (Object)this.lambdaTarget()).add("EcsTarget", (Object)this.ecsTarget()).add("CloudFormationTarget", (Object)this.cloudFormationTarget()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentTargetType": {
                return Optional.ofNullable(clazz.cast(this.deploymentTargetTypeAsString()));
            }
            case "instanceTarget": {
                return Optional.ofNullable(clazz.cast(this.instanceTarget()));
            }
            case "lambdaTarget": {
                return Optional.ofNullable(clazz.cast(this.lambdaTarget()));
            }
            case "ecsTarget": {
                return Optional.ofNullable(clazz.cast(this.ecsTarget()));
            }
            case "cloudFormationTarget": {
                return Optional.ofNullable(clazz.cast(this.cloudFormationTarget()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentTarget, T> g) {
        return obj -> g.apply((DeploymentTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deploymentTargetType;
        private InstanceTarget instanceTarget;
        private LambdaTarget lambdaTarget;
        private ECSTarget ecsTarget;
        private CloudFormationTarget cloudFormationTarget;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentTarget model) {
            this.deploymentTargetType(model.deploymentTargetType);
            this.instanceTarget(model.instanceTarget);
            this.lambdaTarget(model.lambdaTarget);
            this.ecsTarget(model.ecsTarget);
            this.cloudFormationTarget(model.cloudFormationTarget);
        }

        public final String getDeploymentTargetType() {
            return this.deploymentTargetType;
        }

        public final void setDeploymentTargetType(String deploymentTargetType) {
            this.deploymentTargetType = deploymentTargetType;
        }

        @Override
        @Transient
        public final Builder deploymentTargetType(String deploymentTargetType) {
            this.deploymentTargetType = deploymentTargetType;
            return this;
        }

        @Override
        @Transient
        public final Builder deploymentTargetType(DeploymentTargetType deploymentTargetType) {
            this.deploymentTargetType(deploymentTargetType == null ? null : deploymentTargetType.toString());
            return this;
        }

        public final InstanceTarget.Builder getInstanceTarget() {
            return this.instanceTarget != null ? this.instanceTarget.toBuilder() : null;
        }

        public final void setInstanceTarget(InstanceTarget.BuilderImpl instanceTarget) {
            this.instanceTarget = instanceTarget != null ? instanceTarget.build() : null;
        }

        @Override
        @Transient
        public final Builder instanceTarget(InstanceTarget instanceTarget) {
            this.instanceTarget = instanceTarget;
            return this;
        }

        public final LambdaTarget.Builder getLambdaTarget() {
            return this.lambdaTarget != null ? this.lambdaTarget.toBuilder() : null;
        }

        public final void setLambdaTarget(LambdaTarget.BuilderImpl lambdaTarget) {
            this.lambdaTarget = lambdaTarget != null ? lambdaTarget.build() : null;
        }

        @Override
        @Transient
        public final Builder lambdaTarget(LambdaTarget lambdaTarget) {
            this.lambdaTarget = lambdaTarget;
            return this;
        }

        public final ECSTarget.Builder getEcsTarget() {
            return this.ecsTarget != null ? this.ecsTarget.toBuilder() : null;
        }

        public final void setEcsTarget(ECSTarget.BuilderImpl ecsTarget) {
            this.ecsTarget = ecsTarget != null ? ecsTarget.build() : null;
        }

        @Override
        @Transient
        public final Builder ecsTarget(ECSTarget ecsTarget) {
            this.ecsTarget = ecsTarget;
            return this;
        }

        public final CloudFormationTarget.Builder getCloudFormationTarget() {
            return this.cloudFormationTarget != null ? this.cloudFormationTarget.toBuilder() : null;
        }

        public final void setCloudFormationTarget(CloudFormationTarget.BuilderImpl cloudFormationTarget) {
            this.cloudFormationTarget = cloudFormationTarget != null ? cloudFormationTarget.build() : null;
        }

        @Override
        @Transient
        public final Builder cloudFormationTarget(CloudFormationTarget cloudFormationTarget) {
            this.cloudFormationTarget = cloudFormationTarget;
            return this;
        }

        public DeploymentTarget build() {
            return new DeploymentTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeploymentTarget> {
        public Builder deploymentTargetType(String var1);

        public Builder deploymentTargetType(DeploymentTargetType var1);

        public Builder instanceTarget(InstanceTarget var1);

        default public Builder instanceTarget(Consumer<InstanceTarget.Builder> instanceTarget) {
            return this.instanceTarget((InstanceTarget)((InstanceTarget.Builder)InstanceTarget.builder().applyMutation(instanceTarget)).build());
        }

        public Builder lambdaTarget(LambdaTarget var1);

        default public Builder lambdaTarget(Consumer<LambdaTarget.Builder> lambdaTarget) {
            return this.lambdaTarget((LambdaTarget)((LambdaTarget.Builder)LambdaTarget.builder().applyMutation(lambdaTarget)).build());
        }

        public Builder ecsTarget(ECSTarget var1);

        default public Builder ecsTarget(Consumer<ECSTarget.Builder> ecsTarget) {
            return this.ecsTarget((ECSTarget)((ECSTarget.Builder)ECSTarget.builder().applyMutation(ecsTarget)).build());
        }

        public Builder cloudFormationTarget(CloudFormationTarget var1);

        default public Builder cloudFormationTarget(Consumer<CloudFormationTarget.Builder> cloudFormationTarget) {
            return this.cloudFormationTarget((CloudFormationTarget)((CloudFormationTarget.Builder)CloudFormationTarget.builder().applyMutation(cloudFormationTarget)).build());
        }
    }
}

