/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codedeploy.model.ListenerArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrafficRoute
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrafficRoute> {
    private static final SdkField<List<String>> LISTENER_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("listenerArns").getter(TrafficRoute.getter(TrafficRoute::listenerArns)).setter(TrafficRoute.setter(Builder::listenerArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listenerArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LISTENER_ARNS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> listenerArns;

    private TrafficRoute(BuilderImpl builder) {
        this.listenerArns = builder.listenerArns;
    }

    public boolean hasListenerArns() {
        return this.listenerArns != null && !(this.listenerArns instanceof SdkAutoConstructList);
    }

    public List<String> listenerArns() {
        return this.listenerArns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.listenerArns());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrafficRoute)) {
            return false;
        }
        TrafficRoute other = (TrafficRoute)obj;
        return Objects.equals(this.listenerArns(), other.listenerArns());
    }

    public String toString() {
        return ToString.builder((String)"TrafficRoute").add("ListenerArns", this.listenerArns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "listenerArns": {
                return Optional.ofNullable(clazz.cast(this.listenerArns()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrafficRoute, T> g) {
        return obj -> g.apply((TrafficRoute)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> listenerArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TrafficRoute model) {
            this.listenerArns(model.listenerArns);
        }

        public final Collection<String> getListenerArns() {
            return this.listenerArns;
        }

        @Override
        public final Builder listenerArns(Collection<String> listenerArns) {
            this.listenerArns = ListenerArnListCopier.copy(listenerArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listenerArns(String ... listenerArns) {
            this.listenerArns(Arrays.asList(listenerArns));
            return this;
        }

        public final void setListenerArns(Collection<String> listenerArns) {
            this.listenerArns = ListenerArnListCopier.copy(listenerArns);
        }

        public TrafficRoute build() {
            return new TrafficRoute(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrafficRoute> {
        public Builder listenerArns(Collection<String> var1);

        public Builder listenerArns(String ... var1);
    }
}

