/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codedeploy.model.TargetGroupInfo;
import software.amazon.awssdk.services.codedeploy.model.TargetLabel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ECSTaskSet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ECSTaskSet> {
    private static final SdkField<String> IDENTIFER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identifer").getter(ECSTaskSet.getter(ECSTaskSet::identifer)).setter(ECSTaskSet.setter(Builder::identifer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifer").build()}).build();
    private static final SdkField<Long> DESIRED_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("desiredCount").getter(ECSTaskSet.getter(ECSTaskSet::desiredCount)).setter(ECSTaskSet.setter(Builder::desiredCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredCount").build()}).build();
    private static final SdkField<Long> PENDING_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("pendingCount").getter(ECSTaskSet.getter(ECSTaskSet::pendingCount)).setter(ECSTaskSet.setter(Builder::pendingCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingCount").build()}).build();
    private static final SdkField<Long> RUNNING_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("runningCount").getter(ECSTaskSet.getter(ECSTaskSet::runningCount)).setter(ECSTaskSet.setter(Builder::runningCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runningCount").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ECSTaskSet.getter(ECSTaskSet::status)).setter(ECSTaskSet.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Double> TRAFFIC_WEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("trafficWeight").getter(ECSTaskSet.getter(ECSTaskSet::trafficWeight)).setter(ECSTaskSet.setter(Builder::trafficWeight)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trafficWeight").build()}).build();
    private static final SdkField<TargetGroupInfo> TARGET_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("targetGroup").getter(ECSTaskSet.getter(ECSTaskSet::targetGroup)).setter(ECSTaskSet.setter(Builder::targetGroup)).constructor(TargetGroupInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetGroup").build()}).build();
    private static final SdkField<String> TASK_SET_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskSetLabel").getter(ECSTaskSet.getter(ECSTaskSet::taskSetLabelAsString)).setter(ECSTaskSet.setter(Builder::taskSetLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskSetLabel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFER_FIELD, DESIRED_COUNT_FIELD, PENDING_COUNT_FIELD, RUNNING_COUNT_FIELD, STATUS_FIELD, TRAFFIC_WEIGHT_FIELD, TARGET_GROUP_FIELD, TASK_SET_LABEL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String identifer;
    private final Long desiredCount;
    private final Long pendingCount;
    private final Long runningCount;
    private final String status;
    private final Double trafficWeight;
    private final TargetGroupInfo targetGroup;
    private final String taskSetLabel;

    private ECSTaskSet(BuilderImpl builder) {
        this.identifer = builder.identifer;
        this.desiredCount = builder.desiredCount;
        this.pendingCount = builder.pendingCount;
        this.runningCount = builder.runningCount;
        this.status = builder.status;
        this.trafficWeight = builder.trafficWeight;
        this.targetGroup = builder.targetGroup;
        this.taskSetLabel = builder.taskSetLabel;
    }

    public String identifer() {
        return this.identifer;
    }

    public Long desiredCount() {
        return this.desiredCount;
    }

    public Long pendingCount() {
        return this.pendingCount;
    }

    public Long runningCount() {
        return this.runningCount;
    }

    public String status() {
        return this.status;
    }

    public Double trafficWeight() {
        return this.trafficWeight;
    }

    public TargetGroupInfo targetGroup() {
        return this.targetGroup;
    }

    public TargetLabel taskSetLabel() {
        return TargetLabel.fromValue(this.taskSetLabel);
    }

    public String taskSetLabelAsString() {
        return this.taskSetLabel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identifer());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.runningCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficWeight());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskSetLabelAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ECSTaskSet)) {
            return false;
        }
        ECSTaskSet other = (ECSTaskSet)obj;
        return Objects.equals(this.identifer(), other.identifer()) && Objects.equals(this.desiredCount(), other.desiredCount()) && Objects.equals(this.pendingCount(), other.pendingCount()) && Objects.equals(this.runningCount(), other.runningCount()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.trafficWeight(), other.trafficWeight()) && Objects.equals(this.targetGroup(), other.targetGroup()) && Objects.equals(this.taskSetLabelAsString(), other.taskSetLabelAsString());
    }

    public String toString() {
        return ToString.builder((String)"ECSTaskSet").add("Identifer", (Object)this.identifer()).add("DesiredCount", (Object)this.desiredCount()).add("PendingCount", (Object)this.pendingCount()).add("RunningCount", (Object)this.runningCount()).add("Status", (Object)this.status()).add("TrafficWeight", (Object)this.trafficWeight()).add("TargetGroup", (Object)this.targetGroup()).add("TaskSetLabel", (Object)this.taskSetLabelAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "identifer": {
                return Optional.ofNullable(clazz.cast(this.identifer()));
            }
            case "desiredCount": {
                return Optional.ofNullable(clazz.cast(this.desiredCount()));
            }
            case "pendingCount": {
                return Optional.ofNullable(clazz.cast(this.pendingCount()));
            }
            case "runningCount": {
                return Optional.ofNullable(clazz.cast(this.runningCount()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "trafficWeight": {
                return Optional.ofNullable(clazz.cast(this.trafficWeight()));
            }
            case "targetGroup": {
                return Optional.ofNullable(clazz.cast(this.targetGroup()));
            }
            case "taskSetLabel": {
                return Optional.ofNullable(clazz.cast(this.taskSetLabelAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ECSTaskSet, T> g) {
        return obj -> g.apply((ECSTaskSet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String identifer;
        private Long desiredCount;
        private Long pendingCount;
        private Long runningCount;
        private String status;
        private Double trafficWeight;
        private TargetGroupInfo targetGroup;
        private String taskSetLabel;

        private BuilderImpl() {
        }

        private BuilderImpl(ECSTaskSet model) {
            this.identifer(model.identifer);
            this.desiredCount(model.desiredCount);
            this.pendingCount(model.pendingCount);
            this.runningCount(model.runningCount);
            this.status(model.status);
            this.trafficWeight(model.trafficWeight);
            this.targetGroup(model.targetGroup);
            this.taskSetLabel(model.taskSetLabel);
        }

        public final String getIdentifer() {
            return this.identifer;
        }

        @Override
        public final Builder identifer(String identifer) {
            this.identifer = identifer;
            return this;
        }

        public final void setIdentifer(String identifer) {
            this.identifer = identifer;
        }

        public final Long getDesiredCount() {
            return this.desiredCount;
        }

        @Override
        public final Builder desiredCount(Long desiredCount) {
            this.desiredCount = desiredCount;
            return this;
        }

        public final void setDesiredCount(Long desiredCount) {
            this.desiredCount = desiredCount;
        }

        public final Long getPendingCount() {
            return this.pendingCount;
        }

        @Override
        public final Builder pendingCount(Long pendingCount) {
            this.pendingCount = pendingCount;
            return this;
        }

        public final void setPendingCount(Long pendingCount) {
            this.pendingCount = pendingCount;
        }

        public final Long getRunningCount() {
            return this.runningCount;
        }

        @Override
        public final Builder runningCount(Long runningCount) {
            this.runningCount = runningCount;
            return this;
        }

        public final void setRunningCount(Long runningCount) {
            this.runningCount = runningCount;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Double getTrafficWeight() {
            return this.trafficWeight;
        }

        @Override
        public final Builder trafficWeight(Double trafficWeight) {
            this.trafficWeight = trafficWeight;
            return this;
        }

        public final void setTrafficWeight(Double trafficWeight) {
            this.trafficWeight = trafficWeight;
        }

        public final TargetGroupInfo.Builder getTargetGroup() {
            return this.targetGroup != null ? this.targetGroup.toBuilder() : null;
        }

        @Override
        public final Builder targetGroup(TargetGroupInfo targetGroup) {
            this.targetGroup = targetGroup;
            return this;
        }

        public final void setTargetGroup(TargetGroupInfo.BuilderImpl targetGroup) {
            this.targetGroup = targetGroup != null ? targetGroup.build() : null;
        }

        public final String getTaskSetLabel() {
            return this.taskSetLabel;
        }

        @Override
        public final Builder taskSetLabel(String taskSetLabel) {
            this.taskSetLabel = taskSetLabel;
            return this;
        }

        @Override
        public final Builder taskSetLabel(TargetLabel taskSetLabel) {
            this.taskSetLabel(taskSetLabel == null ? null : taskSetLabel.toString());
            return this;
        }

        public final void setTaskSetLabel(String taskSetLabel) {
            this.taskSetLabel = taskSetLabel;
        }

        public ECSTaskSet build() {
            return new ECSTaskSet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ECSTaskSet> {
        public Builder identifer(String var1);

        public Builder desiredCount(Long var1);

        public Builder pendingCount(Long var1);

        public Builder runningCount(Long var1);

        public Builder status(String var1);

        public Builder trafficWeight(Double var1);

        public Builder targetGroup(TargetGroupInfo var1);

        default public Builder targetGroup(Consumer<TargetGroupInfo.Builder> targetGroup) {
            return this.targetGroup((TargetGroupInfo)((TargetGroupInfo.Builder)TargetGroupInfo.builder().applyMutation(targetGroup)).build());
        }

        public Builder taskSetLabel(String var1);

        public Builder taskSetLabel(TargetLabel var1);
    }
}

