/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about minimum healthy instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MinimumHealthyHosts implements SdkPojo, Serializable,
        ToCopyableBuilder<MinimumHealthyHosts.Builder, MinimumHealthyHosts> {
    private static final SdkField<Integer> VALUE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(MinimumHealthyHosts::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MinimumHealthyHosts::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer value;

    private final String type;

    private MinimumHealthyHosts(BuilderImpl builder) {
        this.value = builder.value;
        this.type = builder.type;
    }

    /**
     * <p>
     * The minimum healthy instance value.
     * </p>
     * 
     * @return The minimum healthy instance value.
     */
    public Integer value() {
        return value;
    }

    /**
     * <p>
     * The minimum healthy instance type:
     * </p>
     * <ul>
     * <li>
     * <p>
     * HOST_COUNT: The minimum number of healthy instance as an absolute value.
     * </p>
     * </li>
     * <li>
     * <p>
     * FLEET_PERCENT: The minimum number of healthy instance as a percentage of the total number of instance in the
     * deployment.
     * </p>
     * </li>
     * </ul>
     * <p>
     * In an example of nine instance, if a HOST_COUNT of six is specified, deploy to up to three instances at a time.
     * The deployment is successful if six or more instances are deployed to successfully. Otherwise, the deployment
     * fails. If a FLEET_PERCENT of 40 is specified, deploy to up to five instance at a time. The deployment is
     * successful if four or more instance are deployed to successfully. Otherwise, the deployment fails.
     * </p>
     * <note>
     * <p>
     * In a call to the <code>GetDeploymentConfig</code>, CodeDeployDefault.OneAtATime returns a minimum healthy
     * instance type of MOST_CONCURRENCY and a value of 1. This means a deployment to only one instance at a time. (You
     * cannot set the type to MOST_CONCURRENCY, only to HOST_COUNT or FLEET_PERCENT.) In addition, with
     * CodeDeployDefault.OneAtATime, AWS CodeDeploy attempts to ensure that all instances but one are kept in a healthy
     * state during the deployment. Although this allows one instance at a time to be taken offline for a new
     * deployment, it also means that if the deployment to the last instance fails, the overall deployment is still
     * successful.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-health.html">AWS CodeDeploy Instance
     * Health</a> in the <i>AWS CodeDeploy User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MinimumHealthyHostsType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The minimum healthy instance type:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         HOST_COUNT: The minimum number of healthy instance as an absolute value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FLEET_PERCENT: The minimum number of healthy instance as a percentage of the total number of instance in
     *         the deployment.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         In an example of nine instance, if a HOST_COUNT of six is specified, deploy to up to three instances at a
     *         time. The deployment is successful if six or more instances are deployed to successfully. Otherwise, the
     *         deployment fails. If a FLEET_PERCENT of 40 is specified, deploy to up to five instance at a time. The
     *         deployment is successful if four or more instance are deployed to successfully. Otherwise, the deployment
     *         fails.
     *         </p>
     *         <note>
     *         <p>
     *         In a call to the <code>GetDeploymentConfig</code>, CodeDeployDefault.OneAtATime returns a minimum healthy
     *         instance type of MOST_CONCURRENCY and a value of 1. This means a deployment to only one instance at a
     *         time. (You cannot set the type to MOST_CONCURRENCY, only to HOST_COUNT or FLEET_PERCENT.) In addition,
     *         with CodeDeployDefault.OneAtATime, AWS CodeDeploy attempts to ensure that all instances but one are kept
     *         in a healthy state during the deployment. Although this allows one instance at a time to be taken offline
     *         for a new deployment, it also means that if the deployment to the last instance fails, the overall
     *         deployment is still successful.
     *         </p>
     *         </note>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-health.html">AWS CodeDeploy
     *         Instance Health</a> in the <i>AWS CodeDeploy User Guide</i>.
     * @see MinimumHealthyHostsType
     */
    public MinimumHealthyHostsType type() {
        return MinimumHealthyHostsType.fromValue(type);
    }

    /**
     * <p>
     * The minimum healthy instance type:
     * </p>
     * <ul>
     * <li>
     * <p>
     * HOST_COUNT: The minimum number of healthy instance as an absolute value.
     * </p>
     * </li>
     * <li>
     * <p>
     * FLEET_PERCENT: The minimum number of healthy instance as a percentage of the total number of instance in the
     * deployment.
     * </p>
     * </li>
     * </ul>
     * <p>
     * In an example of nine instance, if a HOST_COUNT of six is specified, deploy to up to three instances at a time.
     * The deployment is successful if six or more instances are deployed to successfully. Otherwise, the deployment
     * fails. If a FLEET_PERCENT of 40 is specified, deploy to up to five instance at a time. The deployment is
     * successful if four or more instance are deployed to successfully. Otherwise, the deployment fails.
     * </p>
     * <note>
     * <p>
     * In a call to the <code>GetDeploymentConfig</code>, CodeDeployDefault.OneAtATime returns a minimum healthy
     * instance type of MOST_CONCURRENCY and a value of 1. This means a deployment to only one instance at a time. (You
     * cannot set the type to MOST_CONCURRENCY, only to HOST_COUNT or FLEET_PERCENT.) In addition, with
     * CodeDeployDefault.OneAtATime, AWS CodeDeploy attempts to ensure that all instances but one are kept in a healthy
     * state during the deployment. Although this allows one instance at a time to be taken offline for a new
     * deployment, it also means that if the deployment to the last instance fails, the overall deployment is still
     * successful.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-health.html">AWS CodeDeploy Instance
     * Health</a> in the <i>AWS CodeDeploy User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MinimumHealthyHostsType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The minimum healthy instance type:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         HOST_COUNT: The minimum number of healthy instance as an absolute value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FLEET_PERCENT: The minimum number of healthy instance as a percentage of the total number of instance in
     *         the deployment.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         In an example of nine instance, if a HOST_COUNT of six is specified, deploy to up to three instances at a
     *         time. The deployment is successful if six or more instances are deployed to successfully. Otherwise, the
     *         deployment fails. If a FLEET_PERCENT of 40 is specified, deploy to up to five instance at a time. The
     *         deployment is successful if four or more instance are deployed to successfully. Otherwise, the deployment
     *         fails.
     *         </p>
     *         <note>
     *         <p>
     *         In a call to the <code>GetDeploymentConfig</code>, CodeDeployDefault.OneAtATime returns a minimum healthy
     *         instance type of MOST_CONCURRENCY and a value of 1. This means a deployment to only one instance at a
     *         time. (You cannot set the type to MOST_CONCURRENCY, only to HOST_COUNT or FLEET_PERCENT.) In addition,
     *         with CodeDeployDefault.OneAtATime, AWS CodeDeploy attempts to ensure that all instances but one are kept
     *         in a healthy state during the deployment. Although this allows one instance at a time to be taken offline
     *         for a new deployment, it also means that if the deployment to the last instance fails, the overall
     *         deployment is still successful.
     *         </p>
     *         </note>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-health.html">AWS CodeDeploy
     *         Instance Health</a> in the <i>AWS CodeDeploy User Guide</i>.
     * @see MinimumHealthyHostsType
     */
    public String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MinimumHealthyHosts)) {
            return false;
        }
        MinimumHealthyHosts other = (MinimumHealthyHosts) obj;
        return Objects.equals(value(), other.value()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MinimumHealthyHosts").add("Value", value()).add("Type", typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MinimumHealthyHosts, T> g) {
        return obj -> g.apply((MinimumHealthyHosts) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MinimumHealthyHosts> {
        /**
         * <p>
         * The minimum healthy instance value.
         * </p>
         * 
         * @param value
         *        The minimum healthy instance value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Integer value);

        /**
         * <p>
         * The minimum healthy instance type:
         * </p>
         * <ul>
         * <li>
         * <p>
         * HOST_COUNT: The minimum number of healthy instance as an absolute value.
         * </p>
         * </li>
         * <li>
         * <p>
         * FLEET_PERCENT: The minimum number of healthy instance as a percentage of the total number of instance in the
         * deployment.
         * </p>
         * </li>
         * </ul>
         * <p>
         * In an example of nine instance, if a HOST_COUNT of six is specified, deploy to up to three instances at a
         * time. The deployment is successful if six or more instances are deployed to successfully. Otherwise, the
         * deployment fails. If a FLEET_PERCENT of 40 is specified, deploy to up to five instance at a time. The
         * deployment is successful if four or more instance are deployed to successfully. Otherwise, the deployment
         * fails.
         * </p>
         * <note>
         * <p>
         * In a call to the <code>GetDeploymentConfig</code>, CodeDeployDefault.OneAtATime returns a minimum healthy
         * instance type of MOST_CONCURRENCY and a value of 1. This means a deployment to only one instance at a time.
         * (You cannot set the type to MOST_CONCURRENCY, only to HOST_COUNT or FLEET_PERCENT.) In addition, with
         * CodeDeployDefault.OneAtATime, AWS CodeDeploy attempts to ensure that all instances but one are kept in a
         * healthy state during the deployment. Although this allows one instance at a time to be taken offline for a
         * new deployment, it also means that if the deployment to the last instance fails, the overall deployment is
         * still successful.
         * </p>
         * </note>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-health.html">AWS CodeDeploy Instance
         * Health</a> in the <i>AWS CodeDeploy User Guide</i>.
         * </p>
         * 
         * @param type
         *        The minimum healthy instance type:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        HOST_COUNT: The minimum number of healthy instance as an absolute value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FLEET_PERCENT: The minimum number of healthy instance as a percentage of the total number of instance
         *        in the deployment.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        In an example of nine instance, if a HOST_COUNT of six is specified, deploy to up to three instances
         *        at a time. The deployment is successful if six or more instances are deployed to successfully.
         *        Otherwise, the deployment fails. If a FLEET_PERCENT of 40 is specified, deploy to up to five instance
         *        at a time. The deployment is successful if four or more instance are deployed to successfully.
         *        Otherwise, the deployment fails.
         *        </p>
         *        <note>
         *        <p>
         *        In a call to the <code>GetDeploymentConfig</code>, CodeDeployDefault.OneAtATime returns a minimum
         *        healthy instance type of MOST_CONCURRENCY and a value of 1. This means a deployment to only one
         *        instance at a time. (You cannot set the type to MOST_CONCURRENCY, only to HOST_COUNT or
         *        FLEET_PERCENT.) In addition, with CodeDeployDefault.OneAtATime, AWS CodeDeploy attempts to ensure that
         *        all instances but one are kept in a healthy state during the deployment. Although this allows one
         *        instance at a time to be taken offline for a new deployment, it also means that if the deployment to
         *        the last instance fails, the overall deployment is still successful.
         *        </p>
         *        </note>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-health.html">AWS CodeDeploy
         *        Instance Health</a> in the <i>AWS CodeDeploy User Guide</i>.
         * @see MinimumHealthyHostsType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MinimumHealthyHostsType
         */
        Builder type(String type);

        /**
         * <p>
         * The minimum healthy instance type:
         * </p>
         * <ul>
         * <li>
         * <p>
         * HOST_COUNT: The minimum number of healthy instance as an absolute value.
         * </p>
         * </li>
         * <li>
         * <p>
         * FLEET_PERCENT: The minimum number of healthy instance as a percentage of the total number of instance in the
         * deployment.
         * </p>
         * </li>
         * </ul>
         * <p>
         * In an example of nine instance, if a HOST_COUNT of six is specified, deploy to up to three instances at a
         * time. The deployment is successful if six or more instances are deployed to successfully. Otherwise, the
         * deployment fails. If a FLEET_PERCENT of 40 is specified, deploy to up to five instance at a time. The
         * deployment is successful if four or more instance are deployed to successfully. Otherwise, the deployment
         * fails.
         * </p>
         * <note>
         * <p>
         * In a call to the <code>GetDeploymentConfig</code>, CodeDeployDefault.OneAtATime returns a minimum healthy
         * instance type of MOST_CONCURRENCY and a value of 1. This means a deployment to only one instance at a time.
         * (You cannot set the type to MOST_CONCURRENCY, only to HOST_COUNT or FLEET_PERCENT.) In addition, with
         * CodeDeployDefault.OneAtATime, AWS CodeDeploy attempts to ensure that all instances but one are kept in a
         * healthy state during the deployment. Although this allows one instance at a time to be taken offline for a
         * new deployment, it also means that if the deployment to the last instance fails, the overall deployment is
         * still successful.
         * </p>
         * </note>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-health.html">AWS CodeDeploy Instance
         * Health</a> in the <i>AWS CodeDeploy User Guide</i>.
         * </p>
         * 
         * @param type
         *        The minimum healthy instance type:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        HOST_COUNT: The minimum number of healthy instance as an absolute value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FLEET_PERCENT: The minimum number of healthy instance as a percentage of the total number of instance
         *        in the deployment.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        In an example of nine instance, if a HOST_COUNT of six is specified, deploy to up to three instances
         *        at a time. The deployment is successful if six or more instances are deployed to successfully.
         *        Otherwise, the deployment fails. If a FLEET_PERCENT of 40 is specified, deploy to up to five instance
         *        at a time. The deployment is successful if four or more instance are deployed to successfully.
         *        Otherwise, the deployment fails.
         *        </p>
         *        <note>
         *        <p>
         *        In a call to the <code>GetDeploymentConfig</code>, CodeDeployDefault.OneAtATime returns a minimum
         *        healthy instance type of MOST_CONCURRENCY and a value of 1. This means a deployment to only one
         *        instance at a time. (You cannot set the type to MOST_CONCURRENCY, only to HOST_COUNT or
         *        FLEET_PERCENT.) In addition, with CodeDeployDefault.OneAtATime, AWS CodeDeploy attempts to ensure that
         *        all instances but one are kept in a healthy state during the deployment. Although this allows one
         *        instance at a time to be taken offline for a new deployment, it also means that if the deployment to
         *        the last instance fails, the overall deployment is still successful.
         *        </p>
         *        </note>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-health.html">AWS CodeDeploy
         *        Instance Health</a> in the <i>AWS CodeDeploy User Guide</i>.
         * @see MinimumHealthyHostsType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MinimumHealthyHostsType
         */
        Builder type(MinimumHealthyHostsType type);
    }

    static final class BuilderImpl implements Builder {
        private Integer value;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(MinimumHealthyHosts model) {
            value(model.value);
            type(model.type);
        }

        public final Integer getValue() {
            return value;
        }

        @Override
        public final Builder value(Integer value) {
            this.value = value;
            return this;
        }

        public final void setValue(Integer value) {
            this.value = value;
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(MinimumHealthyHostsType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public MinimumHealthyHosts build() {
            return new MinimumHealthyHosts(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
