/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codedeploy.model.TriggerConfig;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TriggerConfigMarshaller {
    private static final MarshallingInfo<String> TRIGGERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("triggerName").isBinary(false).build();
    private static final MarshallingInfo<String> TRIGGERTARGETARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("triggerTargetArn").isBinary(false).build();
    private static final MarshallingInfo<List> TRIGGEREVENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("triggerEvents").isBinary(false).build();
    private static final TriggerConfigMarshaller INSTANCE = new TriggerConfigMarshaller();

    private TriggerConfigMarshaller() {
    }

    public static TriggerConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TriggerConfig triggerConfig, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)triggerConfig, (String)"triggerConfig");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)triggerConfig.triggerName(), TRIGGERNAME_BINDING);
            protocolMarshaller.marshall((Object)triggerConfig.triggerTargetArn(), TRIGGERTARGETARN_BINDING);
            protocolMarshaller.marshall(triggerConfig.triggerEventsStrings(), TRIGGEREVENTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

