/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codedeploy.model.DeploymentStyle;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DeploymentStyleMarshaller {
    private static final MarshallingInfo<String> DEPLOYMENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deploymentType").isBinary(false).build();
    private static final MarshallingInfo<String> DEPLOYMENTOPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deploymentOption").isBinary(false).build();
    private static final DeploymentStyleMarshaller INSTANCE = new DeploymentStyleMarshaller();

    private DeploymentStyleMarshaller() {
    }

    public static DeploymentStyleMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DeploymentStyle deploymentStyle, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)deploymentStyle, (String)"deploymentStyle");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)deploymentStyle.deploymentTypeString(), DEPLOYMENTTYPE_BINDING);
            protocolMarshaller.marshall((Object)deploymentStyle.deploymentOptionString(), DEPLOYMENTOPTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

