/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.codedeploy.CodeDeployClient;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationsResponse;

public class ListApplicationsIterable
implements SdkIterable<ListApplicationsResponse> {
    private final CodeDeployClient client;
    private final ListApplicationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListApplicationsIterable(CodeDeployClient client, ListApplicationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListApplicationsResponseFetcher();
    }

    public Iterator<ListApplicationsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<String> applications() {
        Function<ListApplicationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.applications() != null) {
                return response.applications().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListApplicationsIterable resume(ListApplicationsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListApplicationsIterable(this.client, (ListApplicationsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListApplicationsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListApplicationsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListApplicationsResponseFetcher
    implements SyncPageFetcher<ListApplicationsResponse> {
        private ListApplicationsResponseFetcher() {
        }

        public boolean hasNextPage(ListApplicationsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListApplicationsResponse nextPage(ListApplicationsResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationsIterable.this.client.listApplications(ListApplicationsIterable.this.firstRequest);
            }
            return ListApplicationsIterable.this.client.listApplications((ListApplicationsRequest)((Object)ListApplicationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

