/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codedeploy.model.AlarmConfiguration;

@SdkInternalApi
public class AlarmConfigurationMarshaller {
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("enabled").build();
    private static final MarshallingInfo<Boolean> IGNOREPOLLALARMFAILURE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ignorePollAlarmFailure").build();
    private static final MarshallingInfo<List> ALARMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("alarms").build();
    private static final AlarmConfigurationMarshaller INSTANCE = new AlarmConfigurationMarshaller();

    public static AlarmConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AlarmConfiguration alarmConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (alarmConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)alarmConfiguration.enabled(), ENABLED_BINDING);
            protocolMarshaller.marshall((Object)alarmConfiguration.ignorePollAlarmFailure(), IGNOREPOLLALARMFAILURE_BINDING);
            protocolMarshaller.marshall(alarmConfiguration.alarms(), ALARMS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

