/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.codedeploy.CodeDeployClient;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsResponse;

public final class ListDeploymentGroupsPaginator
implements SdkIterable<ListDeploymentGroupsResponse> {
    private final CodeDeployClient client;
    private final ListDeploymentGroupsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListDeploymentGroupsPaginator(CodeDeployClient client, ListDeploymentGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDeploymentGroupsResponseFetcher();
    }

    public Iterator<ListDeploymentGroupsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<String> deploymentGroups() {
        Function<ListDeploymentGroupsResponse, Iterator> getIterator = response -> response != null ? response.deploymentGroups().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListDeploymentGroupsResponseFetcher
    implements NextPageFetcher<ListDeploymentGroupsResponse> {
        private ListDeploymentGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListDeploymentGroupsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListDeploymentGroupsResponse nextPage(ListDeploymentGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListDeploymentGroupsPaginator.this.client.listDeploymentGroups(ListDeploymentGroupsPaginator.this.firstRequest);
            }
            return ListDeploymentGroupsPaginator.this.client.listDeploymentGroups((ListDeploymentGroupsRequest)((Object)ListDeploymentGroupsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

