/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.model.AutoScalingGroupNameListCopier;
import software.amazon.awssdk.services.codedeploy.model.EC2TagFilter;
import software.amazon.awssdk.services.codedeploy.model.EC2TagFilterListCopier;
import software.amazon.awssdk.services.codedeploy.model.EC2TagSet;
import software.amazon.awssdk.services.codedeploy.transform.TargetInstancesMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TargetInstances
implements StructuredPojo,
ToCopyableBuilder<Builder, TargetInstances> {
    private final List<EC2TagFilter> tagFilters;
    private final List<String> autoScalingGroups;
    private final EC2TagSet ec2TagSet;

    private TargetInstances(BuilderImpl builder) {
        this.tagFilters = builder.tagFilters;
        this.autoScalingGroups = builder.autoScalingGroups;
        this.ec2TagSet = builder.ec2TagSet;
    }

    public List<EC2TagFilter> tagFilters() {
        return this.tagFilters;
    }

    public List<String> autoScalingGroups() {
        return this.autoScalingGroups;
    }

    public EC2TagSet ec2TagSet() {
        return this.ec2TagSet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tagFilters());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2TagSet());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetInstances)) {
            return false;
        }
        TargetInstances other = (TargetInstances)obj;
        return Objects.equals(this.tagFilters(), other.tagFilters()) && Objects.equals(this.autoScalingGroups(), other.autoScalingGroups()) && Objects.equals(this.ec2TagSet(), other.ec2TagSet());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.tagFilters() != null) {
            sb.append("TagFilters: ").append(this.tagFilters()).append(",");
        }
        if (this.autoScalingGroups() != null) {
            sb.append("AutoScalingGroups: ").append(this.autoScalingGroups()).append(",");
        }
        if (this.ec2TagSet() != null) {
            sb.append("Ec2TagSet: ").append(this.ec2TagSet()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tagFilters": {
                return Optional.of(clazz.cast(this.tagFilters()));
            }
            case "autoScalingGroups": {
                return Optional.of(clazz.cast(this.autoScalingGroups()));
            }
            case "ec2TagSet": {
                return Optional.of(clazz.cast(this.ec2TagSet()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TargetInstancesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<EC2TagFilter> tagFilters;
        private List<String> autoScalingGroups;
        private EC2TagSet ec2TagSet;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetInstances model) {
            this.tagFilters(model.tagFilters);
            this.autoScalingGroups(model.autoScalingGroups);
            this.ec2TagSet(model.ec2TagSet);
        }

        public final Collection<EC2TagFilter.Builder> getTagFilters() {
            return this.tagFilters != null ? (Collection)this.tagFilters.stream().map(EC2TagFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagFilters(Collection<EC2TagFilter> tagFilters) {
            this.tagFilters = EC2TagFilterListCopier.copy(tagFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagFilters(EC2TagFilter ... tagFilters) {
            this.tagFilters(Arrays.asList(tagFilters));
            return this;
        }

        public final void setTagFilters(Collection<EC2TagFilter.BuilderImpl> tagFilters) {
            this.tagFilters = EC2TagFilterListCopier.copyFromBuilder(tagFilters);
        }

        public final Collection<String> getAutoScalingGroups() {
            return this.autoScalingGroups;
        }

        @Override
        public final Builder autoScalingGroups(Collection<String> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupNameListCopier.copy(autoScalingGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingGroups(String ... autoScalingGroups) {
            this.autoScalingGroups(Arrays.asList(autoScalingGroups));
            return this;
        }

        public final void setAutoScalingGroups(Collection<String> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupNameListCopier.copy(autoScalingGroups);
        }

        public final EC2TagSet.Builder getEc2TagSet() {
            return this.ec2TagSet != null ? this.ec2TagSet.toBuilder() : null;
        }

        @Override
        public final Builder ec2TagSet(EC2TagSet ec2TagSet) {
            this.ec2TagSet = ec2TagSet;
            return this;
        }

        public final void setEc2TagSet(EC2TagSet.BuilderImpl ec2TagSet) {
            this.ec2TagSet = ec2TagSet != null ? ec2TagSet.build() : null;
        }

        public TargetInstances build() {
            return new TargetInstances(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TargetInstances> {
        public Builder tagFilters(Collection<EC2TagFilter> var1);

        public Builder tagFilters(EC2TagFilter ... var1);

        public Builder autoScalingGroups(Collection<String> var1);

        public Builder autoScalingGroups(String ... var1);

        public Builder ec2TagSet(EC2TagSet var1);

        default public Builder ec2TagSet(Consumer<EC2TagSet.Builder> ec2TagSet) {
            return this.ec2TagSet((EC2TagSet)((EC2TagSet.Builder)EC2TagSet.builder().apply(ec2TagSet)).build());
        }
    }
}

