/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployResponse;
import software.amazon.awssdk.services.codedeploy.model.DeploymentInfo;
import software.amazon.awssdk.services.codedeploy.model.DeploymentsInfoListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchGetDeploymentsResponse
extends CodeDeployResponse
implements ToCopyableBuilder<Builder, BatchGetDeploymentsResponse> {
    private final List<DeploymentInfo> deploymentsInfo;

    private BatchGetDeploymentsResponse(BuilderImpl builder) {
        super(builder);
        this.deploymentsInfo = builder.deploymentsInfo;
    }

    public List<DeploymentInfo> deploymentsInfo() {
        return this.deploymentsInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentsInfo());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetDeploymentsResponse)) {
            return false;
        }
        BatchGetDeploymentsResponse other = (BatchGetDeploymentsResponse)((Object)obj);
        return Objects.equals(this.deploymentsInfo(), other.deploymentsInfo());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.deploymentsInfo() != null) {
            sb.append("DeploymentsInfo: ").append(this.deploymentsInfo()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentsInfo": {
                return Optional.of(clazz.cast(this.deploymentsInfo()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CodeDeployResponse.BuilderImpl
    implements Builder {
        private List<DeploymentInfo> deploymentsInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetDeploymentsResponse model) {
            this.deploymentsInfo(model.deploymentsInfo);
        }

        public final Collection<DeploymentInfo.Builder> getDeploymentsInfo() {
            return this.deploymentsInfo != null ? (Collection)this.deploymentsInfo.stream().map(DeploymentInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder deploymentsInfo(Collection<DeploymentInfo> deploymentsInfo) {
            this.deploymentsInfo = DeploymentsInfoListCopier.copy(deploymentsInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentsInfo(DeploymentInfo ... deploymentsInfo) {
            this.deploymentsInfo(Arrays.asList(deploymentsInfo));
            return this;
        }

        public final void setDeploymentsInfo(Collection<DeploymentInfo.BuilderImpl> deploymentsInfo) {
            this.deploymentsInfo = DeploymentsInfoListCopier.copyFromBuilder(deploymentsInfo);
        }

        @Override
        public BatchGetDeploymentsResponse build() {
            return new BatchGetDeploymentsResponse(this);
        }
    }

    public static interface Builder
    extends CodeDeployResponse.Builder,
    CopyableBuilder<Builder, BatchGetDeploymentsResponse> {
        public Builder deploymentsInfo(Collection<DeploymentInfo> var1);

        public Builder deploymentsInfo(DeploymentInfo ... var1);
    }
}

