/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codedeploy.model.S3Location;

@SdkInternalApi
public class S3LocationMarshaller {
    private static final MarshallingInfo<String> BUCKET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bucket").build();
    private static final MarshallingInfo<String> KEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("key").build();
    private static final MarshallingInfo<String> BUNDLETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bundleType").build();
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("version").build();
    private static final MarshallingInfo<String> ETAG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eTag").build();
    private static final S3LocationMarshaller INSTANCE = new S3LocationMarshaller();

    public static S3LocationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(S3Location s3Location, ProtocolMarshaller protocolMarshaller) {
        if (s3Location == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3Location.bucket(), BUCKET_BINDING);
            protocolMarshaller.marshall((Object)s3Location.key(), KEY_BINDING);
            protocolMarshaller.marshall((Object)s3Location.bundleTypeString(), BUNDLETYPE_BINDING);
            protocolMarshaller.marshall((Object)s3Location.version(), VERSION_BINDING);
            protocolMarshaller.marshall((Object)s3Location.eTag(), ETAG_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

