/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codedeploy.model.Diagnostics;

@SdkInternalApi
public class DiagnosticsMarshaller {
    private static final MarshallingInfo<String> ERRORCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("errorCode").build();
    private static final MarshallingInfo<String> SCRIPTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scriptName").build();
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("message").build();
    private static final MarshallingInfo<String> LOGTAIL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logTail").build();
    private static final DiagnosticsMarshaller INSTANCE = new DiagnosticsMarshaller();

    public static DiagnosticsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Diagnostics diagnostics, ProtocolMarshaller protocolMarshaller) {
        if (diagnostics == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)diagnostics.errorCodeString(), ERRORCODE_BINDING);
            protocolMarshaller.marshall((Object)diagnostics.scriptName(), SCRIPTNAME_BINDING);
            protocolMarshaller.marshall((Object)diagnostics.message(), MESSAGE_BINDING);
            protocolMarshaller.marshall((Object)diagnostics.logTail(), LOGTAIL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

