/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codedeploy.model.InstanceInfo;

@SdkInternalApi
public class InstanceInfoMarshaller {
    private static final MarshallingInfo<String> INSTANCENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceName").build();
    private static final MarshallingInfo<String> IAMSESSIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("iamSessionArn").build();
    private static final MarshallingInfo<String> IAMUSERARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("iamUserArn").build();
    private static final MarshallingInfo<String> INSTANCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceArn").build();
    private static final MarshallingInfo<Instant> REGISTERTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("registerTime").build();
    private static final MarshallingInfo<Instant> DEREGISTERTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deregisterTime").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final InstanceInfoMarshaller INSTANCE = new InstanceInfoMarshaller();

    public static InstanceInfoMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InstanceInfo instanceInfo, ProtocolMarshaller protocolMarshaller) {
        if (instanceInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)instanceInfo.instanceName(), INSTANCENAME_BINDING);
            protocolMarshaller.marshall((Object)instanceInfo.iamSessionArn(), IAMSESSIONARN_BINDING);
            protocolMarshaller.marshall((Object)instanceInfo.iamUserArn(), IAMUSERARN_BINDING);
            protocolMarshaller.marshall((Object)instanceInfo.instanceArn(), INSTANCEARN_BINDING);
            protocolMarshaller.marshall((Object)instanceInfo.registerTime(), REGISTERTIME_BINDING);
            protocolMarshaller.marshall((Object)instanceInfo.deregisterTime(), DEREGISTERTIME_BINDING);
            protocolMarshaller.marshall(instanceInfo.tags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

