/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.model.GenericRevisionInfo;
import software.amazon.awssdk.services.codedeploy.model.RevisionLocation;
import software.amazon.awssdk.services.codedeploy.transform.RevisionInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RevisionInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, RevisionInfo> {
    private final RevisionLocation revisionLocation;
    private final GenericRevisionInfo genericRevisionInfo;

    private RevisionInfo(BuilderImpl builder) {
        this.revisionLocation = builder.revisionLocation;
        this.genericRevisionInfo = builder.genericRevisionInfo;
    }

    public RevisionLocation revisionLocation() {
        return this.revisionLocation;
    }

    public GenericRevisionInfo genericRevisionInfo() {
        return this.genericRevisionInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.revisionLocation() == null ? 0 : this.revisionLocation().hashCode());
        hashCode = 31 * hashCode + (this.genericRevisionInfo() == null ? 0 : this.genericRevisionInfo().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevisionInfo)) {
            return false;
        }
        RevisionInfo other = (RevisionInfo)obj;
        if (other.revisionLocation() == null ^ this.revisionLocation() == null) {
            return false;
        }
        if (other.revisionLocation() != null && !other.revisionLocation().equals(this.revisionLocation())) {
            return false;
        }
        if (other.genericRevisionInfo() == null ^ this.genericRevisionInfo() == null) {
            return false;
        }
        return other.genericRevisionInfo() == null || other.genericRevisionInfo().equals(this.genericRevisionInfo());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.revisionLocation() != null) {
            sb.append("RevisionLocation: ").append(this.revisionLocation()).append(",");
        }
        if (this.genericRevisionInfo() != null) {
            sb.append("GenericRevisionInfo: ").append(this.genericRevisionInfo()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RevisionInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private RevisionLocation revisionLocation;
        private GenericRevisionInfo genericRevisionInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(RevisionInfo model) {
            this.setRevisionLocation(model.revisionLocation);
            this.setGenericRevisionInfo(model.genericRevisionInfo);
        }

        public final RevisionLocation getRevisionLocation() {
            return this.revisionLocation;
        }

        @Override
        public final Builder revisionLocation(RevisionLocation revisionLocation) {
            this.revisionLocation = revisionLocation;
            return this;
        }

        public final void setRevisionLocation(RevisionLocation revisionLocation) {
            this.revisionLocation = revisionLocation;
        }

        public final GenericRevisionInfo getGenericRevisionInfo() {
            return this.genericRevisionInfo;
        }

        @Override
        public final Builder genericRevisionInfo(GenericRevisionInfo genericRevisionInfo) {
            this.genericRevisionInfo = genericRevisionInfo;
            return this;
        }

        public final void setGenericRevisionInfo(GenericRevisionInfo genericRevisionInfo) {
            this.genericRevisionInfo = genericRevisionInfo;
        }

        public RevisionInfo build() {
            return new RevisionInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RevisionInfo> {
        public Builder revisionLocation(RevisionLocation var1);

        public Builder genericRevisionInfo(GenericRevisionInfo var1);
    }
}

