/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.waiters;

import com.fasterxml.jackson.databind.JsonNode;
import io.burt.jmespath.Expression;
import io.burt.jmespath.jackson.JacksonRuntime;
import java.io.IOException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentResponse;
import software.amazon.awssdk.waiters.AcceptorPathMatcher;
import software.amazon.awssdk.waiters.ObjectMapperSingleton;
import software.amazon.awssdk.waiters.WaiterAcceptor;
import software.amazon.awssdk.waiters.WaiterState;

@SdkInternalApi
class DeploymentSuccessful {
    DeploymentSuccessful() {
    }

    static class IsStoppedMatcher
    extends WaiterAcceptor<GetDeploymentResponse> {
        private static final JsonNode EXPECTED_RESULT;
        private static final Expression<JsonNode> AST;

        IsStoppedMatcher() {
        }

        public boolean matches(GetDeploymentResponse result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = (JsonNode)AST.search((Object)queryNode);
            return AcceptorPathMatcher.path((JsonNode)EXPECTED_RESULT, (JsonNode)finalResult);
        }

        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                EXPECTED_RESULT = ObjectMapperSingleton.getObjectMapper().readTree("\"Stopped\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            AST = new JacksonRuntime().compile("deploymentInfo.status");
        }
    }

    static class IsFailedMatcher
    extends WaiterAcceptor<GetDeploymentResponse> {
        private static final JsonNode EXPECTED_RESULT;
        private static final Expression<JsonNode> AST;

        IsFailedMatcher() {
        }

        public boolean matches(GetDeploymentResponse result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = (JsonNode)AST.search((Object)queryNode);
            return AcceptorPathMatcher.path((JsonNode)EXPECTED_RESULT, (JsonNode)finalResult);
        }

        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                EXPECTED_RESULT = ObjectMapperSingleton.getObjectMapper().readTree("\"Failed\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            AST = new JacksonRuntime().compile("deploymentInfo.status");
        }
    }

    static class IsSucceededMatcher
    extends WaiterAcceptor<GetDeploymentResponse> {
        private static final JsonNode EXPECTED_RESULT;
        private static final Expression<JsonNode> AST;

        IsSucceededMatcher() {
        }

        public boolean matches(GetDeploymentResponse result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = (JsonNode)AST.search((Object)queryNode);
            return AcceptorPathMatcher.path((JsonNode)EXPECTED_RESULT, (JsonNode)finalResult);
        }

        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }

        static {
            try {
                EXPECTED_RESULT = ObjectMapperSingleton.getObjectMapper().readTree("\"Succeeded\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            AST = new JacksonRuntime().compile("deploymentInfo.status");
        }
    }
}

