/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codedeploy.model.TargetInstances;

@SdkInternalApi
public class TargetInstancesMarshaller {
    private static final MarshallingInfo<List> TAGFILTERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tagFilters").build();
    private static final MarshallingInfo<List> AUTOSCALINGGROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("autoScalingGroups").build();
    private static final TargetInstancesMarshaller INSTANCE = new TargetInstancesMarshaller();

    public static TargetInstancesMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TargetInstances targetInstances, ProtocolMarshaller protocolMarshaller) {
        if (targetInstances == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(targetInstances.tagFilters(), TAGFILTERS_BINDING);
            protocolMarshaller.marshall(targetInstances.autoScalingGroups(), AUTOSCALINGGROUPS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

