/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.model.RevisionInfo;

@SdkInternalApi
public class RevisionInfoMarshaller {
    private static final MarshallingInfo<StructuredPojo> REVISIONLOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("revisionLocation").build();
    private static final MarshallingInfo<StructuredPojo> GENERICREVISIONINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("genericRevisionInfo").build();
    private static final RevisionInfoMarshaller instance = new RevisionInfoMarshaller();

    public static RevisionInfoMarshaller getInstance() {
        return instance;
    }

    public void marshall(RevisionInfo revisionInfo, ProtocolMarshaller protocolMarshaller) {
        if (revisionInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)revisionInfo.revisionLocation(), REVISIONLOCATION_BINDING);
            protocolMarshaller.marshall((Object)revisionInfo.genericRevisionInfo(), GENERICREVISIONINFO_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

