/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.model.TriggerEventType;
import software.amazon.awssdk.services.codedeploy.model.TriggerEventTypeListCopier;
import software.amazon.awssdk.services.codedeploy.transform.TriggerConfigMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TriggerConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, TriggerConfig> {
    private final String triggerName;
    private final String triggerTargetArn;
    private final List<String> triggerEvents;

    private TriggerConfig(BuilderImpl builder) {
        this.triggerName = builder.triggerName;
        this.triggerTargetArn = builder.triggerTargetArn;
        this.triggerEvents = builder.triggerEvents;
    }

    public String triggerName() {
        return this.triggerName;
    }

    public String triggerTargetArn() {
        return this.triggerTargetArn;
    }

    public List<String> triggerEvents() {
        return this.triggerEvents;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.triggerName() == null ? 0 : this.triggerName().hashCode());
        hashCode = 31 * hashCode + (this.triggerTargetArn() == null ? 0 : this.triggerTargetArn().hashCode());
        hashCode = 31 * hashCode + (this.triggerEvents() == null ? 0 : this.triggerEvents().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TriggerConfig)) {
            return false;
        }
        TriggerConfig other = (TriggerConfig)obj;
        if (other.triggerName() == null ^ this.triggerName() == null) {
            return false;
        }
        if (other.triggerName() != null && !other.triggerName().equals(this.triggerName())) {
            return false;
        }
        if (other.triggerTargetArn() == null ^ this.triggerTargetArn() == null) {
            return false;
        }
        if (other.triggerTargetArn() != null && !other.triggerTargetArn().equals(this.triggerTargetArn())) {
            return false;
        }
        if (other.triggerEvents() == null ^ this.triggerEvents() == null) {
            return false;
        }
        return other.triggerEvents() == null || other.triggerEvents().equals(this.triggerEvents());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.triggerName() != null) {
            sb.append("TriggerName: ").append(this.triggerName()).append(",");
        }
        if (this.triggerTargetArn() != null) {
            sb.append("TriggerTargetArn: ").append(this.triggerTargetArn()).append(",");
        }
        if (this.triggerEvents() != null) {
            sb.append("TriggerEvents: ").append(this.triggerEvents()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TriggerConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String triggerName;
        private String triggerTargetArn;
        private List<String> triggerEvents;

        private BuilderImpl() {
        }

        private BuilderImpl(TriggerConfig model) {
            this.setTriggerName(model.triggerName);
            this.setTriggerTargetArn(model.triggerTargetArn);
            this.setTriggerEvents(model.triggerEvents);
        }

        public final String getTriggerName() {
            return this.triggerName;
        }

        @Override
        public final Builder triggerName(String triggerName) {
            this.triggerName = triggerName;
            return this;
        }

        public final void setTriggerName(String triggerName) {
            this.triggerName = triggerName;
        }

        public final String getTriggerTargetArn() {
            return this.triggerTargetArn;
        }

        @Override
        public final Builder triggerTargetArn(String triggerTargetArn) {
            this.triggerTargetArn = triggerTargetArn;
            return this;
        }

        public final void setTriggerTargetArn(String triggerTargetArn) {
            this.triggerTargetArn = triggerTargetArn;
        }

        public final Collection<String> getTriggerEvents() {
            return this.triggerEvents;
        }

        @Override
        public final Builder triggerEvents(Collection<String> triggerEvents) {
            this.triggerEvents = TriggerEventTypeListCopier.copy(triggerEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggerEvents(String ... triggerEvents) {
            this.triggerEvents(Arrays.asList(triggerEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggerEvents(TriggerEventType ... triggerEvents) {
            this.triggerEvents(Arrays.asList(triggerEvents).stream().map(Object::toString).collect(Collectors.toList()));
            return this;
        }

        public final void setTriggerEvents(Collection<String> triggerEvents) {
            this.triggerEvents = TriggerEventTypeListCopier.copy(triggerEvents);
        }

        @SafeVarargs
        public final void setTriggerEvents(String ... triggerEvents) {
            this.triggerEvents(Arrays.asList(triggerEvents));
        }

        @SafeVarargs
        public final void setTriggerEvents(TriggerEventType ... triggerEvents) {
            this.triggerEvents(Arrays.asList(triggerEvents).stream().map(Object::toString).collect(Collectors.toList()));
        }

        public TriggerConfig build() {
            return new TriggerConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TriggerConfig> {
        public Builder triggerName(String var1);

        public Builder triggerTargetArn(String var1);

        public Builder triggerEvents(Collection<String> var1);

        public Builder triggerEvents(String ... var1);

        public Builder triggerEvents(TriggerEventType ... var1);
    }
}

