/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.transform.TimeRangeMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TimeRange
implements StructuredPojo,
ToCopyableBuilder<Builder, TimeRange> {
    private final Instant start;
    private final Instant end;

    private TimeRange(BuilderImpl builder) {
        this.start = builder.start;
        this.end = builder.end;
    }

    public Instant start() {
        return this.start;
    }

    public Instant end() {
        return this.end;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.start() == null ? 0 : this.start().hashCode());
        hashCode = 31 * hashCode + (this.end() == null ? 0 : this.end().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeRange)) {
            return false;
        }
        TimeRange other = (TimeRange)obj;
        if (other.start() == null ^ this.start() == null) {
            return false;
        }
        if (other.start() != null && !other.start().equals(this.start())) {
            return false;
        }
        if (other.end() == null ^ this.end() == null) {
            return false;
        }
        return other.end() == null || other.end().equals(this.end());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.start() != null) {
            sb.append("Start: ").append(this.start()).append(",");
        }
        if (this.end() != null) {
            sb.append("End: ").append(this.end()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TimeRangeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Instant start;
        private Instant end;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeRange model) {
            this.setStart(model.start);
            this.setEnd(model.end);
        }

        public final Instant getStart() {
            return this.start;
        }

        @Override
        public final Builder start(Instant start) {
            this.start = start;
            return this;
        }

        public final void setStart(Instant start) {
            this.start = start;
        }

        public final Instant getEnd() {
            return this.end;
        }

        @Override
        public final Builder end(Instant end) {
            this.end = end;
            return this;
        }

        public final void setEnd(Instant end) {
            this.end = end;
        }

        public TimeRange build() {
            return new TimeRange(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TimeRange> {
        public Builder start(Instant var1);

        public Builder end(Instant var1);
    }
}

