/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.model.DeploymentOption;
import software.amazon.awssdk.services.codedeploy.model.DeploymentType;
import software.amazon.awssdk.services.codedeploy.transform.DeploymentStyleMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeploymentStyle
implements StructuredPojo,
ToCopyableBuilder<Builder, DeploymentStyle> {
    private final String deploymentType;
    private final String deploymentOption;

    private DeploymentStyle(BuilderImpl builder) {
        this.deploymentType = builder.deploymentType;
        this.deploymentOption = builder.deploymentOption;
    }

    public String deploymentType() {
        return this.deploymentType;
    }

    public String deploymentOption() {
        return this.deploymentOption;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.deploymentType() == null ? 0 : this.deploymentType().hashCode());
        hashCode = 31 * hashCode + (this.deploymentOption() == null ? 0 : this.deploymentOption().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentStyle)) {
            return false;
        }
        DeploymentStyle other = (DeploymentStyle)obj;
        if (other.deploymentType() == null ^ this.deploymentType() == null) {
            return false;
        }
        if (other.deploymentType() != null && !other.deploymentType().equals(this.deploymentType())) {
            return false;
        }
        if (other.deploymentOption() == null ^ this.deploymentOption() == null) {
            return false;
        }
        return other.deploymentOption() == null || other.deploymentOption().equals(this.deploymentOption());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.deploymentType() != null) {
            sb.append("DeploymentType: ").append(this.deploymentType()).append(",");
        }
        if (this.deploymentOption() != null) {
            sb.append("DeploymentOption: ").append(this.deploymentOption()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeploymentStyleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String deploymentType;
        private String deploymentOption;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentStyle model) {
            this.setDeploymentType(model.deploymentType);
            this.setDeploymentOption(model.deploymentOption);
        }

        public final String getDeploymentType() {
            return this.deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(DeploymentType deploymentType) {
            this.deploymentType(deploymentType.toString());
            return this;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        public final void setDeploymentType(DeploymentType deploymentType) {
            this.deploymentType(deploymentType.toString());
        }

        public final String getDeploymentOption() {
            return this.deploymentOption;
        }

        @Override
        public final Builder deploymentOption(String deploymentOption) {
            this.deploymentOption = deploymentOption;
            return this;
        }

        @Override
        public final Builder deploymentOption(DeploymentOption deploymentOption) {
            this.deploymentOption(deploymentOption.toString());
            return this;
        }

        public final void setDeploymentOption(String deploymentOption) {
            this.deploymentOption = deploymentOption;
        }

        public final void setDeploymentOption(DeploymentOption deploymentOption) {
            this.deploymentOption(deploymentOption.toString());
        }

        public DeploymentStyle build() {
            return new DeploymentStyle(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeploymentStyle> {
        public Builder deploymentType(String var1);

        public Builder deploymentType(DeploymentType var1);

        public Builder deploymentOption(String var1);

        public Builder deploymentOption(DeploymentOption var1);
    }
}

