/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.model.AlarmConfiguration;
import software.amazon.awssdk.services.codedeploy.model.AutoRollbackConfiguration;
import software.amazon.awssdk.services.codedeploy.model.AutoScalingGroup;
import software.amazon.awssdk.services.codedeploy.model.AutoScalingGroupListCopier;
import software.amazon.awssdk.services.codedeploy.model.BlueGreenDeploymentConfiguration;
import software.amazon.awssdk.services.codedeploy.model.DeploymentStyle;
import software.amazon.awssdk.services.codedeploy.model.EC2TagFilter;
import software.amazon.awssdk.services.codedeploy.model.EC2TagFilterListCopier;
import software.amazon.awssdk.services.codedeploy.model.LastDeploymentInfo;
import software.amazon.awssdk.services.codedeploy.model.LoadBalancerInfo;
import software.amazon.awssdk.services.codedeploy.model.RevisionLocation;
import software.amazon.awssdk.services.codedeploy.model.TagFilter;
import software.amazon.awssdk.services.codedeploy.model.TagFilterListCopier;
import software.amazon.awssdk.services.codedeploy.model.TriggerConfig;
import software.amazon.awssdk.services.codedeploy.model.TriggerConfigListCopier;
import software.amazon.awssdk.services.codedeploy.transform.DeploymentGroupInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeploymentGroupInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, DeploymentGroupInfo> {
    private final String applicationName;
    private final String deploymentGroupId;
    private final String deploymentGroupName;
    private final String deploymentConfigName;
    private final List<EC2TagFilter> ec2TagFilters;
    private final List<TagFilter> onPremisesInstanceTagFilters;
    private final List<AutoScalingGroup> autoScalingGroups;
    private final String serviceRoleArn;
    private final RevisionLocation targetRevision;
    private final List<TriggerConfig> triggerConfigurations;
    private final AlarmConfiguration alarmConfiguration;
    private final AutoRollbackConfiguration autoRollbackConfiguration;
    private final DeploymentStyle deploymentStyle;
    private final BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration;
    private final LoadBalancerInfo loadBalancerInfo;
    private final LastDeploymentInfo lastSuccessfulDeployment;
    private final LastDeploymentInfo lastAttemptedDeployment;

    private DeploymentGroupInfo(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.deploymentGroupId = builder.deploymentGroupId;
        this.deploymentGroupName = builder.deploymentGroupName;
        this.deploymentConfigName = builder.deploymentConfigName;
        this.ec2TagFilters = builder.ec2TagFilters;
        this.onPremisesInstanceTagFilters = builder.onPremisesInstanceTagFilters;
        this.autoScalingGroups = builder.autoScalingGroups;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.targetRevision = builder.targetRevision;
        this.triggerConfigurations = builder.triggerConfigurations;
        this.alarmConfiguration = builder.alarmConfiguration;
        this.autoRollbackConfiguration = builder.autoRollbackConfiguration;
        this.deploymentStyle = builder.deploymentStyle;
        this.blueGreenDeploymentConfiguration = builder.blueGreenDeploymentConfiguration;
        this.loadBalancerInfo = builder.loadBalancerInfo;
        this.lastSuccessfulDeployment = builder.lastSuccessfulDeployment;
        this.lastAttemptedDeployment = builder.lastAttemptedDeployment;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String deploymentGroupId() {
        return this.deploymentGroupId;
    }

    public String deploymentGroupName() {
        return this.deploymentGroupName;
    }

    public String deploymentConfigName() {
        return this.deploymentConfigName;
    }

    public List<EC2TagFilter> ec2TagFilters() {
        return this.ec2TagFilters;
    }

    public List<TagFilter> onPremisesInstanceTagFilters() {
        return this.onPremisesInstanceTagFilters;
    }

    public List<AutoScalingGroup> autoScalingGroups() {
        return this.autoScalingGroups;
    }

    public String serviceRoleArn() {
        return this.serviceRoleArn;
    }

    public RevisionLocation targetRevision() {
        return this.targetRevision;
    }

    public List<TriggerConfig> triggerConfigurations() {
        return this.triggerConfigurations;
    }

    public AlarmConfiguration alarmConfiguration() {
        return this.alarmConfiguration;
    }

    public AutoRollbackConfiguration autoRollbackConfiguration() {
        return this.autoRollbackConfiguration;
    }

    public DeploymentStyle deploymentStyle() {
        return this.deploymentStyle;
    }

    public BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration() {
        return this.blueGreenDeploymentConfiguration;
    }

    public LoadBalancerInfo loadBalancerInfo() {
        return this.loadBalancerInfo;
    }

    public LastDeploymentInfo lastSuccessfulDeployment() {
        return this.lastSuccessfulDeployment;
    }

    public LastDeploymentInfo lastAttemptedDeployment() {
        return this.lastAttemptedDeployment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationName() == null ? 0 : this.applicationName().hashCode());
        hashCode = 31 * hashCode + (this.deploymentGroupId() == null ? 0 : this.deploymentGroupId().hashCode());
        hashCode = 31 * hashCode + (this.deploymentGroupName() == null ? 0 : this.deploymentGroupName().hashCode());
        hashCode = 31 * hashCode + (this.deploymentConfigName() == null ? 0 : this.deploymentConfigName().hashCode());
        hashCode = 31 * hashCode + (this.ec2TagFilters() == null ? 0 : this.ec2TagFilters().hashCode());
        hashCode = 31 * hashCode + (this.onPremisesInstanceTagFilters() == null ? 0 : this.onPremisesInstanceTagFilters().hashCode());
        hashCode = 31 * hashCode + (this.autoScalingGroups() == null ? 0 : this.autoScalingGroups().hashCode());
        hashCode = 31 * hashCode + (this.serviceRoleArn() == null ? 0 : this.serviceRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.targetRevision() == null ? 0 : this.targetRevision().hashCode());
        hashCode = 31 * hashCode + (this.triggerConfigurations() == null ? 0 : this.triggerConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.alarmConfiguration() == null ? 0 : this.alarmConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.autoRollbackConfiguration() == null ? 0 : this.autoRollbackConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.deploymentStyle() == null ? 0 : this.deploymentStyle().hashCode());
        hashCode = 31 * hashCode + (this.blueGreenDeploymentConfiguration() == null ? 0 : this.blueGreenDeploymentConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.loadBalancerInfo() == null ? 0 : this.loadBalancerInfo().hashCode());
        hashCode = 31 * hashCode + (this.lastSuccessfulDeployment() == null ? 0 : this.lastSuccessfulDeployment().hashCode());
        hashCode = 31 * hashCode + (this.lastAttemptedDeployment() == null ? 0 : this.lastAttemptedDeployment().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentGroupInfo)) {
            return false;
        }
        DeploymentGroupInfo other = (DeploymentGroupInfo)obj;
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.deploymentGroupId() == null ^ this.deploymentGroupId() == null) {
            return false;
        }
        if (other.deploymentGroupId() != null && !other.deploymentGroupId().equals(this.deploymentGroupId())) {
            return false;
        }
        if (other.deploymentGroupName() == null ^ this.deploymentGroupName() == null) {
            return false;
        }
        if (other.deploymentGroupName() != null && !other.deploymentGroupName().equals(this.deploymentGroupName())) {
            return false;
        }
        if (other.deploymentConfigName() == null ^ this.deploymentConfigName() == null) {
            return false;
        }
        if (other.deploymentConfigName() != null && !other.deploymentConfigName().equals(this.deploymentConfigName())) {
            return false;
        }
        if (other.ec2TagFilters() == null ^ this.ec2TagFilters() == null) {
            return false;
        }
        if (other.ec2TagFilters() != null && !other.ec2TagFilters().equals(this.ec2TagFilters())) {
            return false;
        }
        if (other.onPremisesInstanceTagFilters() == null ^ this.onPremisesInstanceTagFilters() == null) {
            return false;
        }
        if (other.onPremisesInstanceTagFilters() != null && !other.onPremisesInstanceTagFilters().equals(this.onPremisesInstanceTagFilters())) {
            return false;
        }
        if (other.autoScalingGroups() == null ^ this.autoScalingGroups() == null) {
            return false;
        }
        if (other.autoScalingGroups() != null && !other.autoScalingGroups().equals(this.autoScalingGroups())) {
            return false;
        }
        if (other.serviceRoleArn() == null ^ this.serviceRoleArn() == null) {
            return false;
        }
        if (other.serviceRoleArn() != null && !other.serviceRoleArn().equals(this.serviceRoleArn())) {
            return false;
        }
        if (other.targetRevision() == null ^ this.targetRevision() == null) {
            return false;
        }
        if (other.targetRevision() != null && !other.targetRevision().equals(this.targetRevision())) {
            return false;
        }
        if (other.triggerConfigurations() == null ^ this.triggerConfigurations() == null) {
            return false;
        }
        if (other.triggerConfigurations() != null && !other.triggerConfigurations().equals(this.triggerConfigurations())) {
            return false;
        }
        if (other.alarmConfiguration() == null ^ this.alarmConfiguration() == null) {
            return false;
        }
        if (other.alarmConfiguration() != null && !other.alarmConfiguration().equals(this.alarmConfiguration())) {
            return false;
        }
        if (other.autoRollbackConfiguration() == null ^ this.autoRollbackConfiguration() == null) {
            return false;
        }
        if (other.autoRollbackConfiguration() != null && !other.autoRollbackConfiguration().equals(this.autoRollbackConfiguration())) {
            return false;
        }
        if (other.deploymentStyle() == null ^ this.deploymentStyle() == null) {
            return false;
        }
        if (other.deploymentStyle() != null && !other.deploymentStyle().equals(this.deploymentStyle())) {
            return false;
        }
        if (other.blueGreenDeploymentConfiguration() == null ^ this.blueGreenDeploymentConfiguration() == null) {
            return false;
        }
        if (other.blueGreenDeploymentConfiguration() != null && !other.blueGreenDeploymentConfiguration().equals(this.blueGreenDeploymentConfiguration())) {
            return false;
        }
        if (other.loadBalancerInfo() == null ^ this.loadBalancerInfo() == null) {
            return false;
        }
        if (other.loadBalancerInfo() != null && !other.loadBalancerInfo().equals(this.loadBalancerInfo())) {
            return false;
        }
        if (other.lastSuccessfulDeployment() == null ^ this.lastSuccessfulDeployment() == null) {
            return false;
        }
        if (other.lastSuccessfulDeployment() != null && !other.lastSuccessfulDeployment().equals(this.lastSuccessfulDeployment())) {
            return false;
        }
        if (other.lastAttemptedDeployment() == null ^ this.lastAttemptedDeployment() == null) {
            return false;
        }
        return other.lastAttemptedDeployment() == null || other.lastAttemptedDeployment().equals(this.lastAttemptedDeployment());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.deploymentGroupId() != null) {
            sb.append("DeploymentGroupId: ").append(this.deploymentGroupId()).append(",");
        }
        if (this.deploymentGroupName() != null) {
            sb.append("DeploymentGroupName: ").append(this.deploymentGroupName()).append(",");
        }
        if (this.deploymentConfigName() != null) {
            sb.append("DeploymentConfigName: ").append(this.deploymentConfigName()).append(",");
        }
        if (this.ec2TagFilters() != null) {
            sb.append("Ec2TagFilters: ").append(this.ec2TagFilters()).append(",");
        }
        if (this.onPremisesInstanceTagFilters() != null) {
            sb.append("OnPremisesInstanceTagFilters: ").append(this.onPremisesInstanceTagFilters()).append(",");
        }
        if (this.autoScalingGroups() != null) {
            sb.append("AutoScalingGroups: ").append(this.autoScalingGroups()).append(",");
        }
        if (this.serviceRoleArn() != null) {
            sb.append("ServiceRoleArn: ").append(this.serviceRoleArn()).append(",");
        }
        if (this.targetRevision() != null) {
            sb.append("TargetRevision: ").append(this.targetRevision()).append(",");
        }
        if (this.triggerConfigurations() != null) {
            sb.append("TriggerConfigurations: ").append(this.triggerConfigurations()).append(",");
        }
        if (this.alarmConfiguration() != null) {
            sb.append("AlarmConfiguration: ").append(this.alarmConfiguration()).append(",");
        }
        if (this.autoRollbackConfiguration() != null) {
            sb.append("AutoRollbackConfiguration: ").append(this.autoRollbackConfiguration()).append(",");
        }
        if (this.deploymentStyle() != null) {
            sb.append("DeploymentStyle: ").append(this.deploymentStyle()).append(",");
        }
        if (this.blueGreenDeploymentConfiguration() != null) {
            sb.append("BlueGreenDeploymentConfiguration: ").append(this.blueGreenDeploymentConfiguration()).append(",");
        }
        if (this.loadBalancerInfo() != null) {
            sb.append("LoadBalancerInfo: ").append(this.loadBalancerInfo()).append(",");
        }
        if (this.lastSuccessfulDeployment() != null) {
            sb.append("LastSuccessfulDeployment: ").append(this.lastSuccessfulDeployment()).append(",");
        }
        if (this.lastAttemptedDeployment() != null) {
            sb.append("LastAttemptedDeployment: ").append(this.lastAttemptedDeployment()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeploymentGroupInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private String deploymentGroupId;
        private String deploymentGroupName;
        private String deploymentConfigName;
        private List<EC2TagFilter> ec2TagFilters;
        private List<TagFilter> onPremisesInstanceTagFilters;
        private List<AutoScalingGroup> autoScalingGroups;
        private String serviceRoleArn;
        private RevisionLocation targetRevision;
        private List<TriggerConfig> triggerConfigurations;
        private AlarmConfiguration alarmConfiguration;
        private AutoRollbackConfiguration autoRollbackConfiguration;
        private DeploymentStyle deploymentStyle;
        private BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration;
        private LoadBalancerInfo loadBalancerInfo;
        private LastDeploymentInfo lastSuccessfulDeployment;
        private LastDeploymentInfo lastAttemptedDeployment;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentGroupInfo model) {
            this.setApplicationName(model.applicationName);
            this.setDeploymentGroupId(model.deploymentGroupId);
            this.setDeploymentGroupName(model.deploymentGroupName);
            this.setDeploymentConfigName(model.deploymentConfigName);
            this.setEc2TagFilters(model.ec2TagFilters);
            this.setOnPremisesInstanceTagFilters(model.onPremisesInstanceTagFilters);
            this.setAutoScalingGroups(model.autoScalingGroups);
            this.setServiceRoleArn(model.serviceRoleArn);
            this.setTargetRevision(model.targetRevision);
            this.setTriggerConfigurations(model.triggerConfigurations);
            this.setAlarmConfiguration(model.alarmConfiguration);
            this.setAutoRollbackConfiguration(model.autoRollbackConfiguration);
            this.setDeploymentStyle(model.deploymentStyle);
            this.setBlueGreenDeploymentConfiguration(model.blueGreenDeploymentConfiguration);
            this.setLoadBalancerInfo(model.loadBalancerInfo);
            this.setLastSuccessfulDeployment(model.lastSuccessfulDeployment);
            this.setLastAttemptedDeployment(model.lastAttemptedDeployment);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getDeploymentGroupId() {
            return this.deploymentGroupId;
        }

        @Override
        public final Builder deploymentGroupId(String deploymentGroupId) {
            this.deploymentGroupId = deploymentGroupId;
            return this;
        }

        public final void setDeploymentGroupId(String deploymentGroupId) {
            this.deploymentGroupId = deploymentGroupId;
        }

        public final String getDeploymentGroupName() {
            return this.deploymentGroupName;
        }

        @Override
        public final Builder deploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
            return this;
        }

        public final void setDeploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
        }

        public final String getDeploymentConfigName() {
            return this.deploymentConfigName;
        }

        @Override
        public final Builder deploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        public final void setDeploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
        }

        public final Collection<EC2TagFilter> getEc2TagFilters() {
            return this.ec2TagFilters;
        }

        @Override
        public final Builder ec2TagFilters(Collection<EC2TagFilter> ec2TagFilters) {
            this.ec2TagFilters = EC2TagFilterListCopier.copy(ec2TagFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2TagFilters(EC2TagFilter ... ec2TagFilters) {
            this.ec2TagFilters(Arrays.asList(ec2TagFilters));
            return this;
        }

        public final void setEc2TagFilters(Collection<EC2TagFilter> ec2TagFilters) {
            this.ec2TagFilters = EC2TagFilterListCopier.copy(ec2TagFilters);
        }

        @SafeVarargs
        public final void setEc2TagFilters(EC2TagFilter ... ec2TagFilters) {
            this.ec2TagFilters(Arrays.asList(ec2TagFilters));
        }

        public final Collection<TagFilter> getOnPremisesInstanceTagFilters() {
            return this.onPremisesInstanceTagFilters;
        }

        @Override
        public final Builder onPremisesInstanceTagFilters(Collection<TagFilter> onPremisesInstanceTagFilters) {
            this.onPremisesInstanceTagFilters = TagFilterListCopier.copy(onPremisesInstanceTagFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onPremisesInstanceTagFilters(TagFilter ... onPremisesInstanceTagFilters) {
            this.onPremisesInstanceTagFilters(Arrays.asList(onPremisesInstanceTagFilters));
            return this;
        }

        public final void setOnPremisesInstanceTagFilters(Collection<TagFilter> onPremisesInstanceTagFilters) {
            this.onPremisesInstanceTagFilters = TagFilterListCopier.copy(onPremisesInstanceTagFilters);
        }

        @SafeVarargs
        public final void setOnPremisesInstanceTagFilters(TagFilter ... onPremisesInstanceTagFilters) {
            this.onPremisesInstanceTagFilters(Arrays.asList(onPremisesInstanceTagFilters));
        }

        public final Collection<AutoScalingGroup> getAutoScalingGroups() {
            return this.autoScalingGroups;
        }

        @Override
        public final Builder autoScalingGroups(Collection<AutoScalingGroup> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupListCopier.copy(autoScalingGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingGroups(AutoScalingGroup ... autoScalingGroups) {
            this.autoScalingGroups(Arrays.asList(autoScalingGroups));
            return this;
        }

        public final void setAutoScalingGroups(Collection<AutoScalingGroup> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupListCopier.copy(autoScalingGroups);
        }

        @SafeVarargs
        public final void setAutoScalingGroups(AutoScalingGroup ... autoScalingGroups) {
            this.autoScalingGroups(Arrays.asList(autoScalingGroups));
        }

        public final String getServiceRoleArn() {
            return this.serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        public final RevisionLocation getTargetRevision() {
            return this.targetRevision;
        }

        @Override
        public final Builder targetRevision(RevisionLocation targetRevision) {
            this.targetRevision = targetRevision;
            return this;
        }

        public final void setTargetRevision(RevisionLocation targetRevision) {
            this.targetRevision = targetRevision;
        }

        public final Collection<TriggerConfig> getTriggerConfigurations() {
            return this.triggerConfigurations;
        }

        @Override
        public final Builder triggerConfigurations(Collection<TriggerConfig> triggerConfigurations) {
            this.triggerConfigurations = TriggerConfigListCopier.copy(triggerConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggerConfigurations(TriggerConfig ... triggerConfigurations) {
            this.triggerConfigurations(Arrays.asList(triggerConfigurations));
            return this;
        }

        public final void setTriggerConfigurations(Collection<TriggerConfig> triggerConfigurations) {
            this.triggerConfigurations = TriggerConfigListCopier.copy(triggerConfigurations);
        }

        @SafeVarargs
        public final void setTriggerConfigurations(TriggerConfig ... triggerConfigurations) {
            this.triggerConfigurations(Arrays.asList(triggerConfigurations));
        }

        public final AlarmConfiguration getAlarmConfiguration() {
            return this.alarmConfiguration;
        }

        @Override
        public final Builder alarmConfiguration(AlarmConfiguration alarmConfiguration) {
            this.alarmConfiguration = alarmConfiguration;
            return this;
        }

        public final void setAlarmConfiguration(AlarmConfiguration alarmConfiguration) {
            this.alarmConfiguration = alarmConfiguration;
        }

        public final AutoRollbackConfiguration getAutoRollbackConfiguration() {
            return this.autoRollbackConfiguration;
        }

        @Override
        public final Builder autoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration;
            return this;
        }

        public final void setAutoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration;
        }

        public final DeploymentStyle getDeploymentStyle() {
            return this.deploymentStyle;
        }

        @Override
        public final Builder deploymentStyle(DeploymentStyle deploymentStyle) {
            this.deploymentStyle = deploymentStyle;
            return this;
        }

        public final void setDeploymentStyle(DeploymentStyle deploymentStyle) {
            this.deploymentStyle = deploymentStyle;
        }

        public final BlueGreenDeploymentConfiguration getBlueGreenDeploymentConfiguration() {
            return this.blueGreenDeploymentConfiguration;
        }

        @Override
        public final Builder blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration) {
            this.blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration;
            return this;
        }

        public final void setBlueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration) {
            this.blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration;
        }

        public final LoadBalancerInfo getLoadBalancerInfo() {
            return this.loadBalancerInfo;
        }

        @Override
        public final Builder loadBalancerInfo(LoadBalancerInfo loadBalancerInfo) {
            this.loadBalancerInfo = loadBalancerInfo;
            return this;
        }

        public final void setLoadBalancerInfo(LoadBalancerInfo loadBalancerInfo) {
            this.loadBalancerInfo = loadBalancerInfo;
        }

        public final LastDeploymentInfo getLastSuccessfulDeployment() {
            return this.lastSuccessfulDeployment;
        }

        @Override
        public final Builder lastSuccessfulDeployment(LastDeploymentInfo lastSuccessfulDeployment) {
            this.lastSuccessfulDeployment = lastSuccessfulDeployment;
            return this;
        }

        public final void setLastSuccessfulDeployment(LastDeploymentInfo lastSuccessfulDeployment) {
            this.lastSuccessfulDeployment = lastSuccessfulDeployment;
        }

        public final LastDeploymentInfo getLastAttemptedDeployment() {
            return this.lastAttemptedDeployment;
        }

        @Override
        public final Builder lastAttemptedDeployment(LastDeploymentInfo lastAttemptedDeployment) {
            this.lastAttemptedDeployment = lastAttemptedDeployment;
            return this;
        }

        public final void setLastAttemptedDeployment(LastDeploymentInfo lastAttemptedDeployment) {
            this.lastAttemptedDeployment = lastAttemptedDeployment;
        }

        public DeploymentGroupInfo build() {
            return new DeploymentGroupInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeploymentGroupInfo> {
        public Builder applicationName(String var1);

        public Builder deploymentGroupId(String var1);

        public Builder deploymentGroupName(String var1);

        public Builder deploymentConfigName(String var1);

        public Builder ec2TagFilters(Collection<EC2TagFilter> var1);

        public Builder ec2TagFilters(EC2TagFilter ... var1);

        public Builder onPremisesInstanceTagFilters(Collection<TagFilter> var1);

        public Builder onPremisesInstanceTagFilters(TagFilter ... var1);

        public Builder autoScalingGroups(Collection<AutoScalingGroup> var1);

        public Builder autoScalingGroups(AutoScalingGroup ... var1);

        public Builder serviceRoleArn(String var1);

        public Builder targetRevision(RevisionLocation var1);

        public Builder triggerConfigurations(Collection<TriggerConfig> var1);

        public Builder triggerConfigurations(TriggerConfig ... var1);

        public Builder alarmConfiguration(AlarmConfiguration var1);

        public Builder autoRollbackConfiguration(AutoRollbackConfiguration var1);

        public Builder deploymentStyle(DeploymentStyle var1);

        public Builder blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration var1);

        public Builder loadBalancerInfo(LoadBalancerInfo var1);

        public Builder lastSuccessfulDeployment(LastDeploymentInfo var1);

        public Builder lastAttemptedDeployment(LastDeploymentInfo var1);
    }
}

