/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.codedeploy.model.AutoRollbackConfiguration;
import software.amazon.awssdk.services.codedeploy.model.FileExistsBehavior;
import software.amazon.awssdk.services.codedeploy.model.RevisionLocation;
import software.amazon.awssdk.services.codedeploy.model.TargetInstances;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateDeploymentRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateDeploymentRequest> {
    private final String applicationName;
    private final String deploymentGroupName;
    private final RevisionLocation revision;
    private final String deploymentConfigName;
    private final String description;
    private final Boolean ignoreApplicationStopFailures;
    private final TargetInstances targetInstances;
    private final AutoRollbackConfiguration autoRollbackConfiguration;
    private final Boolean updateOutdatedInstancesOnly;
    private final String fileExistsBehavior;

    private CreateDeploymentRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.deploymentGroupName = builder.deploymentGroupName;
        this.revision = builder.revision;
        this.deploymentConfigName = builder.deploymentConfigName;
        this.description = builder.description;
        this.ignoreApplicationStopFailures = builder.ignoreApplicationStopFailures;
        this.targetInstances = builder.targetInstances;
        this.autoRollbackConfiguration = builder.autoRollbackConfiguration;
        this.updateOutdatedInstancesOnly = builder.updateOutdatedInstancesOnly;
        this.fileExistsBehavior = builder.fileExistsBehavior;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String deploymentGroupName() {
        return this.deploymentGroupName;
    }

    public RevisionLocation revision() {
        return this.revision;
    }

    public String deploymentConfigName() {
        return this.deploymentConfigName;
    }

    public String description() {
        return this.description;
    }

    public Boolean ignoreApplicationStopFailures() {
        return this.ignoreApplicationStopFailures;
    }

    public TargetInstances targetInstances() {
        return this.targetInstances;
    }

    public AutoRollbackConfiguration autoRollbackConfiguration() {
        return this.autoRollbackConfiguration;
    }

    public Boolean updateOutdatedInstancesOnly() {
        return this.updateOutdatedInstancesOnly;
    }

    public String fileExistsBehavior() {
        return this.fileExistsBehavior;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationName() == null ? 0 : this.applicationName().hashCode());
        hashCode = 31 * hashCode + (this.deploymentGroupName() == null ? 0 : this.deploymentGroupName().hashCode());
        hashCode = 31 * hashCode + (this.revision() == null ? 0 : this.revision().hashCode());
        hashCode = 31 * hashCode + (this.deploymentConfigName() == null ? 0 : this.deploymentConfigName().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.ignoreApplicationStopFailures() == null ? 0 : this.ignoreApplicationStopFailures().hashCode());
        hashCode = 31 * hashCode + (this.targetInstances() == null ? 0 : this.targetInstances().hashCode());
        hashCode = 31 * hashCode + (this.autoRollbackConfiguration() == null ? 0 : this.autoRollbackConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.updateOutdatedInstancesOnly() == null ? 0 : this.updateOutdatedInstancesOnly().hashCode());
        hashCode = 31 * hashCode + (this.fileExistsBehavior() == null ? 0 : this.fileExistsBehavior().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentRequest)) {
            return false;
        }
        CreateDeploymentRequest other = (CreateDeploymentRequest)((Object)obj);
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.deploymentGroupName() == null ^ this.deploymentGroupName() == null) {
            return false;
        }
        if (other.deploymentGroupName() != null && !other.deploymentGroupName().equals(this.deploymentGroupName())) {
            return false;
        }
        if (other.revision() == null ^ this.revision() == null) {
            return false;
        }
        if (other.revision() != null && !other.revision().equals(this.revision())) {
            return false;
        }
        if (other.deploymentConfigName() == null ^ this.deploymentConfigName() == null) {
            return false;
        }
        if (other.deploymentConfigName() != null && !other.deploymentConfigName().equals(this.deploymentConfigName())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.ignoreApplicationStopFailures() == null ^ this.ignoreApplicationStopFailures() == null) {
            return false;
        }
        if (other.ignoreApplicationStopFailures() != null && !other.ignoreApplicationStopFailures().equals(this.ignoreApplicationStopFailures())) {
            return false;
        }
        if (other.targetInstances() == null ^ this.targetInstances() == null) {
            return false;
        }
        if (other.targetInstances() != null && !other.targetInstances().equals(this.targetInstances())) {
            return false;
        }
        if (other.autoRollbackConfiguration() == null ^ this.autoRollbackConfiguration() == null) {
            return false;
        }
        if (other.autoRollbackConfiguration() != null && !other.autoRollbackConfiguration().equals(this.autoRollbackConfiguration())) {
            return false;
        }
        if (other.updateOutdatedInstancesOnly() == null ^ this.updateOutdatedInstancesOnly() == null) {
            return false;
        }
        if (other.updateOutdatedInstancesOnly() != null && !other.updateOutdatedInstancesOnly().equals(this.updateOutdatedInstancesOnly())) {
            return false;
        }
        if (other.fileExistsBehavior() == null ^ this.fileExistsBehavior() == null) {
            return false;
        }
        return other.fileExistsBehavior() == null || other.fileExistsBehavior().equals(this.fileExistsBehavior());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.deploymentGroupName() != null) {
            sb.append("DeploymentGroupName: ").append(this.deploymentGroupName()).append(",");
        }
        if (this.revision() != null) {
            sb.append("Revision: ").append(this.revision()).append(",");
        }
        if (this.deploymentConfigName() != null) {
            sb.append("DeploymentConfigName: ").append(this.deploymentConfigName()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.ignoreApplicationStopFailures() != null) {
            sb.append("IgnoreApplicationStopFailures: ").append(this.ignoreApplicationStopFailures()).append(",");
        }
        if (this.targetInstances() != null) {
            sb.append("TargetInstances: ").append(this.targetInstances()).append(",");
        }
        if (this.autoRollbackConfiguration() != null) {
            sb.append("AutoRollbackConfiguration: ").append(this.autoRollbackConfiguration()).append(",");
        }
        if (this.updateOutdatedInstancesOnly() != null) {
            sb.append("UpdateOutdatedInstancesOnly: ").append(this.updateOutdatedInstancesOnly()).append(",");
        }
        if (this.fileExistsBehavior() != null) {
            sb.append("FileExistsBehavior: ").append(this.fileExistsBehavior()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private String deploymentGroupName;
        private RevisionLocation revision;
        private String deploymentConfigName;
        private String description;
        private Boolean ignoreApplicationStopFailures;
        private TargetInstances targetInstances;
        private AutoRollbackConfiguration autoRollbackConfiguration;
        private Boolean updateOutdatedInstancesOnly;
        private String fileExistsBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeploymentRequest model) {
            this.setApplicationName(model.applicationName);
            this.setDeploymentGroupName(model.deploymentGroupName);
            this.setRevision(model.revision);
            this.setDeploymentConfigName(model.deploymentConfigName);
            this.setDescription(model.description);
            this.setIgnoreApplicationStopFailures(model.ignoreApplicationStopFailures);
            this.setTargetInstances(model.targetInstances);
            this.setAutoRollbackConfiguration(model.autoRollbackConfiguration);
            this.setUpdateOutdatedInstancesOnly(model.updateOutdatedInstancesOnly);
            this.setFileExistsBehavior(model.fileExistsBehavior);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getDeploymentGroupName() {
            return this.deploymentGroupName;
        }

        @Override
        public final Builder deploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
            return this;
        }

        public final void setDeploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
        }

        public final RevisionLocation getRevision() {
            return this.revision;
        }

        @Override
        public final Builder revision(RevisionLocation revision) {
            this.revision = revision;
            return this;
        }

        public final void setRevision(RevisionLocation revision) {
            this.revision = revision;
        }

        public final String getDeploymentConfigName() {
            return this.deploymentConfigName;
        }

        @Override
        public final Builder deploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        public final void setDeploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getIgnoreApplicationStopFailures() {
            return this.ignoreApplicationStopFailures;
        }

        @Override
        public final Builder ignoreApplicationStopFailures(Boolean ignoreApplicationStopFailures) {
            this.ignoreApplicationStopFailures = ignoreApplicationStopFailures;
            return this;
        }

        public final void setIgnoreApplicationStopFailures(Boolean ignoreApplicationStopFailures) {
            this.ignoreApplicationStopFailures = ignoreApplicationStopFailures;
        }

        public final TargetInstances getTargetInstances() {
            return this.targetInstances;
        }

        @Override
        public final Builder targetInstances(TargetInstances targetInstances) {
            this.targetInstances = targetInstances;
            return this;
        }

        public final void setTargetInstances(TargetInstances targetInstances) {
            this.targetInstances = targetInstances;
        }

        public final AutoRollbackConfiguration getAutoRollbackConfiguration() {
            return this.autoRollbackConfiguration;
        }

        @Override
        public final Builder autoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration;
            return this;
        }

        public final void setAutoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration;
        }

        public final Boolean getUpdateOutdatedInstancesOnly() {
            return this.updateOutdatedInstancesOnly;
        }

        @Override
        public final Builder updateOutdatedInstancesOnly(Boolean updateOutdatedInstancesOnly) {
            this.updateOutdatedInstancesOnly = updateOutdatedInstancesOnly;
            return this;
        }

        public final void setUpdateOutdatedInstancesOnly(Boolean updateOutdatedInstancesOnly) {
            this.updateOutdatedInstancesOnly = updateOutdatedInstancesOnly;
        }

        public final String getFileExistsBehavior() {
            return this.fileExistsBehavior;
        }

        @Override
        public final Builder fileExistsBehavior(String fileExistsBehavior) {
            this.fileExistsBehavior = fileExistsBehavior;
            return this;
        }

        @Override
        public final Builder fileExistsBehavior(FileExistsBehavior fileExistsBehavior) {
            this.fileExistsBehavior(fileExistsBehavior.toString());
            return this;
        }

        public final void setFileExistsBehavior(String fileExistsBehavior) {
            this.fileExistsBehavior = fileExistsBehavior;
        }

        public final void setFileExistsBehavior(FileExistsBehavior fileExistsBehavior) {
            this.fileExistsBehavior(fileExistsBehavior.toString());
        }

        public CreateDeploymentRequest build() {
            return new CreateDeploymentRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateDeploymentRequest> {
        public Builder applicationName(String var1);

        public Builder deploymentGroupName(String var1);

        public Builder revision(RevisionLocation var1);

        public Builder deploymentConfigName(String var1);

        public Builder description(String var1);

        public Builder ignoreApplicationStopFailures(Boolean var1);

        public Builder targetInstances(TargetInstances var1);

        public Builder autoRollbackConfiguration(AutoRollbackConfiguration var1);

        public Builder updateOutdatedInstancesOnly(Boolean var1);

        public Builder fileExistsBehavior(String var1);

        public Builder fileExistsBehavior(FileExistsBehavior var1);
    }
}

