/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployResponse;
import software.amazon.awssdk.services.codedeploy.model.InstanceSummary;
import software.amazon.awssdk.services.codedeploy.model.InstanceSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetDeploymentInstancesResponse
extends CodeDeployResponse
implements ToCopyableBuilder<Builder, BatchGetDeploymentInstancesResponse> {
    private static final SdkField<List<InstanceSummary>> INSTANCES_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchGetDeploymentInstancesResponse.getter(BatchGetDeploymentInstancesResponse::instancesSummary)).setter(BatchGetDeploymentInstancesResponse.setter(Builder::instancesSummary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instancesSummary").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BatchGetDeploymentInstancesResponse.getter(BatchGetDeploymentInstancesResponse::errorMessage)).setter(BatchGetDeploymentInstancesResponse.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCES_SUMMARY_FIELD, ERROR_MESSAGE_FIELD));
    private final List<InstanceSummary> instancesSummary;
    private final String errorMessage;

    private BatchGetDeploymentInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.instancesSummary = builder.instancesSummary;
        this.errorMessage = builder.errorMessage;
    }

    public List<InstanceSummary> instancesSummary() {
        return this.instancesSummary;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instancesSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetDeploymentInstancesResponse)) {
            return false;
        }
        BatchGetDeploymentInstancesResponse other = (BatchGetDeploymentInstancesResponse)((Object)obj);
        return Objects.equals(this.instancesSummary(), other.instancesSummary()) && Objects.equals(this.errorMessage(), other.errorMessage());
    }

    public String toString() {
        return ToString.builder((String)"BatchGetDeploymentInstancesResponse").add("InstancesSummary", this.instancesSummary()).add("ErrorMessage", (Object)this.errorMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instancesSummary": {
                return Optional.ofNullable(clazz.cast(this.instancesSummary()));
            }
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetDeploymentInstancesResponse, T> g) {
        return obj -> g.apply((BatchGetDeploymentInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeDeployResponse.BuilderImpl
    implements Builder {
        private List<InstanceSummary> instancesSummary = DefaultSdkAutoConstructList.getInstance();
        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetDeploymentInstancesResponse model) {
            super(model);
            this.instancesSummary(model.instancesSummary);
            this.errorMessage(model.errorMessage);
        }

        public final Collection<InstanceSummary.Builder> getInstancesSummary() {
            return this.instancesSummary != null ? (Collection)this.instancesSummary.stream().map(InstanceSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instancesSummary(Collection<InstanceSummary> instancesSummary) {
            this.instancesSummary = InstanceSummaryListCopier.copy(instancesSummary);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instancesSummary(InstanceSummary ... instancesSummary) {
            this.instancesSummary(Arrays.asList(instancesSummary));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instancesSummary(Consumer<InstanceSummary.Builder> ... instancesSummary) {
            this.instancesSummary(Stream.of(instancesSummary).map(c -> (InstanceSummary)((InstanceSummary.Builder)InstanceSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstancesSummary(Collection<InstanceSummary.BuilderImpl> instancesSummary) {
            this.instancesSummary = InstanceSummaryListCopier.copyFromBuilder(instancesSummary);
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public BatchGetDeploymentInstancesResponse build() {
            return new BatchGetDeploymentInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeDeployResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetDeploymentInstancesResponse> {
        public Builder instancesSummary(Collection<InstanceSummary> var1);

        public Builder instancesSummary(InstanceSummary ... var1);

        public Builder instancesSummary(Consumer<InstanceSummary.Builder> ... var1);

        public Builder errorMessage(String var1);
    }
}

