/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codedeploy.model.TimeBasedLinear;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TimeBasedLinearMarshaller {
    private static final MarshallingInfo<Integer> LINEARPERCENTAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("linearPercentage").isBinary(false).build();
    private static final MarshallingInfo<Integer> LINEARINTERVAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("linearInterval").isBinary(false).build();
    private static final TimeBasedLinearMarshaller INSTANCE = new TimeBasedLinearMarshaller();

    private TimeBasedLinearMarshaller() {
    }

    public static TimeBasedLinearMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TimeBasedLinear timeBasedLinear, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)timeBasedLinear, (String)"timeBasedLinear");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)timeBasedLinear.linearPercentage(), LINEARPERCENTAGE_BINDING);
            protocolMarshaller.marshall((Object)timeBasedLinear.linearInterval(), LINEARINTERVAL_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

