/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.transform.TimeBasedCanaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TimeBasedCanary
implements StructuredPojo,
ToCopyableBuilder<Builder, TimeBasedCanary> {
    private final Integer canaryPercentage;
    private final Integer canaryInterval;

    private TimeBasedCanary(BuilderImpl builder) {
        this.canaryPercentage = builder.canaryPercentage;
        this.canaryInterval = builder.canaryInterval;
    }

    public Integer canaryPercentage() {
        return this.canaryPercentage;
    }

    public Integer canaryInterval() {
        return this.canaryInterval;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.canaryPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.canaryInterval());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeBasedCanary)) {
            return false;
        }
        TimeBasedCanary other = (TimeBasedCanary)obj;
        return Objects.equals(this.canaryPercentage(), other.canaryPercentage()) && Objects.equals(this.canaryInterval(), other.canaryInterval());
    }

    public String toString() {
        return ToString.builder((String)"TimeBasedCanary").add("CanaryPercentage", (Object)this.canaryPercentage()).add("CanaryInterval", (Object)this.canaryInterval()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "canaryPercentage": {
                return Optional.ofNullable(clazz.cast(this.canaryPercentage()));
            }
            case "canaryInterval": {
                return Optional.ofNullable(clazz.cast(this.canaryInterval()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TimeBasedCanaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer canaryPercentage;
        private Integer canaryInterval;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeBasedCanary model) {
            this.canaryPercentage(model.canaryPercentage);
            this.canaryInterval(model.canaryInterval);
        }

        public final Integer getCanaryPercentage() {
            return this.canaryPercentage;
        }

        @Override
        public final Builder canaryPercentage(Integer canaryPercentage) {
            this.canaryPercentage = canaryPercentage;
            return this;
        }

        public final void setCanaryPercentage(Integer canaryPercentage) {
            this.canaryPercentage = canaryPercentage;
        }

        public final Integer getCanaryInterval() {
            return this.canaryInterval;
        }

        @Override
        public final Builder canaryInterval(Integer canaryInterval) {
            this.canaryInterval = canaryInterval;
            return this;
        }

        public final void setCanaryInterval(Integer canaryInterval) {
            this.canaryInterval = canaryInterval;
        }

        public TimeBasedCanary build() {
            return new TimeBasedCanary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TimeBasedCanary> {
        public Builder canaryPercentage(Integer var1);

        public Builder canaryInterval(Integer var1);
    }
}

