/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codedeploy.model.LastDeploymentInfo;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class LastDeploymentInfoMarshaller {
    private static final MarshallingInfo<String> DEPLOYMENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deploymentId").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").isBinary(false).build();
    private static final MarshallingInfo<Instant> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createTime").isBinary(false).build();
    private static final LastDeploymentInfoMarshaller INSTANCE = new LastDeploymentInfoMarshaller();

    private LastDeploymentInfoMarshaller() {
    }

    public static LastDeploymentInfoMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(LastDeploymentInfo lastDeploymentInfo, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)lastDeploymentInfo, (String)"lastDeploymentInfo");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)lastDeploymentInfo.deploymentId(), DEPLOYMENTID_BINDING);
            protocolMarshaller.marshall((Object)lastDeploymentInfo.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)lastDeploymentInfo.endTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)lastDeploymentInfo.createTime(), CREATETIME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

