/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.codedeploy.CodeDeployAsyncClient;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentInstancesResponse;

public class ListDeploymentInstancesPublisher
implements SdkPublisher<ListDeploymentInstancesResponse> {
    private final CodeDeployAsyncClient client;
    private final ListDeploymentInstancesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDeploymentInstancesPublisher(CodeDeployAsyncClient client, ListDeploymentInstancesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDeploymentInstancesPublisher(CodeDeployAsyncClient client, ListDeploymentInstancesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDeploymentInstancesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDeploymentInstancesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> instancesList() {
        Function<ListDeploymentInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.instancesList() != null) {
                return response.instancesList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDeploymentInstancesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final ListDeploymentInstancesPublisher resume(ListDeploymentInstancesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListDeploymentInstancesPublisher(this.client, (ListDeploymentInstancesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListDeploymentInstancesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListDeploymentInstancesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListDeploymentInstancesResponseFetcher
    implements AsyncPageFetcher<ListDeploymentInstancesResponse> {
        private ListDeploymentInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListDeploymentInstancesResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public CompletableFuture<ListDeploymentInstancesResponse> nextPage(ListDeploymentInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListDeploymentInstancesPublisher.this.client.listDeploymentInstances(ListDeploymentInstancesPublisher.this.firstRequest);
            }
            return ListDeploymentInstancesPublisher.this.client.listDeploymentInstances((ListDeploymentInstancesRequest)((Object)ListDeploymentInstancesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

