/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.codedeploy.model.ELBInfo;
import software.amazon.awssdk.services.codedeploy.model.ELBInfoListCopier;
import software.amazon.awssdk.services.codedeploy.model.TargetGroupInfo;
import software.amazon.awssdk.services.codedeploy.model.TargetGroupInfoListCopier;
import software.amazon.awssdk.services.codedeploy.transform.LoadBalancerInfoMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoadBalancerInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, LoadBalancerInfo> {
    private final List<ELBInfo> elbInfoList;
    private final List<TargetGroupInfo> targetGroupInfoList;

    private LoadBalancerInfo(BuilderImpl builder) {
        this.elbInfoList = builder.elbInfoList;
        this.targetGroupInfoList = builder.targetGroupInfoList;
    }

    public List<ELBInfo> elbInfoList() {
        return this.elbInfoList;
    }

    public List<TargetGroupInfo> targetGroupInfoList() {
        return this.targetGroupInfoList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.elbInfoList());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetGroupInfoList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancerInfo)) {
            return false;
        }
        LoadBalancerInfo other = (LoadBalancerInfo)obj;
        return Objects.equals(this.elbInfoList(), other.elbInfoList()) && Objects.equals(this.targetGroupInfoList(), other.targetGroupInfoList());
    }

    public String toString() {
        return ToString.builder((String)"LoadBalancerInfo").add("ElbInfoList", this.elbInfoList()).add("TargetGroupInfoList", this.targetGroupInfoList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "elbInfoList": {
                return Optional.ofNullable(clazz.cast(this.elbInfoList()));
            }
            case "targetGroupInfoList": {
                return Optional.ofNullable(clazz.cast(this.targetGroupInfoList()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LoadBalancerInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ELBInfo> elbInfoList = DefaultSdkAutoConstructList.getInstance();
        private List<TargetGroupInfo> targetGroupInfoList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancerInfo model) {
            this.elbInfoList(model.elbInfoList);
            this.targetGroupInfoList(model.targetGroupInfoList);
        }

        public final Collection<ELBInfo.Builder> getElbInfoList() {
            return this.elbInfoList != null ? (Collection)this.elbInfoList.stream().map(ELBInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder elbInfoList(Collection<ELBInfo> elbInfoList) {
            this.elbInfoList = ELBInfoListCopier.copy(elbInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elbInfoList(ELBInfo ... elbInfoList) {
            this.elbInfoList(Arrays.asList(elbInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elbInfoList(Consumer<ELBInfo.Builder> ... elbInfoList) {
            this.elbInfoList(Stream.of(elbInfoList).map(c -> (ELBInfo)((ELBInfo.Builder)ELBInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setElbInfoList(Collection<ELBInfo.BuilderImpl> elbInfoList) {
            this.elbInfoList = ELBInfoListCopier.copyFromBuilder(elbInfoList);
        }

        public final Collection<TargetGroupInfo.Builder> getTargetGroupInfoList() {
            return this.targetGroupInfoList != null ? (Collection)this.targetGroupInfoList.stream().map(TargetGroupInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targetGroupInfoList(Collection<TargetGroupInfo> targetGroupInfoList) {
            this.targetGroupInfoList = TargetGroupInfoListCopier.copy(targetGroupInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroupInfoList(TargetGroupInfo ... targetGroupInfoList) {
            this.targetGroupInfoList(Arrays.asList(targetGroupInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroupInfoList(Consumer<TargetGroupInfo.Builder> ... targetGroupInfoList) {
            this.targetGroupInfoList(Stream.of(targetGroupInfoList).map(c -> (TargetGroupInfo)((TargetGroupInfo.Builder)TargetGroupInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargetGroupInfoList(Collection<TargetGroupInfo.BuilderImpl> targetGroupInfoList) {
            this.targetGroupInfoList = TargetGroupInfoListCopier.copyFromBuilder(targetGroupInfoList);
        }

        public LoadBalancerInfo build() {
            return new LoadBalancerInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LoadBalancerInfo> {
        public Builder elbInfoList(Collection<ELBInfo> var1);

        public Builder elbInfoList(ELBInfo ... var1);

        public Builder elbInfoList(Consumer<ELBInfo.Builder> ... var1);

        public Builder targetGroupInfoList(Collection<TargetGroupInfo> var1);

        public Builder targetGroupInfoList(TargetGroupInfo ... var1);

        public Builder targetGroupInfoList(Consumer<TargetGroupInfo.Builder> ... var1);
    }
}

