/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.transform.DeploymentOverviewMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeploymentOverview
implements StructuredPojo,
ToCopyableBuilder<Builder, DeploymentOverview> {
    private final Long pending;
    private final Long inProgress;
    private final Long succeeded;
    private final Long failed;
    private final Long skipped;
    private final Long ready;

    private DeploymentOverview(BuilderImpl builder) {
        this.pending = builder.pending;
        this.inProgress = builder.inProgress;
        this.succeeded = builder.succeeded;
        this.failed = builder.failed;
        this.skipped = builder.skipped;
        this.ready = builder.ready;
    }

    public Long pending() {
        return this.pending;
    }

    public Long inProgress() {
        return this.inProgress;
    }

    public Long succeeded() {
        return this.succeeded;
    }

    public Long failed() {
        return this.failed;
    }

    public Long skipped() {
        return this.skipped;
    }

    public Long ready() {
        return this.ready;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pending());
        hashCode = 31 * hashCode + Objects.hashCode(this.inProgress());
        hashCode = 31 * hashCode + Objects.hashCode(this.succeeded());
        hashCode = 31 * hashCode + Objects.hashCode(this.failed());
        hashCode = 31 * hashCode + Objects.hashCode(this.skipped());
        hashCode = 31 * hashCode + Objects.hashCode(this.ready());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentOverview)) {
            return false;
        }
        DeploymentOverview other = (DeploymentOverview)obj;
        return Objects.equals(this.pending(), other.pending()) && Objects.equals(this.inProgress(), other.inProgress()) && Objects.equals(this.succeeded(), other.succeeded()) && Objects.equals(this.failed(), other.failed()) && Objects.equals(this.skipped(), other.skipped()) && Objects.equals(this.ready(), other.ready());
    }

    public String toString() {
        return ToString.builder((String)"DeploymentOverview").add("Pending", (Object)this.pending()).add("InProgress", (Object)this.inProgress()).add("Succeeded", (Object)this.succeeded()).add("Failed", (Object)this.failed()).add("Skipped", (Object)this.skipped()).add("Ready", (Object)this.ready()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Pending": {
                return Optional.ofNullable(clazz.cast(this.pending()));
            }
            case "InProgress": {
                return Optional.ofNullable(clazz.cast(this.inProgress()));
            }
            case "Succeeded": {
                return Optional.ofNullable(clazz.cast(this.succeeded()));
            }
            case "Failed": {
                return Optional.ofNullable(clazz.cast(this.failed()));
            }
            case "Skipped": {
                return Optional.ofNullable(clazz.cast(this.skipped()));
            }
            case "Ready": {
                return Optional.ofNullable(clazz.cast(this.ready()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeploymentOverviewMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Long pending;
        private Long inProgress;
        private Long succeeded;
        private Long failed;
        private Long skipped;
        private Long ready;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentOverview model) {
            this.pending(model.pending);
            this.inProgress(model.inProgress);
            this.succeeded(model.succeeded);
            this.failed(model.failed);
            this.skipped(model.skipped);
            this.ready(model.ready);
        }

        public final Long getPending() {
            return this.pending;
        }

        @Override
        public final Builder pending(Long pending) {
            this.pending = pending;
            return this;
        }

        public final void setPending(Long pending) {
            this.pending = pending;
        }

        public final Long getInProgress() {
            return this.inProgress;
        }

        @Override
        public final Builder inProgress(Long inProgress) {
            this.inProgress = inProgress;
            return this;
        }

        public final void setInProgress(Long inProgress) {
            this.inProgress = inProgress;
        }

        public final Long getSucceeded() {
            return this.succeeded;
        }

        @Override
        public final Builder succeeded(Long succeeded) {
            this.succeeded = succeeded;
            return this;
        }

        public final void setSucceeded(Long succeeded) {
            this.succeeded = succeeded;
        }

        public final Long getFailed() {
            return this.failed;
        }

        @Override
        public final Builder failed(Long failed) {
            this.failed = failed;
            return this;
        }

        public final void setFailed(Long failed) {
            this.failed = failed;
        }

        public final Long getSkipped() {
            return this.skipped;
        }

        @Override
        public final Builder skipped(Long skipped) {
            this.skipped = skipped;
            return this;
        }

        public final void setSkipped(Long skipped) {
            this.skipped = skipped;
        }

        public final Long getReady() {
            return this.ready;
        }

        @Override
        public final Builder ready(Long ready) {
            this.ready = ready;
            return this;
        }

        public final void setReady(Long ready) {
            this.ready = ready;
        }

        public DeploymentOverview build() {
            return new DeploymentOverview(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeploymentOverview> {
        public Builder pending(Long var1);

        public Builder inProgress(Long var1);

        public Builder succeeded(Long var1);

        public Builder failed(Long var1);

        public Builder skipped(Long var1);

        public Builder ready(Long var1);
    }
}

