/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.model.LifecycleErrorCode;
import software.amazon.awssdk.services.codedeploy.transform.DiagnosticsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Diagnostics
implements StructuredPojo,
ToCopyableBuilder<Builder, Diagnostics> {
    private final String errorCode;
    private final String scriptName;
    private final String message;
    private final String logTail;

    private Diagnostics(BuilderImpl builder) {
        this.errorCode = builder.errorCode;
        this.scriptName = builder.scriptName;
        this.message = builder.message;
        this.logTail = builder.logTail;
    }

    public String errorCode() {
        return this.errorCode;
    }

    public String scriptName() {
        return this.scriptName;
    }

    public String message() {
        return this.message;
    }

    public String logTail() {
        return this.logTail;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.errorCode() == null ? 0 : this.errorCode().hashCode());
        hashCode = 31 * hashCode + (this.scriptName() == null ? 0 : this.scriptName().hashCode());
        hashCode = 31 * hashCode + (this.message() == null ? 0 : this.message().hashCode());
        hashCode = 31 * hashCode + (this.logTail() == null ? 0 : this.logTail().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Diagnostics)) {
            return false;
        }
        Diagnostics other = (Diagnostics)obj;
        if (other.errorCode() == null ^ this.errorCode() == null) {
            return false;
        }
        if (other.errorCode() != null && !other.errorCode().equals(this.errorCode())) {
            return false;
        }
        if (other.scriptName() == null ^ this.scriptName() == null) {
            return false;
        }
        if (other.scriptName() != null && !other.scriptName().equals(this.scriptName())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        if (other.message() != null && !other.message().equals(this.message())) {
            return false;
        }
        if (other.logTail() == null ^ this.logTail() == null) {
            return false;
        }
        return other.logTail() == null || other.logTail().equals(this.logTail());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.errorCode() != null) {
            sb.append("ErrorCode: ").append(this.errorCode()).append(",");
        }
        if (this.scriptName() != null) {
            sb.append("ScriptName: ").append(this.scriptName()).append(",");
        }
        if (this.message() != null) {
            sb.append("Message: ").append(this.message()).append(",");
        }
        if (this.logTail() != null) {
            sb.append("LogTail: ").append(this.logTail()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DiagnosticsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String errorCode;
        private String scriptName;
        private String message;
        private String logTail;

        private BuilderImpl() {
        }

        private BuilderImpl(Diagnostics model) {
            this.setErrorCode(model.errorCode);
            this.setScriptName(model.scriptName);
            this.setMessage(model.message);
            this.setLogTail(model.logTail);
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(LifecycleErrorCode errorCode) {
            this.errorCode(errorCode.toString());
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final void setErrorCode(LifecycleErrorCode errorCode) {
            this.errorCode(errorCode.toString());
        }

        public final String getScriptName() {
            return this.scriptName;
        }

        @Override
        public final Builder scriptName(String scriptName) {
            this.scriptName = scriptName;
            return this;
        }

        public final void setScriptName(String scriptName) {
            this.scriptName = scriptName;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getLogTail() {
            return this.logTail;
        }

        @Override
        public final Builder logTail(String logTail) {
            this.logTail = logTail;
            return this;
        }

        public final void setLogTail(String logTail) {
            this.logTail = logTail;
        }

        public Diagnostics build() {
            return new Diagnostics(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Diagnostics> {
        public Builder errorCode(String var1);

        public Builder errorCode(LifecycleErrorCode var1);

        public Builder scriptName(String var1);

        public Builder message(String var1);

        public Builder logTail(String var1);
    }
}

