/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.codedeploy.model.InstanceNameListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchGetOnPremisesInstancesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, BatchGetOnPremisesInstancesRequest> {
    private final List<String> instanceNames;

    private BatchGetOnPremisesInstancesRequest(BuilderImpl builder) {
        this.instanceNames = builder.instanceNames;
    }

    public List<String> instanceNames() {
        return this.instanceNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceNames() == null ? 0 : this.instanceNames().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetOnPremisesInstancesRequest)) {
            return false;
        }
        BatchGetOnPremisesInstancesRequest other = (BatchGetOnPremisesInstancesRequest)((Object)obj);
        if (other.instanceNames() == null ^ this.instanceNames() == null) {
            return false;
        }
        return other.instanceNames() == null || other.instanceNames().equals(this.instanceNames());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instanceNames() != null) {
            sb.append("InstanceNames: ").append(this.instanceNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> instanceNames = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetOnPremisesInstancesRequest model) {
            this.setInstanceNames(model.instanceNames);
        }

        public final Collection<String> getInstanceNames() {
            return this.instanceNames;
        }

        @Override
        public final Builder instanceNames(Collection<String> instanceNames) {
            this.instanceNames = InstanceNameListCopier.copy(instanceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceNames(String ... instanceNames) {
            if (this.instanceNames == null) {
                this.instanceNames = new SdkInternalList(instanceNames.length);
            }
            for (String e : instanceNames) {
                this.instanceNames.add(e);
            }
            return this;
        }

        public final void setInstanceNames(Collection<String> instanceNames) {
            this.instanceNames = InstanceNameListCopier.copy(instanceNames);
        }

        @SafeVarargs
        public final void setInstanceNames(String ... instanceNames) {
            if (this.instanceNames == null) {
                this.instanceNames = new SdkInternalList(instanceNames.length);
            }
            for (String e : instanceNames) {
                this.instanceNames.add(e);
            }
        }

        public BatchGetOnPremisesInstancesRequest build() {
            return new BatchGetOnPremisesInstancesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchGetOnPremisesInstancesRequest> {
        public Builder instanceNames(Collection<String> var1);

        public Builder instanceNames(String ... var1);
    }
}

